/*
 * GetFont(name,filename) -> fontnum (or NOFONT if font not found)
 * Finds the font called 'name'. If it already is in the FontTable Fonts,
 * (case is ignored) returns its number, else uses 'filename' to read it
 * from a remote file server.
 * Change to alloc copy of name. PB May 83
 * Jan 1984. Bug fixes: close file on failure. Initialize fnt->name = NULL.
 */
#include <Vfont.h>
#define FONT Vfont
#include <fonttable.h>
#include <stdio.h>

extern char *malloc(), *strcpy();
extern char FontDirectory[];
extern Vfont *LoadGenericFont();

FontEntry *
GetFontEntry(name,filename, options)
  char *name,		/* name of font; e.g Helvetica12I. Must be stable! */
       *filename;	/* name of file to read font from */
  {
    register int i; char *cp; SystemCode error;
    register FontEntry *fnt; register FontLink *link;
    /* see if font already loaded. First try the static first 16 */
    for (fnt = Fonts.first16; fnt < Fonts.first16 + 16; fnt++)
        if (EqString(name, fnt->name))
	    if (fnt->font) return(fnt); else goto readFont;

    /* it's not in the first16; check if in linked list */
    for (link = Fonts.next; link != NULL; link = link->next)
	if (EqString(name, link->fontEntry.name))
	    if (link->fontEntry.font) return((FontEntry *)link);
	    else {fnt = (FontEntry *)link; goto readFont;}

    /* Nope; find an empty slot */
    for (i = 15, fnt = Fonts.first16; i >= 0; i--, fnt++)
        if (fnt->name == NULL) {fnt->number = 15 - i; goto readFont;}

    /* no space in the static part of Fonts; try the linked list part */
    link = (FontLink *)(Fonts.first16 + 15);
    for (;;)
      {
	fnt = (FontEntry *)(link->next);
	if (fnt == NULL)
	    if (link->fontEntry.number == NOFONT) return((FontEntry *)TooManyFonts);
	    else break;
	if (fnt->name == NULL) goto readFont;
	if (link->fontEntry.number + 1 < fnt->number) break;
	link = (FontLink *)fnt;
      }

    /* link in a new FontLink  just after *link */
    fnt = (FontEntry *)(malloc(sizeof(FontLink)));
    ((FontLink *)fnt)->next = link->next;
    link->next = (FontLink *)fnt;
    fnt->number = link->fontEntry.number + 1;
    fnt->name = NULL;

  readFont:
    fnt->italic = NOFONT;
    fnt->bold = NOFONT;
    if (filename)
	fnt->font = (FONT*)LoadGenericFont(0, filename, options, &error);
    else
      { char buf[100], *nameStart; int periods = 0;
	strcpy(buf, FontDirectory);
	nameStart = buf + strlen(buf);
	strcpy(nameStart, name);
	for (cp = nameStart; *cp; cp++)
	    if (*cp >= 'A' && *cp <= 'Z') *cp += 'a' - 'A';
	    else if (*cp == '.') periods++;
	if (periods == 0) *cp++ = '.';
	*cp++ = 'g'; *cp++ = 'f'; *cp = '\0';
	fnt->font = (FONT*)LoadGenericFont(0, nameStart, options, &error);
	if (fnt->font == NULL) /* try with FONTDIR prepended */
	    fnt->font = (FONT*)LoadGenericFont(0, buf, options, &error);
      }
    if (error != OK)
      {
	fnt->name = NULL; fnt->font = NULL;
	fnt = NULL;
      }
    else if (!fnt->name)
	fnt->name = strcpy(malloc(strlen(name) + 1), name);
    return(fnt);
  }

EqString(s1, s2)
register char *s1, *s2;
/* test if strings s1 and s2 are equal, ignoring case.
 * s1 must be != 0. s2 can be 0, in which case 0 is returned.
 */
  {
    if (!s2) return(0);
    for (;;)
      { register char c1 = *s1++, c2 = *s2++;
	if (c1 >= 'A' && c1 <= 'Z') c1 += 'a' - 'A';
	if (c2 >= 'A' && c2 <= 'Z') c2 += 'a' - 'A';
	if (c1 != c2) return(0);
	if (!c1) return(1);
      }
  }

GetFont(name, filename, options)
  char *name,		/* name of font; e.g Helvetica12I. Must be stable! */
       *filename;	/* name of file to read font from */
  { FontEntry *fnt;
    if ((fnt = GetFontEntry(name, filename, options)) == NULL)
	return(NOFONT);
    return(((FontEntry *) fnt)->number);
  }
