#include "Vio.h"
#include "Vnaming.h"
#include "Vioprotocol.h"

/*
 * Start a program running remotely and return FAD(s) which can be used
 * to communicate with program.
 * Arguments:
 * ProcessFAD -- reference parameter.
 * prog -- string containing the program name to be executed
 * args -- array of null terminated strings which are to be the arguments
 * 	   to the program, the array must be terminated with a NULL pointer.
 * mode -- open mode of process, eg. FREAD, FCREATE.
 * 
 * Returns: OK if valid, else error number.
 * ProcessFAD[0] -- Reading from the process.
 * ProcessFAD[1] -- Writing to the process. (will be NULL if mode == FREAD).
 *
 */

#define MAX_PROG_ARGS_LEN	4096

SystemCode RemoteExecute( ProcessFAD, prog, args, mode ) 
    File *ProcessFAD[];
    char *prog;
    char *args[];
    unsigned short mode;

  {
    extern File *_Open(), *OpenFile();
    extern ProcessId FileServer(), GetPid();
    CreateInstanceRequest request;
    ProcessId pid;
    SystemCode error;
    char *progargs = (char *) malloc(MAX_PROG_ARGS_LEN + 1);
    register int length;
    register char *a,*b;


    /* Format the arguments */
    for( a = progargs, b = prog, length = 0
         ; (*a++ = *b++) != NULL ; )
	 if ( ++length >= MAX_PROG_ARGS_LEN ) /* will not count NULL */
		goto bad_args;

    if ( length == 0 ) goto bad_args;
	     
    while( (b = *args++ ) != NULL )
      {
	while( (*a++ = *b++) != NULL)
	    if ( ++length >= MAX_PROG_ARGS_LEN ) goto bad_args;
	length++; /* count NULL */
      }

    request.requestcode = CREATE_INSTANCE;
    request.filename = progargs;
    request.filenamelen = length;
    request.filenameindex = 0; /* Use the entire progargs */

    mode |= FRELEASE_ON_CLOSE | FEXECUTE;

    ProcessFAD[1] = NULL;
    ProcessFAD[0] = _Open( &request, mode, 0, &error );
    if ( !(mode & FREAD) && ProcessFAD[0] != NULL)
      {
	ProcessFAD[1] = ProcessFAD[0];
	ProcessFAD[0] = OpenFile( FileServer( ProcessFAD[1] ),
			          FileId( ProcessFAD[1] ) + 1 ,
			 	  FREAD|FRELEASE_ON_CLOSE, &error );
      }

    free(progargs);
    return ( (ProcessFAD[0] == NULL) ? error : OK );

bad_args:
    free(progargs);
    return( BAD_ARGS );

  } /* RemoteExecute */
