/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1985				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to select hosts for remote execution using multicast group 
 * communciation.
 *
 * Marvin Theimer
 */


#include <Venviron.h>
#include <Vio.h>
#include <Vdirectory.h>
#include <Vgroupids.h>
#include <Vquerykernel.h>
#include "Vteams.h"

# define FALSE 0
# define TRUE 1


/*
 * QueryHostsViaMulticast:
 * Returns descriptor records for hosts selected in descArray 
 * which meet the selection criteria specified.  At most numHosts 
 * selections are returned.  
 * The number of hosts actually selected is returned as the funtion
 * value.
 *
 * Uses the group communication facilities to do the selection.
 *
 * NOTE: Does not support spec->hostName currently.
 */

int QueryHostsViaMulticast(spec, descArray, numHosts, error)
    SelectionRec *spec;	/* Host selection spec.  NULL => default specs. */
    SelectionRec *descArray;
			/* Array for returning descriptors of selected 
			   hosts. */
    int numHosts;	/* Maximum number of selections to return.
			   Also the size of pidArray. */
    SystemCode *error;	/* Status code. */
  {
    int nHosts;
    Message msg;
    struct hostStatMsg *desc = (struct hostStatMsg *) msg;
    ProcessId pid;
    SelectionRec newSpec;

    desc->requestcode = HOST_STATUS;
    desc->avail = AVAIL_RELEVANT | AVAILABLE;
    if (spec == NULL)
      {
	spec = &newSpec;
	DefaultSelectionRec(spec);
      }
    desc->freeTeams = spec->freeTeams;
    desc->freeProcs = spec->freeProcs;
    desc->minFreeMem = spec->minFreeMem;
    desc->maxFreeMem = spec->maxFreeMem;
    desc->minIdleTime = spec->minIdleTime;
    desc->maxIdleTime = spec->maxIdleTime;
    desc->procMachType = spec->procMachType;

    pid = Send(desc, VTEAM_SERVER_GROUP);
    *error = desc->requestcode;
    nHosts = 0;
    if ((pid != 0) && (*error == OK))
      {
	nHosts++;
	descArray->freeTeams = desc->freeTeams;
	descArray->freeProcs = desc->freeProcs;
	descArray->minFreeMem = desc->minFreeMem;
	descArray->maxFreeMem = desc->maxFreeMem;
	descArray->minIdleTime = desc->minIdleTime;
	descArray->maxIdleTime = desc->maxIdleTime;
	descArray->procMachType = desc->procMachType;
	descArray->teamServerPid = pid;
	descArray++;
      }
    while (nHosts < numHosts)
      {
	pid = GetReply(desc, 100);
	*error = desc->requestcode;
	if ((pid == 0) || (*error != OK))
	  {
	    return(nHosts);
	  }
	nHosts++;
	descArray->freeTeams = desc->freeTeams;
	descArray->freeProcs = desc->freeProcs;
	descArray->minFreeMem = desc->minFreeMem;
	descArray->maxFreeMem = desc->maxFreeMem;
	descArray->minIdleTime = desc->minIdleTime;
	descArray->maxIdleTime = desc->maxIdleTime;
	descArray->procMachType = desc->procMachType;
	descArray->teamServerPid = pid;
	descArray++;
      }

    if ((spec != NULL) && (spec->hostName != NULL))
      {
        *error = REQUEST_NOT_SUPPORTED;
	return(0);
      }

    return(nHosts);
  }
