/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1985				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to select hosts for remote execution via a central server.
 *
 * Marvin Theimer
 */


#include <Venviron.h>
#include <Vio.h>
#include <Vdirectory.h>
#include <Vgroupids.h>
#include <Vquerykernel.h>
#include "Vteams.h"
#include "Vservice.h"

# define FALSE 0
# define TRUE 1


/*
 * QueryHostsViaCS:
 * Returns descriptor records for hosts selected in descArray 
 * which meet the selection criteria specified.  At most numHosts 
 * selections are returned.  
 * The number of hosts actually selected is returned as the funtion
 * value.
 *
 * Uses a central server to do the selection.
 */

int QueryHostsViaCS(spec, descArray, numHosts, error)
    SelectionRec *spec;	/* Host selection spec.  NULL => default specs. */
    SelectionRec *descArray;
			/* Array for returning descriptors of selected 
			   hosts. */
    int numHosts;	/* Maximum number of selections to return.
			   Also the size of pidArray. */
    SystemCode *error;	/* Status code. */
  {
    static ProcessId server = 0;
    Message msg;
    SelectObjectsRequest *reqMsg = (SelectObjectsRequest *) msg;
    register int  i;
    int n, m, size;
    char *desc;
    extern char *malloc();
    register char *p, *p1;

    if (!ValidPid(server))
				/* Our cached pid is no longer good. */
      {
	server = GetPid(SERVICE_SERVER, ANY_PID);
	if (server == 0)
	  {
	    *error = SERVER_NOT_RESPONDING;
	    return(0);
	  }
      }

    n = strlen(HOST_TYPE);
    if (spec->hostName == NULL)
      {
        m = 0;
      }
    else
      {
	m = strlen(spec->hostName);
      }
    size = n + sizeof(SelectionRec) + m;
    desc = malloc(size);
    if (desc == NULL)
      {
	*error = NO_MEMORY;
	return(0);
      }
    strcpy(desc, HOST_TYPE);
    p = desc + n;
    p1 = (char *) spec;
    for (i = 0; i < sizeof(SelectionRec); i++)
      {
	*p++ = *p1++;
      }
    if (spec->hostName != NULL)
      {
	strcat(p, spec->hostName);
	spec->hostName = (char *) (n + sizeof(SelectionRec));
      }

    reqMsg->requestcode = CREATE_SELECTION_INSTANCE;
    reqMsg->howMany = numHosts;
    reqMsg->patternFcn = 2;
    reqMsg->patternIndex = n;
    reqMsg->bufferptr = desc;
    reqMsg->bytecount = size;
    Send(msg, server);
    if (reqMsg->requestcode != OK)
      {
	*error = reqMsg->requestcode;
	return(0);
      }
  }
