/* Internal support routines only - subject to change without notice! */

#include <Vio.h>
#include <Vteams.h>

extern char *GetTeamSize();

#define LineLength 128		/* Max size of a char. string buffers */

/* Align pointer p to the next b-byte boundary, assuming b is a power of 2. */
#define align(p, b) (  (p) + ( -(int)(p) & ((b)-1) )  )

ProcessId LoadTeamFromFile(teamServerPid, progFile, name, concurrent, argv,
    			   rtMsg, debugRtMsg, error)
    ProcessId teamServerPid;
    File *progFile;
    char *name;
    int concurrent;
    char **argv;
    RootMessage *rtMsg, *debugRtMsg;
    SystemCode *error;
    /* Attempts to create and load a new team on the host with team 
     * server "teamServerPid".  The program binary is loaded from the 
     * file "progFile".  "name" is the program's name (including leading 
     * directories) - this is used by the team server.
     * Returns the pid of the new team or 0 on error.
     */
  {
    ProcessId newPid;
    Message msg;
    register LoadTeamRequest *reqMsg = (LoadTeamRequest *) msg;
#define repMsg ((LoadTeamReply *)reqMsg)
    char argsBuf[LineLength];
    register char *curPtr = argsBuf, *f;
    int len;
    short nameLength;

    /* Package up the parameters: filename and root messages. */
    nameLength = strlen(name);
    strcpy(curPtr, name);
    curPtr += nameLength + 1;

    f = (char *) rtMsg;
    len = sizeof(RootMessage);
    while (len-- > 0)
	*curPtr++ = *f++;
    f = (char *) debugRtMsg;
    len = sizeof(RootMessage);
    while (len-- > 0)
	*curPtr++ = *f++;

    /* Construct load request message. */    
    reqMsg->requestcode = TeamLoadRequest;
    reqMsg->bufferptr = argsBuf;
    reqMsg->bytecount = curPtr - argsBuf;
    reqMsg->fileserver = progFile->fileserver;
    reqMsg->fileid = progFile->fileid;
    reqMsg->noOwner = concurrent;
    
    /* Send msg to team server and get back the rootPid of the new team or an
       error. */
    Send(reqMsg, teamServerPid);
    
    if (repMsg->replycode != OK)
      {
        *error = repMsg->replycode;
	Close(progFile);
	return(0);
      }

    SetInstanceOwner(progFile->fileserver, progFile->fileid, teamServerPid);
    progFile->type &= ~FRELEASE_ON_CLOSE;  /* don't release the instance */
    Close(progFile);

    newPid = repMsg->rootPid;
    curPtr = align(repMsg->teamend + INIT_STACK_SIZE, 4);  /* TEB location */
    ReceiveSpecific(msg, newPid);
    if (argv != NULL)
      {
	rtMsg->envblock = curPtr;
	*error = SetUpEnvironment(newPid, argv, *PerProcess->env,
			*PerProcess->namecache, curPtr);
	if (*error != OK) return (0);
      }

    *error = OK;
    return(newPid);
  }


