/* Internal support routines only - subject to change without notice! */

#include <Vio.h>
#include <Vteams.h>
#include <Vquerykernel.h>

extern ProcessId LoadTeamFromFile();
extern FindMatchingProgs();

/* ArbLoadProgram() is an intermediate routine that is used to load programs 
 * on an `arbitrary' host, as specified by the selection record "hostSpec".
 *
 * This routine works by first invoking FindMatchingProgs(), which returns 
 * basically a set of (processor family, file ptr) pairs, one for each 
 * processor family that can run the program.
 * Using this information, an appropriate host is then selected, and 
 * LoadTeamFromFile() is then invoked to actually load the program.
 *
 * This approach has the advantage that we are able to separate host 
 * selection from path searching and program loading.
 * If FindMatchingProgs() becomes efficient enough, then someday we 
 * might be able to implement specific host execution in a similar way.
 */
ProcessId ArbLoadProgram(argv, hostSpec, rtMsg, path, concurrent, error)
    char *argv[];
    register SelectionRec *hostSpec;	/* Specifies the host to execute on. */
    RootMessage *rtMsg;
    char *path;
    int concurrent;
    SystemCode *error;
  {
    SelectionRec foundHostSpec[2];
    int indx;
    File *foundProgFiles[NUM_PROC_FAMILIES];
    File *chosenProgFile;
    int procFamilyIndex;
    unsigned char procFamily;
    char *progName;
    register int i;

    FindMatchingProgs(foundProgFiles, &progName, argv, path, error);
    if (*error)
	return(0);

    /* Set the "procMachType" field of "hostSpec", depending on what versions 
     * we found.
     */
    /* Note: for now we ignore the present value of the "procMachType" field,
     * and also the "hostName" field.  However, this could change in the future.
     */
/*TEMPORARY!*/
    /* NOTE: At present we can indicate only "all processor families" 
     * or "processor family x" - not an arbitrary set of processor families.  
     * At the moment this doesn't hurt us, because we only support two 
     * different processor families anyway.  However, this is something else 
     * that will need to be fixed.
     */
      {
	File *m68kProgFile = foundProgFiles[PROC_FAM_68000>>PROC_FAMILY_SHIFT];
	File *vaxProgFile  = foundProgFiles[PROC_FAM_VAX11>>PROC_FAMILY_SHIFT];

	hostSpec->procMachType &= ~PROC_FAMILY_FIELD;
	if (m68kProgFile != NULL)
	    if (vaxProgFile != NULL)		/* both m68k and vax */
		hostSpec->procMachType |= PROC_FAMILY_IRRELEVANT;
	    else				/* m68k only */
		hostSpec->procMachType |= (PROC_FAM_68000>>PROC_FAMILY_SHIFT);
	else if (vaxProgFile != NULL)		/* vax only */
	    hostSpec->procMachType |= (PROC_FAM_VAX11>>PROC_FAMILY_SHIFT);
	else					/* neither */
	    return(NULL);
      }

    /* Select a host.  Ask for two in case the first is the local one. */
      {
	int numHostsFound = QueryHosts(hostSpec, foundHostSpec, 2, error);
	
	if (*error != OK || numHostsFound == 0)
	  {
	    *error = SERVER_NOT_RESPONDING;
	    return(0);
	  }
	if (GetPid(TEAM_SERVER, LOCAL_PID) != foundHostSpec[0].teamServerPid)
	  {
	    indx = 0;
	  }
	else if (numHostsFound > 1)
	  {
	    indx = 1;
	  }
	else
	  {
	    *error = SERVER_NOT_RESPONDING;
	    return(0);
	  }
	hostSpec->teamServerPid = foundHostSpec[indx].teamServerPid;
      }

    /* Close the program file versions that we don't need. */
    procFamilyIndex = foundHostSpec[indx].procMachType&PROC_FAMILY_FIELD;
    procFamily = procFamilyIndex<<PROC_FAMILY_SHIFT;
    if ((procFamilyIndex < 0) || (procFamilyIndex >= NUM_PROC_FAMILIES))
      {
	*error = INTERNAL_ERROR;
	return(0);
      }
    chosenProgFile = foundProgFiles[procFamilyIndex];
    for (i = 0; i < NUM_PROC_FAMILIES; ++i)
        if (foundProgFiles[i] != chosenProgFile)
	    Close(foundProgFiles[i]);
    
    /* Finally, load the new team from the chosen file. */
    return LoadTeamFromFile(hostSpec->teamServerPid, chosenProgFile, progName,
    			    concurrent, argv, rtMsg, rtMsg, error);

  }
