#include <Vprocess.h>

extern char *ErrorString();


/*
 * Primitive stack dump package.
 */
StackDump(pid, fout)
  {
    ProcessId	pid;
    unsigned	*Fp;
    unsigned	*Ap;
    unsigned	Pc;
    unsigned	numArgs;
    unsigned	arg;
    ProcessBlock	desc;

    fprintf(fout, "\nStackDump:\n");
    if (pid != QueryProcessState(pid, &desc))
      {
	fprintf(fout, "Can't query process %x\n", pid);
	return;
      }
    Ap = (unsigned *)desc.ps.proc_state.regs[12];
    Fp = (unsigned *)desc.ps.proc_state.regs[13];

    if (! ((unsigned)Fp >= 0x200 && (char *)Fp < desc.team_size) )
      {
	fprintf(fout, "Invalid frame pointer (%x).\n", Fp);
	return;
      }

    while ((unsigned)Fp >= 0x200 && (char *)Fp < desc.team_size)
      {
	/* Pc = Fp[4]; */
	if (GetFromAddrSpace(pid, &Pc, Fp + 4, "Can't get Pc", fout))
	    return;
	fprintf(fout, "?(");
	/* numArgs = *Ap; */
	if (GetFromAddrSpace(pid, &numArgs, Ap, "Can't get numargs", fout))
	    return;
	if (numArgs < 20) {
	    for (; numArgs > 1; numArgs--)
	      {
		Ap++;
		if (GetFromAddrSpace(pid, &arg, Ap, "Can't get param", fout))
		    return;
		fprintf(fout, "%x, ", arg);
	      }
	    if (numArgs > 0)
	      {
		Ap++;
		if (GetFromAddrSpace(pid, &arg, Ap, "Can't get param", fout))
		    return;
		fprintf(fout, "%x", arg);
	      }
	}
	else
	  {
	    fprintf(fout, "%x args", numArgs);
	  }
	fprintf(fout, ") Called from %x\n", Pc);
	if (Pc > 0x400000)
	    return;
	
	/* Ap = (unsigned *)Fp[2]; */
	if (GetFromAddrSpace(pid, &Ap, Fp + 2, "Can't get Ap", fout))
	    return;
	/* Fp = (unsigned *)Fp[3]; */
	if (GetFromAddrSpace(pid, &Fp, Fp + 3, "Can't get Fp", fout))
	    return;
      }
  }

int GetFromAddrSpace(pid, dest, src, errmsg, fout)
    ProcessId pid;
    char *src;
    char *errmsg;
  {
    SystemCode errcode;
    /* *dest = *src */
    errcode = MoveFrom(pid, dest, src, sizeof(int));
    if (errcode != OK)
      {
	fprintf(fout, "%s: %s", errmsg, ErrorString(errcode));
	return(1);
      }
    return(0);
  }
