/*
 * Routine to print out the stack of the current process (in hex).
 */

#include <Vprocess.h>
#include <Vio.h>

extern *a6;


PrintStackDump(fout, pid)
    File *fout;
    ProcessId pid;
  {
    int flag = 0;
    ProcessBlock pb;
    unsigned *currentFp;
    unsigned *returnPc;
    unsigned teamSize;
    int i, nparams;

    if (pid == 0)
      {
	pid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
      }
    if (!SameTeam(pid, GetPid(ACTIVE_PROCESS, LOCAL_PID)))
      {
	fprintf(fout, "Not on same team: 0x%x\n", pid);
	return;
      }
    fprintf(fout, "\r\nStackDump for %x:\n", pid);
    if (QueryProcessState( pid, &pb ) != pid)
      {
	fprintf(fout, "Invalid Process Identifier 0x%x\n", pid );
	return;
      }
    currentFp = (unsigned *) pb.ps.proc_state.regs[14];

    teamSize = (unsigned) GetTeamSize(pid);
    if (((unsigned)currentFp < TEAM_ORIGIN) ||
        ((unsigned)currentFp > teamSize))
      {
	fprintf(fout, "Invalid frame pointer: %x\n", currentFp);
	return;
      }
    while ((unsigned)currentFp > TEAM_ORIGIN)
      {
	returnPc = (unsigned *) (*(currentFp + 1));
	if ((((unsigned) returnPc) < TEAM_ORIGIN) || 
	    (((unsigned) returnPc) > teamSize))
	  {
	    fprintf(fout, "Invalid return address: %x\n", returnPc);
	    return;
	  }
	fprintf(fout, "    %x (", returnPc);
	nparams = GetNumberOfParams(returnPc);
	for (i = 0; i < nparams; i++)
	  {
	    fprintf(fout, "%x", *(currentFp + 2 + i));
	    if (i < (nparams - 1))
	      {
		fprintf(fout, ", ");
	      }
	  }
	fprintf(fout, ")\n");
	currentFp = (unsigned *) (*currentFp);
      }
  }


#define ADDQL4		0x588f	/* instruction to add 4 to stack pointer */
#define ADDQL8		0x508f	/* instruction to add 8 to stack pointer */
#define ADDL		0xdffc 	/* instruction to add contents of next long to
				    stack pointer */
#define ADDW		0xdefc 	/* instruction to add contents of next word to
				    stack pointer */
#define LEA		0x4fef	/* a faster version of ADDW */

#define MAX_NUM_ARGS 10

static int GetNumberOfParams( returnpc )
    unsigned short *returnpc;
  {
    /* Return the number of parameters in the call to abort, and the address
     * of the first (topmost, lowest addressed) parameter.
     */
    unsigned short instruction;
    unsigned short *addr;
    int count;
    int nparams;

    instruction = *returnpc;

    /* The instruction at the return address tells (at least in our compiler's
     * calling convention) how much to add to the stack pointer upon return
     * from the call.  If we divide that number by the size of each stack
     * entry, we get the number of parameters.  This same trick is used in
     * the debugger's stackdump.
     */

    addr = returnpc + 1;
    switch( instruction )
      {
	case ADDQL4 :
	    return( 1 );
	case ADDQL8 :  
	    return( 2 );
	case LEA    :
	case ADDW   :  
	    count = (int) *addr;
	    break;
	case ADDL   :  
	    count = (int) *((unsigned *)addr);
	    break;
        default     :  
	    return( 0 );
      }
    nparams = count / 4;
    if( nparams > MAX_NUM_ARGS )
      {
	return( 0 );
      }
    return( nparams );
  }
