/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Kernel Ethernet driver
 * Hacked into a standalone version for the bootstrap loader,
 *   11/11/83 by TPM.
 */

#include "process.h"
#include "Vethernet.h"
#include "Vikc.h"
#include "deqna.h"
#define MAXLOOPCOUNT 200000

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

#define CopyMsg(to, from) Copy(to, from, 32)

/* Exports */
extern SystemCode	EnetPowerup();
extern SystemCode	AwaitKernelPacket();
extern int		WriteKernelPacket();
int KernelPacketType =  KERNEL_PACKET;
char	HexEnetAddress[sizeof(NetAddress)*2 + 1];
kPacketWithSegment	*kPacketSave;	/* Save area for kernel packets */

static NetAddress	EnetHostNumber;		/* physical ethernet address */
static EnetBlock	*EnetPacket;
static NetAddress	ServerHostAddress;	/* A one-address "cache" */
static int		ServerLogicalHost = -1;

static NetAddress	BroadcastAddress = { 0xFFFF, 0xFFFF, 0xFFFF };
static char		Broadcast[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
static NetAddress	VMulticastAddr = V_MULTICAST_ADDRESS;
static char		VMultiCast[6];

static Qna_t	Buffers;	/* The Enet buffer structure */
static int	RcvIndex;	/* The receive buffer we are currently using */
static int	LastValidBuffer;/* The last valid buffer */
static kPacketWithSegment	PacketSave;



SystemCode EnetPowerup()
  /* Powerup and initialize the Ethernet Interface Board.
   *  Done just once, from kernel Powerup() routine. 
   */
  {
    extern Process	*Active;
    register unsigned short *i;
    
    /* get my host address */
    i = &Deqna->enet_addr[0];
    EnetHostNumber.addrhigh = ((i[0] & 0xFF) << 8) | (i[1] & 0xFF);
    EnetHostNumber.addrmid  = ((i[2] & 0xFF) << 8) | (i[3] & 0xFF);
    EnetHostNumber.addrlow  = ((i[4] & 0xFF) << 8) | (i[5] & 0xFF);
    
    sprintf(HexEnetAddress, "%04x%04x%04x",
    	EnetHostNumber.addrhigh,
	EnetHostNumber.addrmid,
	EnetHostNumber.addrlow);
    
    swab(&VMulticastAddr, VMultiCast, sizeof(VMulticastAddr));
    
    Active->pid = (((EnetHostNumber.addrlow + K_ticks())<<16)
		   + EnetHostNumber.addrmid) | LITTLE_ENDIAN_HOST;
    kPacketSave = &PacketSave;

    /* Ignore deqna's interrupt vector */

    EnetReset( ENET_DEFAULT_MASK );

    return( OK );
 }


EnetReset( receiveMask )
    int receiveMask;
  {
    register int i, j, time;
    register QNABD_t *bdl;
    short	rcvMode;
    unsigned short	csr;

    /* We need to convert receiveMask into a rcvMode the deqna understands. */
    rcvMode = (receiveMask & ENET_BROADCAST ? QNA_AllMultiCast : 0) |
    		(receiveMask & ENET_PROMISCUOUS ? QNA_Promiscuous : 0);
    rcvMode += sizeof(Buffers.setupbuff);

    /* reset the deqna */
    Deqna->regs.csr |= QNARESET;
    Deqna->regs.csr &= ~QNARESET;

    /* initialize the setup packet */
    for (i = 0; i < 16; i++)
        for (j = 0; j < 8; j++)
	    Buffers.setupbuff[i][j] = 0;
    for (i = 0; i < 6; i++)
      {
        if (receiveMask & ENET_SELF)
	  {
	    Buffers.setupbuff[i][1] = Deqna->enet_addr[i] & 0xFF;
	  }
        /* is this even needed? */
        if (receiveMask & ENET_BROADCAST)
	  {
	    Buffers.setupbuff[i][2] = Broadcast[i];
	    Buffers.setupbuff[i][3] = VMultiCast[i];
	  }
      }

    /* reset and flush the buffers */
    RcvIndex = 0;
    LastValidBuffer = RXLISTLEN-1;
    for (bdl = &Buffers.txlist[0]; bdl <= &Buffers.txlist[TXLISTLEN]; bdl++)
      {
        bdl->flag = QNA_Unused;
	bdl->chain = 0;
	bdl->valid = 0;
      }
    for (bdl = &Buffers.rxlist[0], i = 0; i < RXLISTLEN; bdl++, i++)
      {
        bdl->chain = 0;
        bdl->flag = QNA_Unused;
        bdl->size = -((sizeof(Buffers.rxbuff[i]) + 1) / sizeof(short));
        bdl->valid = 1;
        bdl->status.allofit = QNA_BDLUnused;
        bdl->addrhi = (int)&Buffers.rxbuff[i] >> 16;
        bdl->addrlo = (int)&Buffers.rxbuff[i] & 0xFFFF;
      }
    bdl->chain = 1;
    bdl->flag = QNA_Unused;
    bdl->status.allofit = QNA_BDLUnused;
    bdl->valid = 1;
    bdl->addrhi = (int)Buffers.rxlist >> 16;
    bdl->addrlo = (int)Buffers.rxlist & 0xFFFF;
    
    Deqna->regs.csr |= QNARESET;
    Deqna->regs.csr &= ~QNARESET;
    i = Deqna->regs.csr;
    i |= QNARCVINT | QNAILOOP | QNAXMTINT | QNARCVENABLE;
    i &= ~(QNAINTENABLE | QNATIMERENABLE | QNAELOOP);
    Deqna->regs.csr = i;
    RcvIndex = 0;
    LastValidBuffer = RXLISTLEN-1;
    Deqna->regs.rxBDLlo = (int)Buffers.rxlist & 0xFFFF;
    Deqna->regs.rxBDLhi = (int)Buffers.rxlist >> 16;

    /* send a setup packet
    */
    LoadXmitDescriptor((unsigned)rcvMode, (int)Buffers.setupbuff, 1);
    Deqna->regs.txBDLlo = (int)Buffers.txlist & 0xFFFF;
    Deqna->regs.txBDLhi = (int)Buffers.txlist >> 16;
    /* wait for it to be looped back */
    time = 0;
    while (Buffers.rxlist[RcvIndex].status.allofit == QNA_BDLUnused &&
		time <= QNAWAITTIME)
        time++;
    if (time > QNAWAITTIME)
      {
        /* we timed out waiting for a looped back packet, abort */
	printf("Deqna wouldn't loop back a setup packet...\n");
	;asm("halt"); 
      }
    Buffers.rxlist[RcvIndex].flag = QNA_Unused;
    Buffers.rxlist[RcvIndex].status.allofit = QNA_BDLUnused;
    if (Buffers.txlist[0].status.tx.use == QNA_LastErr)
      {
        /* we got an error on a setup packet, abort */
	printf("Deqna errored on a setup packet...\n");
	;asm("halt");
      }
    RcvIndex = (RcvIndex+1) % (RXLISTLEN+1);

  }


LoadXmitDescriptor( msize, buff, setup )
  /* Loads the Transmit descriptor according to the given information */
    unsigned msize;	/* the length of the message */
    int buff;		/* the buffer containing the message */
    int setup;		/* 1 if this is a setup packet */
  {
    Buffers.txlist[0].status.tx.use = QNA_Unused;
    Buffers.txlist[0].HBOStart = 0;
    Buffers.txlist[0].LBOEnd = msize & 1;
    Buffers.txlist[0].size = -((msize + 1) / sizeof(short));
    Buffers.txlist[0].addrlo = buff & 0xFFFF;
    Buffers.txlist[0].addrhi = buff >> 16;
    Buffers.txlist[0].endOfMsg = 1;
    Buffers.txlist[0].valid = 1;
    Buffers.txlist[0].setUp = setup;
    if (!setup)
        swab((char *)buff, (char *)buff, ENET10_HEADER_SIZE);
  }


SystemCode AwaitKernelPacket()

   /* Wait until a valid kernel packet is received.  Return
    *   TIMEOUT if we time out before getting one.
    */
  {
    SystemCode		ret;
    register int	loopcount = 0;
    register int	done, i;
    register QNABD_t	*bdl;

    ret = TIMEOUT;
    done = 0;
    bdl = &Buffers.rxlist[RcvIndex];

debug('a');
    /* Find a valid error-free packet */
    while (loopcount++ < MAXLOOPCOUNT && !done)
      {
        if (bdl->status.allofit == QNA_BDLUnused && !bdl->chain)
	    continue;	/* no packet yet */
debug('b');
	if (bdl->status.rx.use == QNA_LastNoErr && !bdl->chain)
	  {
	    /* We have a valid error-free packet */
	    /* Get the first two words of the packet and figure out
	    *   if it is a kernel packet
	    */
debug('c');
	    EnetPacket = &Buffers.rxbuff[RcvIndex];
	    swab((char *)EnetPacket, (char *)EnetPacket, ENET10_HEADER_SIZE);
	    if (EnetPacket->EtherType == KernelPacketType)
	      {
debug('d');
		Copy(&PacketSave, EnetPacket->data, sizeof(kPacketWithSegment));
		if (DifferentIKCByteOrder(&PacketSave))
		  {
		    SwapIKPacket(&PacketSave);
		  }
		PacketSave.packetType &= ~IKC_LITTLE_ENDIAN;
		ServerHostAddress = EnetPacket->SrcHost;    
		ServerLogicalHost = PacketSave.srcPid >> 16;
		done = 1;
		ret = OK;
	      }
	  }
	bdl->flag = QNA_Unused;
	bdl->status.allofit = QNA_BDLUnused;
	RcvIndex = (RcvIndex+1) % (RXLISTLEN+1);
	bdl = &Buffers.rxlist[RcvIndex];
      }
debug('f');
    i = Deqna->regs.csr;
    i |= QNARCVINT | QNAILOOP | QNARCVENABLE;
    i &= ~(QNAINTENABLE | QNATIMERENABLE | QNAELOOP | QNAXMTINT);
    Deqna->regs.csr = i;
    return( ret );
  }


/* Routines specific to the distributed version */


extern int WriteKernelPacket(type, srcPid, dstPid, forwarder, length, localaddress,
				remoteaddress,sequenceNo, msg, data )	

/* Writes kernel packet to the Ethernet */

  short		type;
  ProcessId	srcPid, dstPid, forwarder;
  unsigned	length;
  Unspec	*localaddress;
  Unspec	*remoteaddress;
  unsigned short	sequenceNo;
  long		*msg;
  unsigned char *data;
  {
    EnetBlock	*enetpacket;
    register kPacket	*packet;
    register int	dstLogicalHost;
    int		i;

    enetpacket = (EnetBlock *)(&Buffers.txbuff);

    dstLogicalHost = dstPid>>16;
    if (dstLogicalHost == ServerLogicalHost)
        enetpacket->DestHost = ServerHostAddress;
    else
        enetpacket->DestHost = BroadcastAddress;

    enetpacket->SrcHost = EnetHostNumber;
    enetpacket->EtherType = KernelPacketType;
    packet = (kPacket *) enetpacket->data;
    packet->packetType = type | IKC_LITTLE_ENDIAN;
    packet->sequenceNo = sequenceNo;
    packet->srcPid = srcPid;
    packet->dstPid = dstPid;
    packet->forwarder = forwarder;
    packet->userNumber = 0;		/* user number */
    packet->length = length;
    packet->localaddress = localaddress;
    packet->remoteaddress = remoteaddress;
    if( msg != NULL )
      {
	CopyMsg(&packet->msg, msg);
      }
    if( data != NULL )
      {
	Copy( ((kPacketWithSegment *)packet)->data, data, length );
      }
    
    LoadXmitDescriptor(ENET10_HEADER_SIZE + sizeof(kPacket) + (data?length:0),
		       (int)enetpacket, 0);
    Deqna->regs.txBDLlo = (int)Buffers.txlist & 0xFFFF;
    Deqna->regs.txBDLhi = (int)Buffers.txlist >> 16;

debug('y');
    while (0 == (QNAXMTINT & (i = Deqna->regs.csr)))
	;
debug('x');
    i |= QNAXMTINT | QNAILOOP | QNARCVENABLE;
    i &= ~(QNAINTENABLE | QNATIMERENABLE | QNAELOOP | QNARCVINT);
    Deqna->regs.csr = i;
    
    return (OK);
  }

int ReadDataPacket ( bytes, dst )
    unsigned bytes; 
    unsigned char *dst;
  {

debug('z');
    Copy( dst, PacketSave.data, bytes );
    return( OK );
  }

int DiscardDataPacket ( bytes ) unsigned bytes;
  {
    return( OK );
  }
