/*
 *  V Kernel -- Copyright (c) 1985 by Lance Berc and David Cheriton
 *
 *  Ethernet Header for Intel 82586 chip.
 */

/* This information was gleaned from the Intel LAN Components Users Manual */

/*
 * Assumptions:
 *
 *	Ethernet addresses are 6 bytes.
 *	There are a maximum of ten multicast addresses.
 */

#ifndef _SUN75ETHERNET
#define _SUN75ETHERNET

#include "Vexceptions.h"

#define	  TRUE	1
#define	  FALSE	0

#define MAX_MULTICAST_ADDRESSES 10

#define HIGH(addr) ((unsigned short) (((long) (addr)) >> 16))
#define LOW(addr) ((unsigned short) (((long) (addr)) & 0xffff))
#define SWAP(y) (( ( (unsigned short) y) >> 8) + ( ((unsigned short) y) << 8))

/* The magic address that the 82586 uses for its control block pointer */
#define SCPADDR	0xFFFFFFF6

/* Ethernet control register address */
#define ENETREG 0x0fe0c000

/*
 * 82586 control register. See Sun-2 Architecture guide.
 */
#define   I_INT		0x01	/* Interrupt Pending */
#define   I_ERR		0x02	/* Error Pending */
#define   I_INTEN	0x10	/* Interrupt enable */
#define	  I_CA		0x20	/* Channel Attention */
#define   I_LOOPB	0x40	/* 0 => Loopback ; 1 => Normal */
#define   I_RESET	0x80	/* 0 => Reset ; 1 => Normal */

struct SystemConfigurationPointer
  {
    unsigned short	sysbus;		/* bus wordsize: 0=16 bit; 1=8 bit */
    unsigned short	space1[2];
    unsigned short	ISCPlow;	/* address of Intermediate SCP */
    unsigned short	ISCPhigh;
  };

struct ISystemConfigurationPointer
  {
    unsigned short	busy;		/* indicates 82586 still reading ISCP */
    unsigned short	SCBoffset;	/* where in 64k 'segment' SCB lives */
    unsigned short	SCBlow;		/* base of the 'segment' */
    unsigned short	SCBhigh;
  };

/*
 * System Control Block (SCB) definition.
 */

/* Status word */
#define CX		0x8000	/* Command with interrupt bit set completed */
#define	FR		0x4000	/* Frame received */
#define sFR		0x0040
#define CNA		0x2000	/* Command Unit left the active state */
#define RNR		0x1000	/* Receive Unit left the ready state */
#define CUS_MASK	0x0700	/* Command Unit Status */
#define RUS_MASK	0x0070	/* Receive Unit status */
#define RU_NOT_ACTIVE	0x0030	/* Either suspended or no resources */

/* Command word */
#define ACK_MASK	0xF000	/* Acknowledgements of commands */
#define sACK_MASK	0x00F0
#define ACK_CX		0x8000
#define ACK_FR		0x4000
#define ACK_CNA		0x2000
#define ACK_RNR		0x1000
#define CUC_MASK	0x0700	/* Command unit commands */
#define CUC_NOP		0x0000
#define CUC_START	0x0100
#define CUC_RESUME	0x0200
#define CUC_SUSPEND	0x0300
#define CUC_ABORT	0x0400
#define RUC_MASK	0x0070	/* Receive unit commands */
#define RUC_NOP		0x0000
#define RUC_START	0x0010
#define RUC_RESUME	0x0020
#define RUC_SUSPEND	0x0030
#define RUC_ABORT	0x0040
#define RESET		0x0080	/* Equivalent to a hardware reset */

struct SystemControlBlock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	CBLoffset;
    unsigned short	RFAoffset;
    unsigned short	CRCerrs;
    unsigned short	ALNerrs;
    unsigned short	RSCerrs;
    unsigned short	OVRNerrs;
  };

/*
 * 82586 Command block common codes
 */
#define COM_COMPLETE	0x8000	/* status word */
#define COM_BEGIN	0x4000
#define COM_EL		0x8000	/* command word */
#define COM_SUSPEND	0x4000
#define COM_INTERRUPT	0x2000
#define COM_MASK	0x0007	/* Action command codes */
#define	NOP		0x0000
#define IA_SETUP	0x0001
#define CONFIGURE	0x0002
#define MC_SETUP	0x0003
#define TRANSMIT	0x0004
#define TDR		0x0005
#define DUMP		0x0006
#define DIAGNOSE	0x0007
#define sIACOMMAND	0x01A0 /* swap(IA_SETUP + COM_EL + COM_INTERRUPT) */
#define sTRANSMIT	0x04A0

struct nopblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
  };

struct IAsetupblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    Enet10Address	address;
  };

struct Configureblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short	c[6];
  };

struct MCsetupblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short      count;		/* number of addresses */
    Enet10Address	addresses[MAX_MULTICAST_ADDRESSES];
  };

#define XMIT_OK	0x2000	/* Transmission completed without errors */

struct Transmitblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short	TBDoffset;
    Enet10Address	destination;
    unsigned short	type;
  };

#define TDR_LNK_OK	0x8000
#define TDR_PROBLEM	0x4000
#define TDR_ET_OPEN	0x2000
#define TDR_ET_SHORT	0x1000
#define TIME_MASK	0x07ff

struct TDRblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short	time;
  };

struct Dumpblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short	BufferOffset;
  };

struct Diagnoseblock
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
  };

struct ReceiveFrameDescriptor
  {
    unsigned short	status;
    unsigned short	command;
    unsigned short	link;
    unsigned short      buffer;		/* offset of first buffer descriptor */
    Enet10Address	destination;
    Enet10Address	source;
    unsigned short	type;
  };

struct ReceiveBufferDescriptor
  {
    unsigned short	count;
    unsigned short	next;
    unsigned short	bufferlow;
    unsigned short	bufferhigh;
    unsigned short	size;
  };

struct TransmitBufferDescriptor
  {
    unsigned short	count;
    unsigned short	next;
    unsigned short	bufferlow;
    unsigned short	bufferhigh;
  };

#endif _SUN75ETHERNET

