/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * The initialization routine, that eventually calls the Machine Independent
 * startup routine.  We initialize stacks and such here.
 */

#include "asmdefs.h"
#include "machine.h"
#include "Vexceptions.h"
#include "bootparam.h"

int	(*SysControlBlock[NumExceptions])() = { 0 };
char	IStack[STACK_SIZE] = { 0 };	/* Interrupt stack */
char	KStack[STACK_SIZE] = { 0 };	/* Kernel Stack */

/*
 * So the assembly code can know where the stackbottoms are without
 * having to make any assumtions on the values of STACK_SIZE
 */
static char	*IStackBottom = &IStack[STACK_SIZE];
static char	*KStackBottom = &KStack[STACK_SIZE];

#ifdef MICROVAX
    /*
     * We rely on the compiler to put RPB, SBA, SBI sequentially in the data
     * segment, so the movc3's below do the right thing.
     */
RestartParamBlock RPB = {(char *)-1};
SecondBootArgs    SBA = {(long)  -1};
SecondBootInfo	  SBI = {(RestartParamBlock *) -1};
#endif MICROVAX

asm("	.text");
asm("	.align	1");
asm("	halt");
asm("	.globl	start");
asm("start:");
asm("	jmp	*$0f");
asm("0:");
#ifdef MICROVAX
asm("	movl	r11, _SBI");
asm("	movl	ap, _SBI+4");
asm("	movl	sp, _SBI+8");
asm("	mfpr	$scbb, _SBI+12");
asm("	movc3	$(_SBA-_RPB), (r11), _RPB"); /* Copy these since we'll walk */
asm("	movc3	$(_SBI-_SBA), (ap) , _SBA"); /*   all over where they are.  */
#endif MICROVAX
asm("	mtpr	$_SysControlBlock, $scbb");
asm("	movl	_KStackBottom, r0");
asm("	mtpr	r0, $ksp");
asm("	movl	_IStackBottom, sp");
asm("	mtpr	sp, $isp");
asm("	movl	sp, fp");
asm("	movpsl	-(sp)");
asm("	bicl2	$0x04000000, (sp)");	/* clear the Interrupt stack flag */
asm("	pushal	onkernelstack");
asm("	rei");
asm("onkernelstack:");
asm("	calls	$0, _Init_memory");
asm("	calls	$0, _Init_kernel");
asm("	halt");
