/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Device configuration table: vaxu+qna
 */

#include "config.h"
#include "machine.h"
#include "Vquerykernel.h"

extern SystemCode DeviceDirCreate();
extern SystemCode ConsoleCreate();
extern SystemCode QvssCreate();
extern SystemCode QvssKeyboardCreate();
extern SystemCode MouseCreate();
extern SystemCode EnetCreate();
extern SystemCode EnetQuery();
extern SystemCode NullInCreate();
extern SystemCode NullOutCreate();
extern SystemCode SerialCreate();
extern SystemCode MscpCreate();
extern SystemCode NotSupported();

KernelDeviceDescriptor DeviceDirectory[DEV_DIR_SIZE] =
  { 
    { DEVICE_DESCRIPTOR, ".",		0 },
	DeviceDirCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "console",  	0 }, 
	ConsoleCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "enet10",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "ethernet",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "nullin",    	0 },
	NullInCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullout",    	0 },
	NullOutCreate, NotSupported, NotSupported,
#define DIRQVSS		6
    { DEVICE_DESCRIPTOR, "qvss",	0 }, 
	QvssCreate, NotSupported, NotSupported,
#define DIRMOUSE	7
    { DEVICE_DESCRIPTOR, "mouse",    	0 },
	MouseCreate, NotSupported, NotSupported,
#define DIRSERIAL0	8
    { DEVICE_DESCRIPTOR, "serial0",    	0 },
	NotSupported /* QvssKeyboardCreate */ , NotSupported, NotSupported,
#define DIRSERIAL1	9
    { DEVICE_DESCRIPTOR, "serial1",    	1 },
	NotSupported /* SerialCreate */ , NotSupported, NotSupported,
#define DIRDISK0	10
    { DEVICE_DESCRIPTOR, "disk0",    	0 },
	MscpCreate, NotSupported, NotSupported,
#define DIRDISK1	11
    { DEVICE_DESCRIPTOR, "disk1",    	1 },
	MscpCreate, NotSupported, NotSupported,
#define DIRDISK2	12
    { DEVICE_DESCRIPTOR, "disk2",    	2 },
	MscpCreate, NotSupported, NotSupported
  };


Powerup()
  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    extern unsigned short FramebufferType;
    extern unsigned short DiskType;

    disable;
    InitException();
    InitConsole();
    Init_timer();
    EnetPowerup();
    if (DiskType == PRF_DISK_RQDX)
      {
	MscpPowerup();
      }
    else
      {
	DeviceDirectory[DIRDISK0].CreateFunc = NotSupported;
	DeviceDirectory[DIRDISK1].CreateFunc = NotSupported;
	DeviceDirectory[DIRDISK2].CreateFunc = NotSupported;
      }
    if (FramebufferType == PRF_FRAMEBUFFER_QVSS)
      {
	QvssPowerup();	/* this does the mouse and serial powerups also */
      }
    else
      {
	DeviceDirectory[DIRQVSS].CreateFunc = NotSupported;
	DeviceDirectory[DIRMOUSE].CreateFunc = NotSupported;
	DeviceDirectory[DIRSERIAL0].CreateFunc = NotSupported;
	DeviceDirectory[DIRSERIAL1].CreateFunc = NotSupported;
      }
    LockSCB();          /* Keep SCB from getting clobbered */
  }
