/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 *  Kernel trap handler for process-invoked traps.
 *  Changes to this file need to be coordinated with
 *  the C kernel trap definitions for programs.
 *
 * Also note that C functions do not save registers r0-r5, even if they use
 * them.
 */
#include "asmprocess.h"  /* Defines offsets for assembly language. */
#include "process.h"

/* Internal names of functions */
extern ProcessId	KForward();
extern ProcessId	KReceiveSpecific();
extern ProcessId	KSend();
extern ProcessId	KReply();
extern ProcessId	KGetReply();

/* Message-register traps.
 *   This is a first, and somewhat hurried, attempt at implementation.  Anyone
 *   who expectes these to actually work probably also believes in sensible
 *   government.
 *   Since (we believe) the kernellib routines in each process save r2-r11, and
 *   it's a VAX convention to blatt r0-r1, we can use these registers freely
 *   without bothering to save their contents first.
 *   Can we:
 *     - enable interrupts for most of these?
 */
asm("	.globl	Asm_SendReg_trap");
asm("	.globl	Asm_ReceiveReg_trap");
asm("	.globl	Asm_ReplyWithSeg_trap");
asm("	.globl	Asm_ForwardReg_trap");
asm("	.globl	Asm_GetReplyReg_trap");

SendReg_trap()
  {
    asm("Asm_SendReg_trap:");
    asm("	movl	_Active, r2");
    asm("	movl	ap, _R12(r2)");
    asm("	movl	fp, _R13(r2)");
    asm("	movl	(sp)+, _PC(r2)");
    asm("	movl	(sp)+, _PSL(r2)");
    enable;
    asm("	movl	r0, _BLOCKED_ON(r2)");
    asm("	movq	r0, _TRAP_PARAMS(r2)");
    asm("	movl	_PID(r2), _FORWARDER(r2)"); /* Do we really have to do
						   this in the trap routine? */
    asm("	bisb2	$2, _PD_FLAGS(r2)"); /* Turn on MSG_FLAG.  Ugh. */
    asm("	moval	_MSG(r2), r1");
    asm("	movq	r3, (r1)+");
    asm("	movq	r5, (r1)+");
    asm("	movq	r7, (r1)+");
    asm("	movq	r9, (r1)+");

    asm("	pushl	r2");
    asm("	calls	$1, _KSend");
    
    disable;
    asm("	jmp	ActivateReadyqHead");
  }

ReceiveReg_trap()
  {
    asm("Asm_ReceiveReg_trap:");
    asm("	movl	_Active, r3");
    asm("	movl	ap, _R12(r3)");
    asm("	movl	fp, _R13(r3)");
    asm("	movl	(sp)+, _PC(r3)");
    asm("	movl	(sp)+, _PSL(r3)");
    enable;
    asm("	movl	r0, _BLOCKED_ON(r3)");
    asm("	movq	r0, _TRAP_PARAMS(r3)");
    asm("	movl	r1, _DATA_SEG_PTR(r3)");
    asm("	movl	r2, _DATA_SEG_SIZE(r3)");
    asm("	clrb	_NUM_TRANS(r3)");
    asm("	bisb2	$2, _PD_FLAGS(r3)");

    asm("	pushl	r3");
    asm("	calls	$1, _KReceiveSpecific");
    disable;
    asm("	jmp	ActivateReadyqHead");
  }

ReplyWithSeg_trap()
  {
    asm("Asm_ReplyWithSeg_trap:");
    asm("	movl	_Active, r2");
    asm("	movl	ap, _R12(r2)");
    asm("	movl	fp, _R13(r2)");
    asm("	movl	(sp)+, _PC(r2)");
    asm("	movl	(sp)+, _PSL(r2)");
    enable;
    asm("	movl	r0, _BLOCKED_ON(r2)");
    asm("	movq	r0, _TRAP_PARAMS(r2)");
    asm("	movl	r1, _SEGMENT_PTR(r2)");
    asm("	bisb2	$2, _PD_FLAGS(r2)"); /* Even though we don't get a 
						message back, maybe we have to
						do this to return other goodies
						- maybe unnecessary since, in
						the vax version, we do ldpctx*/
    asm("	moval	_MSG(r2), r1");
    asm("	movq	r3, (r1)+");
    asm("	movq	r5, (r1)+");
    asm("	movq	r7, (r1)+");
    asm("	movq	r9, (r1)+");

    asm("	pushl	r2");
    asm("	calls	$1, _KReply");
    disable;
    asm("	jmp	ActivateReadyqHead");
  }

ForwardReg_trap()
  {
    asm("Asm_ForwardReg_trap:");
    asm("	movl	_Active, r2");
    asm("	movl	ap, _R12(r2)");
    asm("	movl	fp, _R13(r2)");
    asm("	movl	(sp)+, _PC(r2)");
    asm("	movl	(sp)+, _PSL(r2)");
    enable;
    asm("	movl	r0, _BLOCKED_ON(r2)");	/* fromPid */
    asm("	movq	r0, _TRAP_PARAMS(r2)");
    asm("	movl	r1, _FORWARDER(r2)");	/* toPid   */
    asm("	bisb2	$2, _PD_FLAGS(r2)"); /* Maybe we don't need to do this
						in the vax version of Forward,
						though it may be necessary for
						the m68k version */
    asm("	moval	_MSG(r2), r1");
    asm("	movq	r3, (r1)+");
    asm("	movq	r5, (r1)+");
    asm("	movq	r7, (r1)+");
    asm("	movq	r9, (r1)+");

    asm("	pushl	r2");
    asm("	calls	$1, _KForward");
    disable;
    asm("	jmp	ActivateReadyqHead");
  }

GetReplyReg_trap()
  {
    asm("Asm_GetReplyReg_trap:");
    asm("	movl	_Active, r2");
    asm("	movl	ap, _R12(r2)");
    asm("	movl	fp, _R13(r2)");
    asm("	movl	(sp)+, _PC(r2)");
    asm("	movl	(sp)+, _PSL(r2)");
    enable;
    asm("	movq	r0, _TRAP_PARAMS(r2)");
    asm("	movl	r1, _TIMEOUT_COUNT(r2)");
    asm("	bisb2	$2, _PD_FLAGS(r2)");
    asm("	pushl	r2");
    asm("	calls	$1, _KGetReply");
    disable;
    asm("	jmp	ActivateReadyqHead");
  }

