/*
 * Distributed V Kernel
 * Copyright (c) 1986 by Stanford University, All rights reserved.
 *
 * Kernel MSCP disk driver, William Lees
 */

/*
 * This include file contains defintions for the MSCP protocol.  It is based
 * on MSCP version 1.2, standard dated April 8, 1982.
 */

/* Operation codes */

#define M_OP_ABORT	0001	/* Abort Command */
#define M_OP_GTCMD	0002	/* Get command status command */
#define M_OP_GTUNT	0003	/* Get unit status command */ 
#define M_OP_STCON	0004	/* Set controller characteristics command */ 
#define M_OP_SEREX	0007	/* Serious exception end message*/
#define M_OP_AVAIL	0010	/* Available command*/
#define M_OP_ONLIN	0011	/* Online command */
#define M_OP_STUNT	0012	/* Set unit characteristics command */
#define M_OP_DTACP	0013	/* Determine access paths command */
#define M_OP_ACCES	0020	/* Access command */
#define M_OP_CMPCD	0021	/* Compare controller data command */
#define M_OP_ERASE	0022	/* Erase command */
#define M_OP_FLUSH	0023	/* Flush command */
#define M_OP_REPLC	0024	/* Replace command */
#define M_OP_COMP	0040	/* Compare host data command */
#define M_OP_READ	0041	/* Read command */
#define M_OP_WRITE	0042	/* Write command */
#define M_OP_AVATN	0100	/* Available attention message */
#define M_OP_DUPUN	0101	/* Duplicate unit number attention mesage */
#define M_OP_ACPTH	0102	/* Access path attention message */
#define M_OP_END	0200	/* End message flag */

/* Controller characteristic flags */

#define M_CF_ATTN	0200	/* Enable attention messages */
#define M_CF_MISC	0100	/* Enable misc error long messages */
#define M_CF_OTHER	0040	/* Enable other host's error log messages */
#define M_CF_THIS	0020	/* Enable this host's error log messages */
#define M_CF_MLTHS	0004	/* Multi-host */
#define M_CF_SHADW	0002	/* Shadowing */
#define M_CF_576	0001	/* 576 byte sectors */

/* Major status codes */

#define M_ST_MASK	037	/* Status code mask */
#define M_ST_SUCC	000	/* Success */
#define M_ST_ICMD	001	/* Invalid command */
#define M_ST_ABRTD	002	/* Command Aborted */
#define M_ST_OFFLN	003	/* Unit Offline */
#define M_ST_AVLBL	004	/* Unit available */
#define M_ST_MFMTE	005	/* Media format error */
#define M_ST_WRTPR	006	/* Write protected */
#define M_ST_COMP	007	/* Compare error */
#define M_ST_DATA	010	/* Data error */
#define M_ST_HSTBF	011	/* Host buffer access error */
#define M_ST_CNTLR	012	/* Controller error */
#define M_ST_DRIVE	013	/* Drive error */
#define M_ST_DIAG	037	/* Message from an internal diagnostic */

/* Controller specific part of packet */

struct mscp_header {
	short	uda_msglen;	/* Length of MSCP packet */
	char	uda_credits;	/* Low 4 bits: credits, high 4 bits: msgtype */
	char	uda_vcid;	/* Virtual circuit id */
};

/* MSCP packet declaration.  There are many variants, so only the structurally
 * distinct ones are actually listed here.  Synonymous field names are defined
 * below for the remaining variants.
 */

struct mscp {
	struct mscp_header mscp_header;		/* Device specific header */
	unsigned	mscp_cmd_ref;		/* Command reference number */
	unsigned short	mscp_unit;		/* Unit number */
	short		mscp_xxx1;
	unsigned char	mscp_opcode;		/* Opcode or end-code */
	unsigned char	mscp_flags;		/* End message flags */
	unsigned short	mscp_modifier;		/* Modifiers */
	union {
	struct {
		unsigned	_mscp_byte_cnt;	/* Transfer byte count */
		unsigned	_mscp_buffer;	/* Transfer address */
		unsigned	_mscp_mapbase;	/* Phys addr of map reg */
		unsigned	_mscp_xxx2;
		unsigned	_mscp_lbn;	/* Logical block number */
		unsigned	_mscp_xxx3;
		unsigned	_mscp_dscptr;	/* Software use, Unused ? */
		unsigned	_mscp_sftwrds[4]; /* Software use, unused ? */
	} mscp_generic;
	struct {
		unsigned short	_mscp_version;	/* MSCP version */
		unsigned short	_mscp_cnt_flgs;	/* Controller flags */
		unsigned short	_mscp_hst_tmo;	/* Host timeout */
		unsigned short	_mscp_use_frac;	/* Use fraction */
		unsigned	_mscp_time_low;	/* Time and date, VMS format */
		unsigned	_mscp_time_high;
		unsigned	_mscp_cnt_dep;	/* Controller dependent */
	} mscp_stcon;
	struct {
		unsigned short	_mscp_mult_unt;	/* Multi-unit code */
		unsigned short	_mscp_unt_flgs;	/* Unit flags */
		unsigned	_mscp_host_id;	/* Host identifier */
		unsigned	_mscp_unit_id;	/* Unit identifier, 1st long */
		unsigned short	_mscp_unit_id_unused;
		unsigned char	_mscp_unit_model; /* Unit model */
		unsigned char	_mscp_unit_class; /* Unit class */

		unsigned	_mscp_media_id;	/* Media type identifier */
		unsigned short	_mscp_shdw_unt;	/* Shadow unit */
		unsigned short	_mscp_shdw_sts;	/* Shadow status */
		unsigned short	_mscp_track;	/* Track size */
		unsigned short	_mscp_group;	/* Group size */
		unsigned short	_mscp_cylinder;	/* Cylinder size */
		unsigned short	mscp_xxx4;
		unsigned short	_mscp_rct_size;	/* RCT table size */
		unsigned char	_mscp_rbns;	/* RBNs / track */
		unsigned char	_mscp_rct_cpys;	/* RCT copies */
	} mscp_gtunt;
	} mscp_union;
	short		mscp_xxx5;	/* Filler */
	short		mscp_xxx6;	/* Filler */
	short		mscp_xxx7;	/* Filler */
};
	
#define mscp_msglen ( sizeof(struct mscp) - sizeof(struct mscp_header) );

/* Generic packet offset synonyms */

#define mscp_byte_cnt	mscp_union.mscp_generic._mscp_byte_cnt
#define mscp_buffer	mscp_union.mscp_generic._mscp_buffer
#define mscp_mapbase	mscp_union.mscp_generic._mscp_mapbase
#define mscp_xxx2	mscp_union.mscp_generic._mscp_xxx2
#define mscp_lbn	mscp_union.mscp_generic._mscp_lbn
#define mscp_dscptr	mscp_union.mscp_generic._mscp_dscptr
#define mscp_xxx3	mscp_union.mscp_generic._mscp_xxx3
#define mscp_sftwds	mscp_union.mscp_generic._mscp_sftwds
#define mscp_status	mscp_modifier

/* ABORT / GTCMD offset synonyms */

#define mscp_out_ref	mscp_byte_cnt

/* REPLC offset synonyms */

#define mscp_rbn	mscp_byte_cnt

/* ONLINE / STUNT offset synonyms */

#define mscp_errlgfl	mscp_lbn
#define mscp_copy_spd	mscp_shdw_sts

/* STCON offset synonyms */

#define mscp_version	mscp_union.mscp_stcon._mscp_version
#define mscp_cnt_flgs	mscp_union.mscp_stcon._mscp_cnt_flgs
#define mscp_hst_tmo	mscp_union.mscp_stcon._mscp_hst_tmo
#define mscp_use_frac	mscp_union.mscp_stcon._mscp_use_frac
#define mscp_time_low	mscp_union.mscp_stcon._mscp_time_low
#define mscp_time_high	mscp_union.mscp_stcon._mscp_time_high
#define mscp_cnt_dep	mscp_union.mscp_stcon._mscp_cnt_dep

/* GTUNT end offset synonyms */

#define mscp_mult_unt	mscp_union.mscp_gtunt._mscp_mult_unt
#define mscp_unt_flgs	mscp_union.mscp_gtunt._mscp_unt_flgs
#define mscp_host_id	mscp_union.mscp_gtunt._mscp_host_id
#define mscp_unit_id mscp_union.mscp_gtunt._mscp_unit_id
#define mscp_unit_model mscp_union.mscp_gtunt._mscp_unit_model
#define mscp_unit_class mscp_union.mscp_gtunt._mscp_unit_class
#define mscp_media_id	mscp_union.mscp_gtunt._mscp_media_id
#define mscp_shdw_unt	mscp_union.mscp_gtunt._mscp_shdw_unt
#define mscp_shdw_sts	mscp_union.mscp_gtunt._mscp_shdw_sts
#define mscp_track	mscp_union.mscp_gtunt._mscp_track
#define mscp_group	mscp_union.mscp_gtunt._mscp_group
#define mscp_cylinder	mscp_union.mscp_gtunt._mscp_cylinder
#define mscp_rct_size	mscp_union.mscp_gtunt._mscp_rct_size
#define mscp_rbns	mscp_union.mscp_gtunt._mscp_rbns
#define mscp_rctcpys	mscp_union.mscp_gtunt._mscp_rct_cpys

/* ONLINE / STUNT end offset synonyms */

#define mscp_unit_size	mscp_dscptr
#define mscp_vol_ser	mscp_sftwds[0]

/* STCON end offset synonyms */

#define mscp_cnt_tmo	mscp_hst_tmo
#define mscp_cnt_rsn	mscp_use_frac
#define mscp_cnt_id	mscp_unit_id
#define mscp_cnt_model	mscp_unit_model
#define mscp_cnt_class	mscp_unit_class

/* ONLINE end offset synonyms */

#define mscp_unit_size	mscp_dscptr

/* MSCP error log message format codes */

#define M_FM_CNTERR	0	/* Controller error */
#define M_FM_BUSADDR	1	/* Host memory access error */
#define M_FM_DISKTRN	2	/* Disk transfer error */
#define M_FM_SDI	3	/* SDI error */
#define M_FM_SMLDSK	4	/* Small disk error */

/* MSCP error log message flags */

#define M_LF_SUCC	0200	/* Operation successful */
#define M_LF_CONT	0100	/* Operation continuing */
#define M_LF_SQNRS	0001	/* Sequence number reset */

/* MSCP error log packet (MSCP packet must be atleast this size) */

struct mslg {
	struct mscp_header	mslg_header;	/* Device specific header */
	unsigned		mslg_cmdref;	/* Command reference number */
	unsigned short		mslg_unit;	/* Unit number */
	unsigned short		mslg_seqnum;	/* Sequence number */
	unsigned char		mslg_format;	/* Datagram format */
	unsigned char		mslg_flags;	/* Error log message flags */
	unsigned short		mslg_event;	/* Event code */
	unsigned		mslg_cnt_id_low; /* Controller identifier */
	unsigned		mslg_cnt_id_high;
	unsigned char		mslg_cnt_svr;	/* Cntrlr software version */
	unsigned char		mslg_cnt_hvr;	/* Cntrlr hardware version */
	unsigned short		mslg_multunt;	/* Multi-unit code */
	unsigned		mslg_unit_id_low; /* Unit identifier */
	unsigned		mslg_unit_id_high;
	unsigned char		mslg_unit_svr;	/* Unit software version */
	unsigned char		mslg_unit_hvr;	/* Unit hardware version */
	unsigned short		mslg_group;	/* Group, retry + level */
	unsigned		mslg_volser;	/* Volume serial number */
	unsigned		mslg_hdr;	/* header */
	unsigned char 		mslg_sdi_stat[12]; /* SDI status info */
};

/* Error log packet synonyms */

#define mslg_bus_addr	mslg_unit_id_low
#define mslg_sde_cyl	mslg_group
