/*
 * Distributed V Kernel
 * Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Machine descriptive Header File for VAX
 */

/* See also Venviron.h */

#ifndef MACHINE
#define MACHINE

#include "memory.h"
#include "asmdefs.h"
#include "Vexceptions.h"
#ifdef VM
#include "vm.h"
#endif VM

/* Processor State as stored inside the kernel */
typedef struct
  {
	/* Machine dependent fields */
	Unspec		KernelSP;	/* Kernel Stack pointer */	
	Unspec		ExecSP;		/* Executive mode stack pointer */
	Unspec		SuperSP;	/* Supervisor mode stack pointer */
	Unspec  	UserSP;		/* User mode stack pointer */
	Unspec		regs[14];	/* r0 - r13 general registers */
	/* register 14 the stack pointer is stored in one of the SP's */
	Unspec		PC;		/* program counter r15 */
	Unspec		PSL;		/* processor status long word */
	unsigned	ProgBaseReg;	/* program region base register */
	unsigned	ProgLenReg:22;	/* program region length register */
	unsigned 	MBZfield1:2;	/* must be zero field */
	unsigned	AstLevel:3;	/* Asynchronous system trap level */
	unsigned	MBZfield2:5;	/* must be zero field */
	unsigned	CtrlBaseReg;	/* control region base register */
	unsigned 	CtrlLenReg:22;	/* control region length register */
	unsigned	MBZfield3:10;	/* mustbe zero field */
	/* High order bit of this last register is actually the performance
	   monitor enable bit */

	/* Machine independent fields */
        Unspec	*perProcess;	 /* Pointer to per process area */
        Unspec	**perProcessLoc; /* perProcess pointer stored at
				  * this address on a process switch */
  } KProcessor_state;

typedef struct
  {
    short	teamno;	/* used to calculate where the page table resides */
    unsigned	size;	/* size of team in bytes */
    unsigned	p0len;	/* number of pages allocated to this team */
    unsigned	qvss;	/* is qvss mapped? so we can adjust p0lr accordingly */
    unsigned	p0base;	/* Where the P0 Page table resides */
    unsigned	p0index;/* Index of P0 Page Table in Sytem Page Table */
#ifdef VM
    BoundRegion backingUio;		
#endif VM
  } Team_space;

/*
 * disable is supposed to disable ALL interrupts, enable enables only Timer
 * interrupts, if that is possible.  In all cases, Ethernet/device
 * interrupts should be disabled.
 *
 * Unfortunately, the VAX still misses clock ticks this way, so we are
 * going to make disable enable clock ints.
 */
#define disable ;asm("	mtpr	$0x15, $ipl")
#define enable  ;asm("	mtpr	$0x15, $ipl")

#define Lockq(queue)					\
{							\
    extern unsigned long GlobalLockKludge;		\
    unsigned long tmp;					\
							\
    tmp = GlobalLockKludge;				\
    asm("	mfpr	$ipl, _GlobalLockKludge");	\
    disable;						\
    ((SyncQueue *) (queue))->lock = GlobalLockKludge;	\
    GlobalLockKludge = tmp;				\
}

#define Unlockq(queue)					\
{							\
    extern unsigned long GlobalLockKludge;		\
    unsigned long tmp;					\
							\
    tmp = GlobalLockKludge;				\
    GlobalLockKludge = ((SyncQueue *)(queue))->lock;	\
    ((SyncQueue *)(queue))->lock = 0;			\
    asm("	mtpr	_GlobalLockKludge, $ipl");	\
    GlobalLockKludge = tmp;				\
}

/* Macros for AddressableTeam stuff */
extern struct _TD	*AddressableTeam;
extern unsigned	AddressableTemp;
#define	GetAddressableTeam() \
    AddressableTeam
#define	SetAddressableTeam(newteam) \
{									\
    AddressableTemp = (AddressableTeam = newteam)->team_space.p0base;	\
    asm("	mtpr	_AddressableTemp, $p0br");			\
    AddressableTemp = newteam->team_space.qvss ?			\
		MAXPAGEFRAMES : newteam->team_space.p0len;		\
    asm("	mtpr	_AddressableTemp, $p0lr");			\
}
 
/* To save interrupt mask in Add_ready */
#define Interrupt_mask		extern short intmask; register short
#define Mask_interrupts()	intmask; disable
#define Restore_interrupt_mask(mask) intmask = mask


#define ReturnPid(pd,value) pd->trap_params[0] = (Unspec) value
#define ReturnSegmentSize(pd,value) pd->trap_params[1] = (Unspec) value

#define SenderPid(pd) pd->trap_params[0] 
#define SentSegmentSize(pd) pd->trap_params[1]

/* Message copying macro */
#define Copy_msg( dest, src ) \
	*((MsgStruct *)(dest)) = *((MsgStruct *)(src))

/* User pointers must be outside kernel space and less than TEAM_LIMIT */
#define BadUserPtr(ptr) \
	( ((unsigned)(ptr)) >= ((unsigned)(TEAM_LIMIT)) )

/* Check whether the specified segment lies entirely within the
 *  specified process's team space
 */
#define SegOutsideTeamSpace(pd, ptr, len) \
( (len) != 0 &&  \
  ( (unsigned)(ptr) + (unsigned)(len) > (pd)->team->team_space.size || \
    (unsigned)(ptr) + (unsigned)(len) < (unsigned)(ptr) ) )

#endif MACHINE
