/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Device configuration table: sun2+ec
 */

#include "config.h"
#include "machine.h"
#include "Vquerykernel.h"

extern SystemCode DeviceDirCreate();
extern SystemCode ConsoleCreate();
extern SystemCode EnetCreate();
extern SystemCode EnetQuery();
extern SystemCode MouseCreate();
extern SystemCode NullInCreate();
extern SystemCode NullOutCreate();
extern SystemCode SccCreate();
extern SystemCode SccQuery();
extern SystemCode SccModify();
extern SystemCode FramebufferCreate();
extern SystemCode FramebufferModify();
extern SystemCode FramebufferQuery();
extern SystemCode NotSupported();

KernelDeviceDescriptor DeviceDirectory[DEV_DIR_SIZE] =
  { 
    { DEVICE_DESCRIPTOR, ".",		0 },
	DeviceDirCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "console",  	0 }, 
	ConsoleCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "enet10",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "ethernet",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "mouse",    	0 },
	MouseCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullin",    	0 },
	NullInCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullout",    	0 },
	NullOutCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial0",  	0 }, 
	SccCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial1",  	1 }, 
	SccCreate, NotSupported, NotSupported,
   { DEVICE_DESCRIPTOR, "framebuffer",	0 }, 
	FramebufferCreate, FramebufferModify, FramebufferQuery
  };


Powerup()
  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    disable;
    InitException();
    Init_timer();
    SccPowerup();
    EnetPowerup();
  }
