/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Device configuration table: sun2+ec+xyl+tm
 */

#include "config.h"
#include "machine.h"
#include "Vquerykernel.h"

extern SystemCode ConsoleCreate();
extern SystemCode EnetCreate();
extern SystemCode EnetQuery();
extern SystemCode MouseCreate();
extern SystemCode NullInCreate();
extern SystemCode NullOutCreate();
extern SystemCode SccCreate();
extern SystemCode SccQuery();
extern SystemCode SccModify();
extern SystemCode TmCreate();
extern SystemCode TmQuery();
extern SystemCode TmModify();
extern SystemCode XylCreate();
extern SystemCode XylQuery();
extern SystemCode XylModify();

extern SystemCode DeviceDirCreate();
extern SystemCode NotSupported();

KernelDeviceDescriptor DeviceDirectory[DEV_DIR_SIZE] =
  { 
    { DEVICE_DESCRIPTOR, ".",		0 },
	DeviceDirCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "console",  	0 }, 
	ConsoleCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "disk0",	0 }, 
	XylCreate, XylModify, XylQuery,
    { DEVICE_DESCRIPTOR, "disk1",	1 }, 
	XylCreate, XylModify, XylQuery,
    { DEVICE_DESCRIPTOR, "enet10",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "ethernet",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "mouse",    	0 },
	MouseCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullin",    	0 },
	NullInCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullout",    	0 },
	NullOutCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial0",  	0 }, 
	SccCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial1",  	1 }, 
	SccCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "mt0",  	0 }, 
	TmCreate, TmModify, TmQuery,
    { DEVICE_DESCRIPTOR, "mtnr0",  	1 }, 
	TmCreate, TmModify, TmQuery,
    { DEVICE_DESCRIPTOR, "mtf0",  	2 }, 
	TmCreate, TmModify, TmQuery,
    { DEVICE_DESCRIPTOR, "mtfnr0",  	3 }, 
	TmCreate, TmModify, TmQuery
  };


Powerup()
  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    disable;
    InitException();
    Init_timer();
    SccPowerup();
    TmPowerup() ;
    EnetPowerup();
    XylPowerup(); 
  }
