/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Device configuration table
 */

#include "config.h"
#include "machine.h"
#include "Vquerykernel.h"

extern SystemCode SerialCreate();
extern SystemCode EnetCreate();
extern SystemCode EnetQuery();
extern SystemCode MouseCreate();
extern SystemCode ConsoleCreate();
extern SystemCode NullInCreate();
extern SystemCode NullOutCreate();
extern SystemCode DeviceDirCreate();
extern SystemCode NotSupported();

KernelDeviceDescriptor DeviceDirectory[DEV_DIR_SIZE] =
  { 
    { DEVICE_DESCRIPTOR, ".",		0 },
	DeviceDirCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "console",  	0 }, 
	ConsoleCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "enet10",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "ethernet",	0 }, 
	EnetCreate, NotSupported, EnetQuery,
    { DEVICE_DESCRIPTOR, "mouse",    	0 },
	MouseCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullin",    	0 },
	NullInCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "nullout",    	0 },
	NullOutCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial0",  	0 }, 
	SerialCreate, NotSupported, NotSupported,
    { DEVICE_DESCRIPTOR, "serial1",  	1 }, 
	SerialCreate, NotSupported, NotSupported
   { DEVICE_DESCRIPTOR, "framebuffer",	0 }, 
	FramebufferCreate, FramebufferModify, FramebufferQuery
  };


Powerup()
  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    disable;
    InitException();
    Init_timer();
    Init_serial_interface( 0 );
    EnetPowerup();
  }
