/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Configuration Parameters for the Kernel.
 */

#ifndef CONFIG
#define CONFIG

#include "Vio.h"
#include "Vdirectory.h"

#define PID_HASH_MASK 0x3f	/* Size of pid hash table - 1 */
#define MAX_TEAMS 16		/* Maximum number of teams */
#define MAX_LOGICAL_ID	40	/* Maximum logical id for GetPid and SetPid */
#define ROOT_PRIORITY 4		/* Priority of first created process */
#define INIT_STACK 0x2000	/* Size of initial stack for root team */
#define HOST_CACHE_SIZE 64	/* Number of logical host to net address
				 *  mappings kept in our cache */
#define HOST_CACHE_SHIFT 26	/* 32 - log_sub_2(HOST_CACHE_SIZE) */

/*
 * Kernel device configuration declarations.
 */

#define MAX_DEVICES	16		/* Size of device instance table.
					 *  Must be a power of 2 */
#define DEV_DIR_SIZE	11		/* Size of device directory */

typedef struct
  {
    DeviceDescriptor	d;
    SystemCode		(*CreateFunc)();
    SystemCode		(*NModifyFunc)();
    SystemCode		(*NQueryFunc)();
  } 
KernelDeviceDescriptor;

/* NonLocal Operations may be "macroed" out in local kernel configuration */

#ifdef LOCAL
#define NonLocalSend(msg, pid) 0
#define NonLocalReceive( msg ) 0
#define NonLocalReply( msg, pid ) 0
#define NonLocalReceiveSpecific( msg, pid ) 0
#define NonLocalReply( msg, pid ) 0
#define NonLocalForward1( msg, from_pid, to_pid ) 0
#define NonLocalForward2( msg, from_pid, to_pid ) 0
#define NonLocalAwaitingReply( pid1, pid2 ) 0
#define NonLocalRewriteMsg( msg, pid ) 0
#define NonLocalRereadMsg( msg, pid ) 0
#define NonLocalMoveto( dest_pid, dest, src, bytes ) 0
#define NonLocalMovefrom( src__pid, src, dest, bytes ) 0
#endif LOCAL

#endif
