/*
 * Distributed V Kernel 
 * Copyright (c) 1984 by Stanford University, all rights reserved.
 *
 * Query Kernel operation
 */

#include "Venviron.h"
#include "Vquerykernel.h"
#include "process.h"

/* Imports */
extern MachineConfigurationReply MachineConfig;
extern PeripheralConfigurationReply PeripheralConfig;
extern KernelConfigurationReply KernelConfig;
extern SyncQueue Delayq;
extern Team *TdFreeList;
extern Process *ProcessDescriptors, *EndPds;

/* Exports */
extern SystemCode QueryKernel();



SystemCode QueryKernel( pd )
    register Process *pd;
  {
    register QueryKernelRequest *req;

    req = (QueryKernelRequest *) &pd->msg;

    switch (req->groupSelect)
      {
	case MACHINE_CONFIG:
	    /* Just pass back the saved information */
	    Copy_msg( req, &MachineConfig);
	    break;

	case PERIPHERAL_CONFIG:
	    /* Just pass back the saved information */
	    Copy_msg( req, &PeripheralConfig);
	    break;

	case KERNEL_CONFIG:
	    /* Just pass back the saved information */
	    Copy_msg( req, &KernelConfig );
	    break;

	case MEMORY_STATS:
	    GetMemoryStats(req);
	    break;

	case KERNEL_STATS:
	    GetKernelStats(req);
	    break;

	case LOGICAL_HOST_QUERY: /* Used to detect logical host collisions. */
	    /* KLUDGE: Don't reply to a locally-sent group request */
	    if (Local(pd->pid) && (pd->forwarder & GROUP_ID_BIT))
		return( DISCARD_REPLY );
	    if( !Local(req->pid) )
	      {
		if( pd->forwarder & GROUP_ID_BIT )
		    return( DISCARD_REPLY ); /* Dont reply */
		else
		   return( NOT_FOUND );
	      }
	    break;

	default: return( BAD_ARGS );
      }
    return( OK );
  }


/*
 * Fill in a kernel statistics reply message
 */
GetKernelStats(reply)
    register KernelStatisticsReply *reply;
  {
    register Process *pd;
    register Team *td;

    reply->freePds = 0;
    reply->freeTds = 0;
    reply->alienCount = 0;

    /* Count up free process descriptors and aliens */
    for (pd = ProcessDescriptors;
	 pd != EndPds;
         pd++)
      {
	if (pd->pid == 0) reply->freePds++;
        else
	   if( AlienProcess(pd) ) reply->alienCount++;
      }

    /* Count up free team descriptors */
    for( td = TdFreeList; td != NULL; td = td->next )
        reply->freeTds++;


    /* Find delay queue head */
    if( Delayq.head == NULL)
	reply->delayQueueHead = 0;
    else
	reply->delayQueueHead = Delayq.head->pid;
  }
