/*
 * Distributed V Kernel - Copyright (c) 1981 by David Cheriton.
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Process Descriptor, Team descriptor type definitions and related manifests
 *
 */


#ifndef PROCESS
#define PROCESS

#include "Vprocess.h"
#include "Vgroupids.h"
#include "Vethernet.h"
#include "config.h"  		/* Machine dependent */
#include "machine.h" 		/* Machine dependent */

#define WORDS_PER_PACKET (sizeof(kPacket) >> 2)
				/* Control words (longs) in a kernel packet.
				   Does NOT include the ethernet header.
				   XXXXXXXXXX
				   NOTE: the current size of kPacket is 64
				   bytes, which is a multiple of 
				   8.  This feature is used
				   in several places.  If the size should
				   be changed to no longer be a
				   multiple of 8 then all uses
				   of this constant should be checked for
				   correctness. */

/*
 * Team Descriptor Record
 */

typedef struct _TD
  {
    struct _TD	*next;		/* Doubly-linked */
    struct _TD	*prev;		/*   list ptrs. */
    ProcessId	team_root;	/* Process id of first team process */
    ProcessId	owner;
    short	team_priority;	/* Base priority for team processes */
    short	min_priority;	/* Smallest (highest) team member priority */
    struct LhnRecType 	*lhn;	/* Ptr to logical host number descr. for
				   this team. */
    Team_space 	team_space;	/* Descriptor of team space */
  }
    Team;

typedef struct _SQueue
  {
	struct _PD	*head;
	struct _PD	*tail;
	unsigned short	lock;
	unsigned short	type;
  } SyncQueue;

/* Values for the type field. - only used for postmortem, etc. */
#define READY_QUEUE	1
#define MSG_QUEUE	2
#define TIMEOUT_QUEUE	3
#define IKP_OUT_QUEUE	4
#define REPLY_QUEUE	5
#define DISK_QUEUE      6

/* Special values for localPid field.  The logical host number is 0,
 *   so these can't be confused with real pids. */
#define ALIEN_PROCESS 	0x100
#define INVALID_PROCESS	0x101
#define SUSPEND_PROCESS 0x102


/*
 * Defined values for the eType field of an ExtendPd structure.
 */
#define FORCE_EXCEPTION_TYPE 2

/*
 * Process Descriptor Record
 */

typedef struct _extendPd	/* Structure used with PDs that are used as
				   extra save areas. */
  {
    struct _extendPd *extendPd;	/* Ptr to next PD in the chain of save 
				   areas. */
    short eType;		/* Tag field indicating usage type of this
				   save area. */
    /* Convenience fields - the user can recast
       the rest of the PD any way they like. */
    unsigned v0;
    unsigned v1;
    unsigned v2;
    unsigned v3;
    unsigned v4;
  }
    *ExtendPd;

typedef struct _PD
  {
    struct _PD	*link;		/* General-purpose queue link.
				   MUST BE FIRST */
    struct _PD	*nextPd;	/* Ptr to the next pd on the chain of pd's 
				   that hashed to the same Pd_bundle entry. */
    struct _PD	*father;	/* Pointer to PD of creator */
    struct _PD	*brother;	/* Pointer to next sibling */
    struct _PD	*son;		/* List of processes created */
    ProcessId	localPid;	/* Local representation of pid:
				   real processes -	pid ,
				   alien processes - 	ALIEN_PROCESS,
				   invalid processes -	INVALID_PROCESS */
				   
    unsigned char  pdFlags;	/* Bit flags for process actions. */
    unsigned char state;	/* Blocked state else ready */
    unsigned short priority;	/* Processor allocation */
    Team	*team;		/* Team of process */
    struct _PD	*next_sender;	/* PD of next sending process */
    SyncQueue	msgq;		/* Sync queue of waiting messages */
    SyncQueue	replyq;		/* Sync queue of waiting reply messages */
    unsigned short  oldSeqNo;	/* Used to store the sequence number of a
				   remoteSend operation for retransmission.
				   (Move operations may change seqNo). */
    unsigned char  numTrans;	/* Number of retransmissions */
    unsigned char  dataSegmentPro; 
				/* Data segment protection */
    Unspec	*dataSegmentPtr;/* Begin of datasegment */
    unsigned	dataSegmentSize;/* End of datasegment */
    Unspec	*dataExpected;	/* Next data expected for Moves */
    Unspec	*remoteSegmentPtr;
    unsigned	processorTime;	/* In clicks */
    SyncQueue	*queuePtr;	/* Queue that the process is in, if any. */
    unsigned	*recBufSizePtr;	/* Address for size on immediate receive */
    Unspec	(*finish_up)();	/* Called when process unblocks */
    Unspec	*returnMessage;	/* Location to save returnMessage pointer. */
    Unspec	*segmentPtr;
    unsigned	segmentSize;
    Unspec	*currentSegmentPtr;
/***
   This part of the process descriptor corresponds to a V interkernel
   packet. It HAS to be consistent with the packet format defined in
   Vikc.h. The NetworkHeader field is defined in config.h
***/
    unsigned short  packetType;
    unsigned short  seqNo;	/* Sequence number. 
				   = kp.sequenceNo */
    Process_id	pid;		/* Process identifier 
				   = kp.srcPid */
    Process_id	blocked_on;     /* Process blocked on (which may be
				   the kernel process or device server).
				   = kp.dstPid */
    Process_id	forwarder;	/* Process forwarder by 
				   = kp.forwarder */
    unsigned 	userNumber;
    unsigned	length;
    Unspec	*localaddress;
    Unspec	*remoteaddress;
    MsgStruct	msg; /* Process message buffer */
/***
   End of kernel packet part.
***/

    /* Time-specified parameters. */
    unsigned	decayTime;	/* Clicks at last priority decay */
    unsigned	decayRate;	/* Clicks of activity between priority decay */
    Unspec	(*timeout_func)(); /* Called when timeout. */
    unsigned	timeout_count;	/* Clicks until timeout - relative to prev. */
				/* process in delay queue when queued. */

    ExtendPd extendPd;		/* Ptr to next PD in a chained list of save
				   areas. */
    Unspec	trap_params[4];	/* Kludgey place to stick return values */
    /* Machine-specific processor state */
    KProcessor_state  proc_state;
  }
    Process;

/* pdFlags bit assignments. */
#define TRAP_ON_SEND_FAIL	0x80	/* Trap if Send fails. */
#define SEND_ACKED		0x40	/* Breath of life, MoveTo or
					 * Movefrom received. */
#define MULTI_PACKET_REPLY	0x20	/* Waiting for second or later packets
					 * in multi-packet reply
					 */
#define SUSPEND_FLAG 		0x10	/* Process has been suspended by a
					   call to ForceSend. */
#define FROZEN		 	0x08	/* The process is frozen and all
					   kernel operations are deferred. */
/* NOTE: MSG_FLAG is used in ActivateReadyqHead in machine.c, and in the m68k
 * trap code (in trap.c). This code assumes that MSG_FLAG == 2.
 */
#define MSG_FLAG		0x02	/* Set if a message needs to be copied
					   into user space when the process
					   is readied */
#define LOCAL_ALIENS_PRESENT	0x01	/* If the previous send left local 
					   aliens */
#define KING_OF_SPAIN		0x00	/* Set if the process is Juan Carlos */

/* 
 * Logical host number descriptor. 
 */

typedef struct LhnRecType
  {
    struct LhnRecType  *next;	/* Ptr to next lhn record in a list. */
    struct LhnRecType  *prev;	/* Ptr to prev lhn record in a list. */
    unsigned 	lhn;		/* Logical host number. */
    unsigned	pidGen;		/* Counter used to generate new pids for the
				   processes of a logical host. */
    unsigned short flags;	/* State flags.
				   FROZEN => host is frozen. */
    Team *teams;		/* List of teams on this logical host. */
    SyncQueue requestQ;		/* Queue of deferred kernel server operations
				   for a frozen logical host. */
  } LhnRec;


/* dataSegmentPro bit fields */

#define READ_ACCESS		0x08
#define WRITE_ACCESS		0x04
#define SEGMENT_ACCESS		0x0C /* Segment if either READ or WRITE */

#define PROCESS_PRIORITY_MASK	0x00ff
#define TEAM_PRIORITY_MASK	0xff00

#define DEFAULT_TEAM_PRIORITY	0x1000
#define MAX_PROCESS_PRIORITY	0x00ff
#define STOPPED_TEAM_PRIORITY	0xff00
#define DEFAULT_ALIEN_PRIORITY	0x0701
#define NULL_PROCESS_PRIORITY   0xfdff /* Very high */

#define LOCAL_KERNEL_PROCESS_PID (0x4000)
#define LOCAL_DEVICE_SERVER_PID (0x4001)

#define FOREVER			0xefffffff
				/* "Long" timeout period.  Don't make it
				   0xffffffff because the DelayClickCount
				   is added to it to account for missed
				   clock ticks in the delay queue. */

#define V_BOOT_LHN		0xd0d0
				/* This LHN isn't cached, so replies to it
				 * are always broadcast. This is in case
				 * two hosts are booting simultaneously.
				 */

#define PidLhn(pid) ((pid) & LOGICAL_HOST_PART)
				/* Extract the logical host number out of a
				   pid. */
#define PidLocalPart(pid) ((pid) & 0xffff)
				/* Extract the local host part of a pid. */

#define min(a,b) (((a) < (b)) ? (a) : (b))


/* Map pid to a process descriptor, setting pd to point to it. Returns
   the pd or NULL if a valid one can't be found. 
   NOTE: these macros have deliberately been given capitalized names because
   they cannot transparently be turned into functions - pd is assigned to! */

#define MAP_TO_RPD(pd, pcsId)						     \
	(((pd = Pd_bundle[(pcsId) & PID_HASH_MASK])->localPid == 	     \
								 pcsId) ?    \
	 pd : (pd = RPdChain(pd, pcsId)))
#define MAP_TO_APD(pd, pcsId)						     \
	(((pd = AlienMap[(pcsId) & PID_HASH_MASK])->pid == pcsId) ? \
	 pd : (pd = APdChain(pd, pcsId)))

extern Process *Pd_bundle[], *AlienMap[], *IdleProcessPtr;
extern Process *MapPid(), *RPdChain(), *APdChain();
/* Test macros if pd represents a local or alien process. */
/* These are only valid if pd is linked in the Pd_bundle structure. */

#define LocalProcess( pd ) (pd->pid == pd->localPid)
#define AlienProcess( pd ) (pd->localPid == ALIEN_PROCESS)
#define AuthenticationServer(pd)  (pd->msg.unspecified[3] == 3141596)

/* Format for system-maintained time. */
typedef struct
  {
    long    seconds;
    int    clicks; /* mod CLICKS_PER_SECOND */
  } TimeRecord;

extern int Debug1, Debug2, Debug3;

#endif
