/* printx.c: simple debugging-output functions */

/* These routines will print on anything, provided you define putchar
 * appropriately.  This version is for the kernel, and uses a separately
 * compiled putchar routine.  Note: putchar should convert \n to \r\n
 * for nice results.
 */


#include "process.h"

#undef putchar
#define putchar K_putchar	/* This macro definition is needed to avoid
				   conflict with the defn. in Vio.h - which
				   gets included in various kernel source
				   files.  K_putchar() is a machine-dependent
				   kernel-level version of putchar. */


print(s)
  register char *s;
  {
    while (*s)
	putchar(*s++);
  }


printx(string)
  char *string;
  {
    register int *argp = (int *) &string;
    register char *s = string;
    register int c;

    argp++;
    while(*s)
      {
	if (*s == '%')
	  {
	    s++;
	    switch(*s++)
	      {
	      case 's': print(*argp++);  break;
	      case 'x': hexprint(*argp++);  break;
	      case 'd': decprint(*argp++);  break;
	      case 'o': octprint(*argp++);  break;
	      case 'c': 
		c = *argp++;
		putchar(c);
		break;
	      default:
		putchar(*(s-2));
		putchar(*(s-1));
	      }
	  }
	else putchar(*s++);
      }
  }


/* unsigned hexadecimal print */
hexprint(n)
  register unsigned n;
  {
    register unsigned i, digit, pflag = 0;

    for (i=0; i<8; i++)
      {
	digit = (n >> 28);
	if (digit != 0 || i == 7) pflag = 1;
	if (pflag) 
	  {
	    if (digit > 9) digit += 'a'-10;
	    else digit += '0';
	    putchar(digit);
	  }
	n <<= 4;
      }
  }


/* Unsigned octal print.  We build the character string backwards. */
octprint(n)
  register unsigned n;
  {
    register unsigned digit;
    static char octbuf[14];
    register char *p = octbuf+13;

    *p-- = 0;
    if (n==0)  { putchar('0'); return; }
    while (n != 0)
      {
	digit = n & 07;
	n >>= 3;
	*p-- = digit + '0';
      }
    p++;
    print(p);
  }


/* Signed decimal print.  We build the character string backwards. */
decprint(n)
  register int n;
  {
    register unsigned digit, nflag=0;
    static char decbuf[12];
    register char *p = decbuf+11;

    *p-- = 0;
    if (n<0)   { n = -n; nflag++; }
    if (n==0)  { putchar('0'); return; }
    while (n != 0)
      {
	digit = n % 10;
	n = n / 10;
	*p-- = digit + '0';
      }
    if (nflag) *p-- = '-';
    p++;
    print(p);
  }
