/*
 * V Kernel - Copyright (c) 1984 by Stanford University
 *
 * Kernel null device support routines for the device server
 *
 * The nullout device is an endless sink for output.
 * The nullin device returns END_OF_FILE on all reads.
 */

#include "process.h"
#include "dm.h"

/* Imports */
extern SystemCode NotSupported();
extern DeviceInstance *GetDevice();

/* Exports */
SystemCode NullInCreate();
SystemCode NullOutCreate();

/* Private */
SystemCode NullRead();
SystemCode NullWrite();
SystemCode NullRelease();

/* Routines */
SystemCode NullInCreate( pd, inst )
    register Process *pd;
    register DeviceInstance *inst;
  {
  /*
   * Create a null input instance -- a fixed-length empty file.
   */
    register CreateInstanceRequest *req = (CreateInstanceRequest *) &pd->msg;

    if (req->filemode != FREAD) return (MODE_NOT_SUPPORTED);

    /*
     * Initialize the device instance descriptor, can assume all fields
     * are zero except for id and owner.
     */

    inst->readfunc = NullRead;
    inst->writefunc = NotSupported;
    inst->modifyfunc = NotSupported;
    inst->queryfunc = NotSupported;
    inst->releasefunc = NullRelease;

    inst->type = (READABLE+FIXED_LENGTH);
    inst->blocksize = sizeof(char);
    inst->lastblock = 0;
    inst->lastbytes = 0;

    return( OK );
  }

SystemCode NullOutCreate( pd, inst )  
    register Process *pd;
    register DeviceInstance *inst;
  {
  /*
   * Create a null output instance.
   */
    register CreateInstanceRequest *req = (CreateInstanceRequest *) &pd->msg;

    if (req->filemode != FCREATE && req->filemode != FAPPEND)
	return (MODE_NOT_SUPPORTED);

    /*
     * Initialize the device instance descriptor, can assume all fields
     * are zero except for id and owner.
     */

    inst->readfunc = NotSupported;
    inst->writefunc = NullWrite;
    inst->modifyfunc = NotSupported;
    inst->queryfunc = NotSupported;
    inst->releasefunc = NullRelease;

    inst->type = WRITEABLE;
    inst->blocksize = 1024;
    inst->lastblock = MAXUNSIGNED;   /* indicate file is of unknown size */
    inst->lastbytes = MAXUNSIGNED;

    return( OK );

  }


static SystemCode NullWrite( pd, inst )
    Process *pd;
    DeviceInstance	*inst;
    /*
     * Handle a write instance request for the null device
     */

  {
    return (OK);
  }



static SystemCode NullRelease(pd, inst)
    Process *pd;
    DeviceInstance *inst;
  {
    inst->owner = 0;
    return (OK);
  }


static SystemCode NullRead( pd, inst )
    Process *pd;
    DeviceInstance 	*inst;
/*
 * Handle a read instance request for the null device
 */
  {
    register IoReply *reply = (IoReply *) &pd->msg;

    reply->bytecount = 0;
    return (END_OF_FILE);
  }
