/*
 * Kernel Logical Host Migration Routines, part 1
 */


#include "migrate.h"


extern Logical_id_entry Logical_id_map[];
extern Process *FindSuspendPd();
extern GroupMember *Group_bundle[GROUP_MASK+1];

extern ProcessId SendnAck(),
	SuspendFinishUp(), SuspendFinishUpNoRetVal(), 
	FinishLhn(), FinishGetPid(),
	ReReceive(), InitFinishUpFcn(), KernelServer(),
	CleanUpSuspend(), ReReceive(), ReDelay(),
	ReMoveFrom(), ReMoveTo(), JoinGroupFinishup();

extern ProcessId DestroyAlien(), Addready(), LocalGroupTimeout(), Retransmit(),
	WriteKPacket(), GroupReplyDelay(), KReceiveSpecific(),
	CheckFrozenSender(), RebootTimeout();

ProcessId BogusFcn();

SystemCode CopyOutLHost(), CopyOutLHostInfo();
char *CopyProcessDescription();
char *DoProcessDescriptions();


#define LINK_TO_PID(dest, src, field) 					\
	dest->field = (Process *) ((src->field == NULL) ? 0 : src->field->pid)


Unspec *FinishUpFcnTable[] =
  {
    0,
    (Unspec *) BogusFcn,
    (Unspec *) BogusFcn,	/* used to be ReturnMessage() */
    (Unspec *) SendnAck, 
    (Unspec *) InitFinishUpFcn,
    (Unspec *) KernelServer,
    (Unspec *) FinishLhn,
    (Unspec *) FinishGetPid,
    (Unspec *) SuspendFinishUp,
    (Unspec *) SuspendFinishUpNoRetVal,
    (Unspec *) CleanUpSuspend,
    (Unspec *) ReReceive,
    (Unspec *) ReDelay,
    (Unspec *) ReMoveFrom,
    (Unspec *) ReMoveTo,
    (Unspec *) JoinGroupFinishup,
    0
  };

Unspec *TimeoutFcnTable[] =
  {
    0,
    (Unspec *) BogusFcn,
    (Unspec *) DestroyAlien,
    (Unspec *) Addready,
    (Unspec *) LocalGroupTimeout,
    (Unspec *) Retransmit,
    (Unspec *) KReceiveSpecific,
    (Unspec *) WriteKPacket,
    (Unspec *) GroupReplyDelay,
    (Unspec *) CheckFrozenSender,
    (Unspec *) RebootTimeout,
    0
  };


/**************************************************************************
 External routines
 *************************************************************************/


/*
 * ExtractHost:
 */

SystemCode ExtractHost(active)
    Process *active;
  {
    int opType;
    register Team *oldteam;
    register KernelRequest *req = (KernelRequest *) &active->msg;
    SystemCode status = OK;

    oldteam = GetAddressableTeam();
    SetAddressableTeam(active->team);
    opType = req->unspecified[0];
    if (opType == QUERY_HOST_CASE)
      {
	status = CopyOutLHostInfo(req);
      }
    else
      {
	status = CopyOutLHost(req);
      }
    SetAddressableTeam(oldteam);
    return(status);
  }


/**************************************************************************
 Internal routines
 *************************************************************************/


/**** Internal routines for ExtractHost ****/


SystemCode CopyOutLHostInfo(req)
    KernelRequest *req;
  {
    char *dest;
    ProcessId pid;
    int nT, nP;
    int i;
    unsigned totalMemory;
    ProcessId *processes;
    unsigned *memSizes;
    Process *pd;
    Team *td;
    LhnRec *ld;
    HostResourcesRec *hdr;

    dest = (char *) req->segment;
    pid = req->pid;
    if (!MAP_TO_RPD(pd, pid))
      {
	return(BAD_ARGS);
      }
    ld = pd->team->lhn;

    hdr = (HostResourcesRec *) dest;
    processes = (ProcessId *) (dest + sizeof(HostResourcesRec));

    for (td = ld->teams, nT = 0; td != NULL; td = td->next, nT++)
      {
        ;
      }
    dest += sizeof(MHdr) + sizeof(LhnRec);
    memSizes = (unsigned *) (((char *)processes) + nT * sizeof(ProcessId));
    totalMemory = 0;
    for (i = 0, td = ld->teams; i < nT; i++, td = td->next)
      {
        processes[i] = td->team_root;
	memSizes[i] = ((unsigned) td->team_space.size) - TEAM_ORIGIN;
	totalMemory += memSizes[i];
	dest += sizeof(Team);
      }

    /* Traverse process descriptions. */
    nP = 0;
    for (td = ld->teams; td != NULL; td = td->next)
      {
	MAP_TO_RPD(pd, td->team_root);
	dest = CopyProcessDescription(dest, pd, &nP, 0);
	if (pd->son != NULL)	/* NOTE: We assume that all teams are created 
				   by the team server, which resides on the 
				   system lhost, which is never frozen.
				   Hence, all sons of the root process must 
				   be on the same team. */
	  {
	    dest = DoProcessDescriptions(dest, pd->son, &nP, 0);
	  }
      }

    hdr->numTds = nT;
    hdr->numPds = nP;
    hdr->totalMemory = totalMemory;
    hdr->descSize = (unsigned) (((unsigned) dest) - 
    			              ((unsigned) req->segment));
    return(OK);
  }


SystemCode CopyOutLHost(req)
    KernelRequest *req;
  {
    char *dest;
    ProcessId pid;
    Process *pd;
    Team *td;
    LhnRec *ld;
    MHdr *hdr;

    dest = (char *) req->segment;
    pid = req->pid;
    hdr = (MHdr *) dest;
    dest += sizeof(MHdr);
    if (!MAP_TO_RPD(pd, pid))
      {
	return(BAD_ARGS);
      }
    ld = pd->team->lhn;
    if (!(ld->flags & FROZEN))
      {
	return(BAD_STATE);
      }

    /* Copy lhost desc. and team descs. */
    Copy(dest, ld, sizeof(LhnRec));
    dest += sizeof(LhnRec);
    hdr->nTds = 0;
    for (td = ld->teams; td != NULL; td = td->next)
      {
	hdr->nTds += 1;
	Copy(dest, td, sizeof(Team));
	dest += sizeof(Team);
      }

    /* Copy process descriptions. */
    hdr->nPds = 0;
    for (td = ld->teams; td != NULL; td = td->next)
      {
	MAP_TO_RPD(pd, td->team_root);
	dest = CopyProcessDescription(dest, pd, &hdr->nPds, 1);
	if (pd->son != NULL)	/* NOTE: We assume that all teams are created 
				   by the team server, which resides on the 
				   system lhost, which is never frozen.
				   Hence, all sons of the root process must 
				   be on the same team. */
	  {
	    dest = DoProcessDescriptions(dest, pd->son, &hdr->nPds, 1);
	  }
      }

    req->unspecified[0] = (unsigned) (((unsigned) dest) - 
    			              ((unsigned) req->segment));
				/* Return length of descriptor. */
    return(OK);
  }


char *DoProcessDescriptions(dest, pd, nP, flag)
    char *dest;
    Process *pd;
    int *nP;
    int flag;
  {
    dest = CopyProcessDescription(dest, pd, nP, flag);
    if (pd->son != NULL)
      {
	dest = DoProcessDescriptions(dest, pd->son, nP, flag);
      }
    for (pd = pd->brother; pd != NULL; pd = pd->brother)
      {
	dest = CopyProcessDescription(dest, pd, nP, flag);
	if (pd->son != NULL)
	  {
	    dest = DoProcessDescriptions(dest, pd->son, nP, flag);
	  }
      }
    return(dest);
  }


char *CopyProcessDescription(dest, pd, nP, flag)
    char *dest;
    Process *pd;
    int *nP;
    int flag;
  {
    Process *pdSuspend;
    ExtendPd epd;
    Process *upd, *pd1;
    ProcessId *uPtr;
    int i;
    int nExtend, nMsgq, nGrpMem, nLid;
    GroupMember *gp;

    *nP += 1;
    upd = (Process *) dest;

    /* Copy main process descriptor. */
    if (flag)
      {
	CopyProcessDesc(dest, pd);
      }
    dest += sizeof(Process);

    /* Copy the suspend desc. if there is one. */
    pdSuspend = FindSuspendPd(pd->pid);
    if (pdSuspend != NULL)
      {
	/* Use the nextPd to signal whether a suspend PD is present. */
	if (flag)
	  {
	    upd->nextPd = (Process *) 1;
	    CopyProcessDesc(dest, pdSuspend);
	  }
	dest += sizeof(Process);
      }
    else
      {
        if (flag)
	  {
	    upd->nextPd = (Process *) 0;
	  }
      }

    /* Copy any extendPd's. */
    for (epd = pd->extendPd, nExtend = 0; 
         epd != NULL; 
	 epd = epd->extendPd, nExtend++)
      {
        if (flag)
	  {
	    Copy(dest, epd, sizeof(Process));
	  }
	dest += sizeof(Process);
      }

    /* Copy message queues.  (We've already recorded the number of msgs.) */
    for (pd1 = pd->msgq.head, nMsgq = 0;
         pd1 != pd->next_sender; 
	 pd1 = pd1->link, nMsgq++)
      {
	if (flag)
	  {
	    uPtr = (ProcessId *) dest;
	    *uPtr++ = (ProcessId) pd1->localPid;
				/* Record whether this is an alien or not. */
	    *uPtr++ = (ProcessId) pd1->msgq.head;
	    *uPtr++ = (ProcessId) pd1->msgq.tail;
	    Copy(uPtr, &pd1->packetType, sizeof(kPacket));
	  }
	dest += 3 * sizeof(ProcessId) + sizeof(kPacket);
      }

    /* We don't copy reply messages. */

    /* Copy group memberships. */
    for (i = 0, nGrpMem = 0; i < GROUP_MASK; i++)
      {
	for (gp = (GroupMember *) Group_bundle[i];
	     gp != NULL;
	     gp = gp->link)
	  {
	    if (gp->pid == pd->pid)
	      {
	        if (flag)
		  {
		    *((ProcessId *)dest) = gp->groupId;
		  }
		nGrpMem++;
		dest += sizeof(ProcessId);
	      }
	  }
      }

    /* Copy logical id registrations. */
    for (i = 0, nLid = 0; i < MAX_LOGICAL_ID+1; i++)
      {
	if (Logical_id_map[i].pid == pd->pid)
	  {
	    if (flag)
	      {
		*((int *)dest) = i;
		*( ((int *)dest) + 1) = Logical_id_map[i].scope;
	      }
	    nLid++;
	    dest += sizeof(int) + sizeof(int);
	  }
      }

    if (flag)
      {
	upd->extendPd = (ExtendPd) nExtend;
	upd->msgq.head = (Process *) nMsgq;
	upd->replyq.head = (Process *) nGrpMem;
	upd->replyq.tail = (Process *) nLid;
      }

    return(dest);
  }


CopyProcessDesc(dest, pd)
    char *dest;
    Process *pd;
  {
    Process *upd;
    Process *receiver, *pd1;

    Copy(dest, pd, sizeof(Process));
    upd = (Process *) dest;
    LINK_TO_PID(upd, pd, father);
    LINK_TO_PID(upd, pd, brother);
    LINK_TO_PID(upd, pd, son);
    upd->team = (Team *) pd->team->team_root;
    upd->finish_up = (Unspec (*)()) FinishUpIndex(pd->finish_up);
    upd->timeout_func = (Unspec (*)()) TimeoutIndex(pd->timeout_func);
    if (pd->queuePtr != NULL)
      {
	upd->queuePtr = (SyncQueue *) pd->queuePtr->type;
	if ((pd->queuePtr->type == MSG_QUEUE) &&
	    (PidLhn(pd->pid) == PidLhn(pd->blocked_on)))
	  {
	    /* We are blocked on a process in the same l.host.
	       Need to signal whether we are before the next_sender ptr. */
	    MAP_TO_RPD(receiver, pd->blocked_on);
	    for (pd1 = receiver->msgq.head; 
	         pd1 != receiver->next_sender;
		 pd1 = pd1->link)
	      {
		if (pd1 == pd)
		  {
		    upd->queuePtr =(SyncQueue *) (MSG_QUEUE + 0x80000000);
		    break;
		  }
	      }
	  }
      }
  }


/*
 * BogusFcn:
 */

ProcessId BogusFcn()
  {
    Kabort("BogusFcn!!!  Should never have gotten here!");
  }


/*
 * NoopFcn:
 */

ProcessId NoopFcn()
  {
    return(0);
  }


/*
 * FinishUpIndex:
 */

FinishUpIndex(fcn)
    Unspec *fcn;
  {
    register int i;

    if (fcn == NULL)
      {
	return(0);
      }
    for (i = 2; FinishUpFcnTable[i] != 0; i++)
      {
	if (FinishUpFcnTable[i] == fcn)
	  {
	    return(i);
	  }
      }
    return(1);
  }


/*
 * TimeoutIndex:
 */

TimeoutIndex(fcn)
    Unspec *fcn;
  {
    register int i;

    if (fcn == NULL)
      {
	return(0);
      }
    for (i = 2; TimeoutFcnTable[i] != 0; i++)
      {
	if (TimeoutFcnTable[i] == fcn)
	  {
	    return(i);
	  }
      }
    return(1);
  }
