/*
 * Distributed V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1983 Stanford University.
 *
 *	Kernel Server Process
 */
/* #define DEBUG 1 */

#include "Venviron.h"
#include "Vprofile.h"
#include "process.h"

/* Imports */
extern ProcessId KReceiveSpecific();
extern int Addready();
extern SyncQueue Readyq;
extern ProcessBlock ProcBlock;
extern Team *FirstTeam;
extern Process *FindSender();

extern	SystemCode CreateProcess(), DestroyProcess(), QueryProcessState(),
	WriteProcessState(), CreateTeam(), SetTeamPriority(),
	SetTeamSize(), Wakeup(), SetTime(), GetTime(), SetPid(), GetRealPid(),
	QueryGroup(), CreateGroup(), JoinGroup(), LeaveGroup(), InitReboot(),
	QueryKernel(), ForceSend(), ForceException(), QueryProcessorUsage(),
	SetObjectOwner(),
	CreateHost(), DestroyHost(), FreezeHost(), UnfreezeHost(),
	ExtractHost(), TransferHost(),
	doCopyFrom(), doCopyTo();
#ifdef VM
extern	SystemCode SetAccess(), QueryPage(), BindRegion(), UnbindRegion(),
	Prepage();
#endif VM

/* Exports */
extern KernelServer();
ProcessId KernelServerPid;
ProcessId Kernel_Process_Pid;
Process *KernelServerPd;
ProcessBlock ProcBlock;

extern Team *TeamDescriptors;
extern Process *ProcessDescriptors;

InitKernelServer( active )
    register Process *active;
  {
    register Process *kserver;
    register KernelRequest *req = (KernelRequest *) &active->msg;

    KernelServerPid = PidLhn(active->pid) + LOCAL_KERNEL_PROCESS_PID;
    Kernel_Process_Pid = KernelServerPid;/* So we can have both for now. */
    req->pid = KernelServerPid;
    req->unspecified[0] = 0; /* Priority: set high? */
    req->unspecified[1] = 0; /* Entry: Not used */
    req->unspecified[2] = 0; /* Stack: not used. */
    req->unspecified[3] = 0; /* Logical host: same one. */
    if( (CreateProcess(active) != OK) || (req->pid != KernelServerPid) )
      {
 	printx("Kernel Server create: pid %x\n", req->pid );
	Kabort("Bad Kernel Server" );
      }
    if( (kserver = MapPid(KernelServerPid)) == NULL )
	Kabort("Invalid Kernel Server Pid" );
    RemoveQueue( kserver );

    /* 
     * Join the kernel server groups. 
     */
    /* Join the global kernel server group. */
    kserver->forwarder = KernelServerPid; /* Authorizes joining the group. */
    req = (KernelRequest *) &(kserver->msg);
    req->unspecified[0] = VKERNEL_SERVER_GROUP;
    req->pid = KernelServerPid;
    if( JoinGroup(kserver) != OK )
	Kabort("Kernel server failed to join VKERNEL_SERVER_GROUP" );

    /* Join the local kernel server groups, one per logical host and the
       "default" 0 l.host one. */
    kserver->forwarder = KernelServerPid; 
    req->unspecified[0] = LKERNEL_SERVER_GROUP;
    req->pid = KernelServerPid;
    if( JoinGroup(kserver) != OK )
	Kabort("Kernel server failed to join LKERNEL_SERVER_GROUP" );

#ifdef undef
    kserver->forwarder = KernelServerPid; 
    req->unspecified[0] = PidLhn(KernelServerPid) | LKERNEL_SERVER_GROUP;
    req->pid = KernelServerPid;
    if( JoinGroup(kserver) != OK )
	Kabort("Kernel server failed to join LKERNEL_SERVER_GROUP" );
#endif

    KernelServerPd = kserver;
    kserver->finish_up = (Unspec (*)()) KernelServer;
    kserver->blocked_on = 0; /* No current sender. */

    Addready( kserver );    
  }

char KernelServerBuffer[1024];

#define FORWARD_NONLOCAL_REQ()						\
	if( !Local(req->pid) && !IsGlobalGroupId(req->pid) )		\
	  {								\
	    pd->blocked_on = PidLhn(req->pid)+LOCAL_KERNEL_PROCESS_PID;	\
	    pd->forwarder = KernelServerPid;				\
	    if( AlienProcess(pd) ) NonLocalForward( pd );		\
	    else NonLocalSend( pd );					\
	    continue;							\
	  }
/* Same as above but does not forward if a group send. */
#define FORWARD_NONLOCAL_REQ2()						\
	if( !Local(req->pid) && !IsGroupId(pd->forwarder) )		\
	  {								\
	    pd->blocked_on = PidLhn(req->pid)+LOCAL_KERNEL_PROCESS_PID;	\
	    pd->forwarder = KernelServerPid;				\
	    if( AlienProcess(pd) ) NonLocalForward( pd );		\
	    else NonLocalSend( pd );					\
	    continue;							\
	  }

KernelServer( active ) 
    register Process *active;
  /*
   * Kernel Server: implements kernel memory management, time and
   * process management operations.
   */
  {
    register SystemCode replycode;
    register Process *pd, *upd, *tmppd;
    register KernelRequest *req;
    LhnRec *lhn;
    unsigned long KernelServerRecSize;

    KernelServerRecSize = (unsigned long) SentSegmentSize(active);

    for(;;)
      {
	/* Receive next message. */
	Lockq( &(active->msgq) );
	if( (pd = active->msgq.head) == NULL )
	  { /* No messages - wait for messages. */
/*%%%*/
if ( active->next_sender != NULL )
printx("KernelServer: next_sender disagrees with msgq.head\n");

	    active->blocked_on = 0;
	    active->state = RECEIVE_BLKED;
	    active->pdFlags |= MSG_FLAG;
	    active->dataSegmentPtr = (Unspec *)KernelServerBuffer;
	    active->dataSegmentSize = 1024;
	    active->finish_up = (Unspec (*)()) KernelServer;
	    Unlockq( &(active->msgq) );

	    /* Arrange to check periodically for messages. */
	    active->timeout_func = (Unspec (*)()) KReceiveSpecific;
	    active->timeout_count = 0xffff; /*CLICKS_PER_SEC/4; /* Fix - drc */

	    DelayProcess( active );
	    return; /* Wait for next message */
	  }

	/* Advance to next sender. */
	if( active->next_sender == pd ) active->next_sender = pd->link;
	/* Remove from msg queue. */
	if( (active->msgq.head = pd->link) == NULL )
	    active->msgq.tail = (Process *) &(active->msgq.head);
	pd->queuePtr = NULL;
	Unlockq( &(active->msgq) );

	req = (KernelRequest *)&(pd->msg);
#ifdef DEBUG
{register int *i = (int *)req;

printx("KS(%x): %x %x %x %x %x %x %x %x\n",
pd->pid, i[0], i[1], i[2], i[3], i[4], i[5], i[6], i[7]);}
#endif
	active->segmentSize = 0;  /* Assume no buffer of data to return. */

	if( req->pid == 0 ) req->pid = pd->pid;

	MAP_TO_RPD(upd, req->pid);
	if ((upd != NULL) && (upd->pdFlags & FROZEN))
	  {
	    /* May have to defer the request. */
	    switch (req->opcode)
	      {
		case QUERY_PROCESS:
		case CREATE_HOST:
		case DESTROY_HOST:
		case FREEZE_HOST:
		case UNFREEZE_HOST:
		case EXTRACT_HOST:
		case TRANSFER_HOST:
		case QUERY_PROCESS_PRIORITY:
		case SETTIME:
		case GETTIME:
		case SETPID:
		case GET_PID:
		case CREATE_GROUP:
		case QUERY_GROUP:
		case QUERY_KERNEL:
		case GET_FORWARDER:
		case GET_USER_NUMBER:
		case CLEAR_MODIFIED_PAGES:
		case RETURN_MODIFIED_PAGES:
		case QUERY_PROCESSOR_USAGE:
		case SET_DEBUG_MODE:
		case REBOOT:
		case KMEM:
		case PROFILE:
		case GET_OBJECT_OWNER:
		case COPY_FROM:	/* These get controlled later on. */
		case COPY_TO:	/* These get controlled later on. */
#ifdef VM
		case QUERY_PAGE:
#endif VM
		    /* Let it happen. */
		    break;

		case DESTROY_PROCESS:
		case MODIFY_PROCESS:
		case CREATE_TEAM:
		case SET_PROCESS_PRIORITY:
		case SET_TEAM_PRIORITY:
		case JOIN_GROUP:
		case LEAVE_GROUP:
#ifndef VM
		case SET_TEAM_SIZE:
#endif VM
		case WAKEUP:
		case SET_USER_NUMBER:
		case FORCE_EXCEPTION:
		case SET_OBJECT_OWNER:
#ifdef VM
		case SET_ACCESS:
		case BIND_REGION:
		case UNBIND_REGION:
		case PRE_PAGE:
#endif VM
		    /* Don't let it happen.  Queue on logical host desc.
		       queue. */
		    lhn = upd->team->lhn;
		    Lockq(&lhn->requestQ);
		    pd->queuePtr = &lhn->requestQ;
		    pd->link = lhn->requestQ.head;
		    lhn->requestQ.head = pd;
		    if (pd->link == NULL) lhn->requestQ.tail = pd;
		    Unlockq(&lhn->requestQ);
		    continue;

		case CREATE_PROCESS:
		case DELAY:
		    /* Can't ever happen.  Must be bad args.*/
		default:
		    /* Bogus request code. */
		    goto badArgs;
	      }
	  }

	switch( req->opcode )
	  {
	    case COPY_FROM:
	      {
		replycode = doCopyFrom( pd );
		break;
	      }
	    case COPY_TO:
	      {
		replycode = doCopyTo( pd );
		break;
	      }
	    case CREATE_PROCESS:
	      {
	        req->unspecified[3] = 0;
		replycode = CreateProcess( pd );
		break;
	      }
	    case DESTROY_PROCESS:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = DestroyProcess(pd);
		if( pd->pid == 0 ) continue; /* Requesting process destroyed */
		break;
	      }
	    case QUERY_PROCESS:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = QueryProcessState( pd );
		if (DifferentByteOrder(pd->pid))
		    ByteSwapProcessBlock((ProcessBlock *)&ProcBlock);
		active->segmentPtr = (Unspec *) &ProcBlock;
		active->segmentSize = sizeof(ProcessBlock);
		active->remoteSegmentPtr = (Unspec *) req->segment;
		break;
	      }
	    case MODIFY_PROCESS:
	      {
		FORWARD_NONLOCAL_REQ();
		if( KernelServerRecSize < sizeof(Processor_state) )
		  {
		    replycode = RETRY;
		    break; /* Dont try to do a CopyFrom. */
		  }
	        req->segment = (char *) KernelServerBuffer;
		if (DifferentByteOrder(pd->pid))
		    ByteSwapProcessor_state((Processor_state *)req->segment);
		replycode = WriteProcessState( pd );
		break;
	      }
	    case CREATE_TEAM:
	      {
		replycode = CreateTeam( pd );
		break;
	      }
	    case CREATE_HOST:
	      {
		replycode = CreateHost( pd );
		break;
	      }
	    case DESTROY_HOST:
	      {
		replycode = DestroyHost( pd );
		break;
	      }
	    case FREEZE_HOST:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = FreezeHost( pd );
		break;
	      }
	    case UNFREEZE_HOST:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = UnfreezeHost( pd );
		break;
	      }
	    case EXTRACT_HOST:
	      {
		replycode = ExtractHost( pd );
		break;
	      }
	    case TRANSFER_HOST:
	      {
		replycode = TransferHost( pd );
		break;
	      }
	    case SET_PROCESS_PRIORITY:
	      {
		replycode = SetProcessPriority( pd );
		break;
	      }
	    case QUERY_PROCESS_PRIORITY:
	      {
		replycode = QueryProcessPriority( pd );
		break;
	      }
	    case SET_TEAM_PRIORITY:
  	      {
		FORWARD_NONLOCAL_REQ();
		replycode = SetTeamPriority( pd );
		break;
	      }
	    case GET_OBJECT_OWNER:
	    case SET_OBJECT_OWNER:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = SetObjectOwner( pd );
		break;
	      }
#ifndef VM
	    case SET_TEAM_SIZE:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = SetTeamSize( pd );
		break;
	      }
#endif VM
	    case DELAY:
	      {
		/* It is assumed that the total
		 * number of clicks (i.e. seconds*CLICKS_PER_SEC+clicks)
		 * can be stored in a long unsigned number.

		/* Convert seconds and clicks to clicks */
		pd->timeout_count = req->unspecified[0]*CLICKS_PER_SEC +
			req->unspecified[1];

		replycode = OK;
		if( pd->timeout_count == 0 ) break;

		/* Initialize values in reply message in case the full delay
		 *   period expires with no Wakeup */
		req->unspecified[1] = 0;	/* remaining time */
		/* Add to ready queue on timeout. */
		pd->timeout_func = (Unspec (*)()) Addready;
		pd->state = DELAYING;	/* indicate that Wakeup() allowed. */
		DelayProcess( pd );
		continue;
	      }
	    case WAKEUP:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = Wakeup( pd );
		break;
	      }
	    case SETTIME:
	      {
		replycode = SetTime( pd );
		break;
	      }
	    case GETTIME:
	      {
		replycode = GetTime( pd );
		break;
	      }
	    case SETPID:
	      {
		replycode = SetPid( pd );
		break;
	      }
	    case GET_PID:
	      {
		replycode = GetRealPid( pd );
		break;
	      }
	    case CREATE_GROUP:
	      {
		FORWARD_NONLOCAL_REQ2();
		replycode = CreateGroup( pd );
		break;
	      }
	    case JOIN_GROUP:
	      {
		replycode = JoinGroup( pd );
		break;
	      } 
	    case QUERY_GROUP:
	      {
		FORWARD_NONLOCAL_REQ2();
		replycode = QueryGroup( pd );
		break;
	      } 
	    case LEAVE_GROUP:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = LeaveGroup( pd );
		break;
	      } 
	    case QUERY_KERNEL:
	      {
		FORWARD_NONLOCAL_REQ2();
		replycode = QueryKernel( pd );
		break;
	      }
	    case GET_FORWARDER:
	      {
	        if ( (upd = FindSender( pd, req->pid )) != NULL)
		  {
		    req->pid = upd->forwarder;
		    replycode = OK;
		  }
		else
		  {
		    req->pid = 0;
		    replycode = NOT_FOUND;
		  }
		break;
	      }
	    case GET_USER_NUMBER:
	      {
	        if( MAP_TO_RPD(upd,req->pid) || MAP_TO_APD(upd,req->pid) )
		  {
		    req->length = upd->userNumber;
		    replycode = OK;
		    break;
		  }
		FORWARD_NONLOCAL_REQ();

		replycode = NONEXISTENT_PROCESS;
		break;
	      }
	    case SET_USER_NUMBER:
	      {
		FORWARD_NONLOCAL_REQ();

		/* Check permission of requestor for this operation. */
		if ( !MAP_TO_RPD( upd, req->pid ))
		  {
		    replycode = NONEXISTENT_PROCESS;
		    break;
		  }

		if( ( pd->team == FirstTeam ) ||
		    ( pd->userNumber == SUPER_USER ) ||
		    AuthenticationServer( pd ) ||
		    ( ( ( pd->team == upd->team ) || ( upd->father == pd ) ) &&
		      ( req->length == pd->userNumber ) ) ||
		    ( ( req->pid == pd->pid ) &&
		      ( req->length == UNKNOWN_USER ) ) ||
		    ( pd->pdFlags & KING_OF_SPAIN ) )
		  {
		    upd->userNumber = req->length;/* Used to hold userNumber */
		    replycode = OK;
		  }
		else
		    replycode = NO_PERMISSION;
		break;
	      }
	    case FORCE_EXCEPTION:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = ForceException( pd );
		break;
	      }
	    case FORCE_SEND:
	      {
		FORWARD_NONLOCAL_REQ();
		if( KernelServerRecSize < sizeof(Message) )
		  {
		    replycode = RETRY;
		    break; /* Dont try to do a CopyFrom. */
		  }
	        req->segment = (char *) KernelServerBuffer;
		if (DifferentByteOrder(pd->pid))
		    ByteSwapLongInPlace(req->segment, sizeof(Message));
		replycode = ForceSend( pd, 1 );
		break;
	      }
	    case OLD_FORCE_SEND:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = ForceSend( pd, 0 );
		break;
	      }
	    case CLEAR_MODIFIED_PAGES:
	    case RETURN_MODIFIED_PAGES:
	      {
	      	active->segmentPtr = (Unspec *) KernelServerBuffer;
		active->segmentSize = min( 1024, req->length );
	      	active->remoteSegmentPtr = (Unspec *)req->segment;
		replycode = ClearModifiedPages( req, KernelServerBuffer, 
							active->segmentSize );
		break;
	      }
	    case QUERY_PROCESSOR_USAGE:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = QueryProcessorUsage( pd );
		break;
	      }
	    case SET_DEBUG_MODE:
	      {
		replycode = DebugOperation(pd);
		break;
	      }
	    case REBOOT:
	      {
		FORWARD_NONLOCAL_REQ();
		replycode = InitReboot( pd );
		break;
	      }
	    case KMEM:
	      {
		/* This whole thing is an embarrasing kludge. I'm ashamed
		 * of myself for installing it. - Lance
		 */
		FORWARD_NONLOCAL_REQ();
		if (req->unspecified[0] == 0)
		  {
		    active->segmentPtr = (Unspec *) req->unspecified[1];
		    active->segmentSize = MAX_APPENDED_SEGMENT;
		    active->remoteSegmentPtr = (Unspec *) req->segment;
		    replycode = OK;
		  }
		else if (req->unspecified[0] == 1)
		  {
		    req->unspecified[2] = (unsigned) TeamDescriptors;
		    active->segmentPtr = (Unspec *) 
				(TeamDescriptors + req->unspecified[1]);
		    active->segmentSize = req->length;
		    active->remoteSegmentPtr = (Unspec *) req->segment;
		    replycode = OK;
		  }
		else if (req->unspecified[0] == 2)
		  {
		    req->unspecified[2] = (unsigned) ProcessDescriptors;
		    active->segmentPtr = (Unspec *)
				(ProcessDescriptors + req->unspecified[1]);
		    active->segmentSize = req->length;
		    active->remoteSegmentPtr = (Unspec *) req->segment;
		    replycode = OK;
		  }
		else if (req->unspecified[0] == 3)
		  {
		    req->unspecified[2] = (unsigned) Pd_bundle;
		    req->unspecified[3] = (unsigned) IdleProcessPtr;
		    active->segmentPtr = (Unspec *) Pd_bundle;
		    active->segmentSize = req->length;
		    active->remoteSegmentPtr = (Unspec *) req->segment;
		    replycode = OK;
		  }
		break;
	      }
	    case PROFILE:
	      {
#define preq ((ProfileRequest *) req)
		FORWARD_NONLOCAL_REQ();

		if ( ( replycode = HandleProfile( pd ) ) == OK )
		  {
		    active->segmentPtr = preq->tablePtr;
		    active->segmentSize = preq->segmentSize;
		    active->remoteSegmentPtr = preq->segmentPtr;
		  }
		break;
#undef preq
	      }
#ifdef VM
	    case SET_ACCESS:
	      {
		FORWARD_NONLOCAL_REQ();
	        replycode = SetAccess(pd);
		break;
	      }
	    case QUERY_PAGE:
	      {
		FORWARD_NONLOCAL_REQ();
	        replycode = QueryPage(pd);
		break;
	      }
	    case BIND_REGION:
	      {
		FORWARD_NONLOCAL_REQ();
	        replycode = BindRegion(pd);
		break;
	      }
	    case UNBIND_REGION:
	      {
		FORWARD_NONLOCAL_REQ();
	        replycode = UnbindRegion(pd);
		break;
	      }
	    case PREPAGE:
	      {
		FORWARD_NONLOCAL_REQ();
	        replycode = Prepage(pd);
		break;
	      }
#endif VM
badArgs:
	    default: replycode = BAD_ARGS;
	  }
	/* Check if requesting process has been forwarded elsewhere. */
	if( replycode == NO_REPLY ) continue;
	req->opcode = replycode;

	/* Set up the kernel server pd so that KReply will work. */
	if (active->segmentSize) req->opcode |= REPLY_SEGMENT_BIT;
	active->blocked_on = pd->pid;
	Copy_msg( &active->msg, &pd->msg );
	
	Lockq( &(active->msgq) );
	pd->state = AWAITING_REPLY;
	if( (pd->link = active->msgq.head) == NULL )
		active->msgq.tail = pd;
	active->msgq.head = pd;
	pd->queuePtr = &(active->msgq);
	Unlockq( &(active->msgq) );
	KReply( active );

	if( active->queuePtr )
	  {
	    disable;
	    if( active->queuePtr == &Readyq ) RemoveQueue( active );
	    else
	      {
		active->finish_up = (Unspec (*)()) KernelServer;
		return; /* Wait to get off queue.*/
	      }
	    enable;
	  }
	KernelServerRecSize = 0;
      }
  }
