/*
 * Distributed V Kernel - Copyright (c) 1985 by Stanford University.
 *
 * Internal header file for inter process communication.
 *
 */

    /* Algorithm used to queue a new message:
     *
     *  If there is no next sender than the message automatically
     *   gets put on the end of the message queue.
     *  Otherwise we have to insert the new message at or after
     *   the next_sender while keeping the queue in priority order.
     *  After inserting the message we check to see if it is
     *   a new next_sender or a new tail.
     *  This algorithm assumes that if the queue is empty the tail
     *   points to the address of the head and that the next_sender
     *   and head are NULL when the queue is empty.
     */
#define EnqueueMsg( msgpd, recpd, tmppd )			\
  {							\
    Lockq( &(recpd->msgq) );				\
    if (recpd->next_sender == NULL)			\
        tmppd = recpd->msgq.tail;			\
    else						\
      {							\
        tmppd = (Process *) &(recpd->msgq.head);	\
        while (tmppd->link != recpd->next_sender) tmppd = tmppd->link; \
        while ((tmppd->link!=NULL) && (tmppd->link->priority <= msgpd->priority))\
            tmppd = tmppd->link;				\
      }							\
    msgpd->link = tmppd->link;				\
    tmppd->link = msgpd;					\
    if (msgpd->link == recpd->next_sender) recpd->next_sender = msgpd; \
    if (msgpd->link == NULL) recpd->msgq.tail = msgpd;	\
    msgpd->queuePtr = &(recpd->msgq);			\
    Unlockq( &(recpd->msgq) );			\
  }


#define EnqueueMsgAtFront(msgpd, receiver)		\
  {							\
    Lockq( &(receiver->msgq) );				\
    if( (msgpd->link=receiver->msgq.head) == NULL ) 	\
	receiver->msgq.tail = msgpd;			\
    receiver->msgq.head = msgpd;			\
    msgpd->queuePtr = &(receiver->msgq);		\
    Unlockq( &(receiver->msgq) );			\
  }
