/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Kernel Initialization Routines - machine-independent
 *
 */

#include "process.h"
#include "dm.h"
#include "naming.h"
#include "Vquerykernel.h"

Process Idle_process; /* Process descriptor for idle pseudo-process */
Process *IdleProcessPtr;
Team * FirstTeam;	/* Point to descriptor for first team. */

extern Process_id Kernel_Process_Pid;

short KernelInterrupted;  /* A non-zero value indicates that an
			     interrupt routine interrupted a
			     kernel operation */
short ProcessInterrupted; /* A non-zero value indicates that an
			     interrupt routine interrupted a
			     process; one of these values is always
			     set while interrupt routines are running */

extern SyncQueue Readyq, IkpOutq;
extern Process *Active;
extern ProcessId Device_Server_Pid;
extern Team *TdFreeList;
extern char version[];
extern LhnRec *FindLhn();
extern int SetLhnFlag;

Init_memory()
  {
    disable;
    K_puts(version);
    K_puts("Kernel initializing...\r\n");

    Init_memory_mapping();
  }

Init_kernel()

  /* First entry point for kernel initialization.
   *
   */
  {
    register Process *pd;

    /* Allocate memory for process descriptors */
    AllocatePds();

    /* Initialize logical host descriptors. */
    InitLhn();

    /* Initialize process and team descriptors */
    InitPDsandTDs();

    /* Initialize the structures for group ipc. */
    InitGroupIpc();

    /* Initialize cache of logical-physical address mappings. */
    HostCacheInit();

    /* Initialize the basic device handling server. */
    InitDeviceServer();

    /* Initialize the Readyq and idle process */
    Readyq.head = NULL;
    Readyq.type = READY_QUEUE;

    pd = &Idle_process;
    Active = pd;
    pd->link = NULL;
    pd->pid = 0; 
    pd->localPid = INVALID_PROCESS;
    pd->extendPd = NULL;
    pd->nextPd = NULL;
    pd->father = NULL;
    pd->brother = NULL;
    pd->son = NULL;
    pd->state = READY;
    pd->priority = NULL_PROCESS_PRIORITY; /* Lowest priority*/
    pd->decayRate = 0;
    pd->team = TdFreeList;	/* Put on first team, when created */

    /* Initialize Qs */
    InitTimeWFProcessor();

#ifndef VAX
    /* Put pointers in place for use by postmortem debugger */
    P_Pd_bundle = &(Pd_bundle[0]);
    P_Active = &Active;
    P_Readyq_head = &(Readyq.head);
    P_IdleProcess = &Idle_process;
    P_IkpOutq = &(IkpOutq.head);
#endif VAX

    Powerup();

    Init_root_team();

    Idle();		/* Now function as the idle process */
  }


InitFinishUpFcn( active )
    register Process *active;
  {
    /*
     * Finish up fcn. called after the first logical host number has been
     * obtained.  Does the normal SetLogicalHostNumber functions (with mods
     * to take into account the fact that only one pd is being used for
     * both lhn creator and createe) and also various initialization 
     * functions which can't be done until a valid lhn is known.
     */
    unsigned logicalHostNumber;
    register KernelRequest *msg;

    msg = (KernelRequest *) &(active->msg);
    logicalHostNumber = (unsigned) msg->pid;
    if (msg->opcode != KERNEL_TIMEOUT)
      {
printx("Logical host collision [ %x ]\n", logicalHostNumber);
	DeallocateLhn(FindLhn(logicalHostNumber));
	NewLhn(active);
	return( NO_REPLY );
      }

    /* We use the V_BOOT_LHN when checking for logical host collision.
     * Now that we have a valid LHN, fix up the pid fields in the first
     * process descriptor. Its local part was set by CreateProcess().
     */
    active->pid =logicalHostNumber|PidLocalPart(active->pid);
printx("Setting root lhn and pid: %x   %x\n", logicalHostNumber, active->pid);
    Device_Server_Pid = logicalHostNumber | LOCAL_DEVICE_SERVER_PID;
    active->localPid = active->pid;
    active->team->team_root = active->pid;
    active->team->lhn = (LhnRec *) FindLhn(logicalHostNumber);
    active->team->lhn->pidGen = 1;
				/* We start the system l.host off at 1.
				   Other l.hosts will start higher to avoid 
				   running into the permanent system 
				   processes of the O.S. */

    if (SetLhnFlag)
      {
        SetLhnSet(logicalHostNumber);
      }

    InitKernelServer( active );

    CreateStdIo( active );	/* Create standard i/o now that a valid 
				   lhn is known. */

    K_puts("  ...kernel initialization done\r\n");
    Addready( active );
    return(active->pid);	/* Return the pid of the root
				   process of the newly created logical host.
				   */
  }
