#include "Venviron.h"
#include "Vethernet.h"
#include "Vikc.h"
#include "Vquerykernel.h"
#include "dm.h"
#include "memory.h"
#include "process.h"

#ifdef ENET3MEG
#define ENET_MAX_PACKET ENET3_MAX_PACKET
#define EnetHeader Enet3Header
NetAddress	MulticastDefault = 0;
#else
#define ENET_MAX_PACKET ENET10_MAX_PACKET
#define EnetHeader Enet10Header
NetAddress	MulticastDefault = V_MULTICAST_ADDRESS;
#endif

typedef struct { char *ptr; unsigned long bytes; } BufferList;

/* Imports */
extern SystemCode NotSupported();
extern DeviceInstance *GetDevice();
extern unsigned char *LastPeripheral;
extern InitializeAlien();
extern Process *AllocatePd();
extern SystemCode AllocateMemory();
extern MachineConfigurationReply MachineConfig;

/* Imported from device driver */
extern SystemCode EnetModify();
extern SystemCode EnetQuery();
extern SystemCode EnetModify();
extern SystemCode EnetQuery();
extern SystemCode EnetPowerup();
extern		NetworkWrite();
/* Exports */
extern SystemCode EnetCreate();
extern SystemCode EnetRead();
extern SystemCode EnetWrite();
extern SystemCode EnetRelease();
extern SystemCode EnetCheckRequest();

/* User packet handling: if the ethernet has been opened but there isn't
 * an outstanding read request the packet gets stored in the UserPacketBuffer.
 * If another UserPacket arrives before a read request the buffer gets
 * overwritten. This is meant to provide a bit of slop for user programs that
 * use the raw device and isn't meant as a highly reliable mechanism. (It seems
 * to work well with the current crop of applications).
 */
char UserPacketBuffer[ENET_MAX_DATA];
int UserPacketLength = 0;

DeviceInstance	*EthernetInstance = NULL;
ProcessId	EnetWriter;	/* Non-zero if a writer using Ethernet */
SyncQueue	IkpOutq;	/* Queue of outgoing packets */

SystemCode EnetCreate( pd, inst )
    Process *pd;
    register DeviceInstance *inst;
  /* Create an instance for the Ethernet interface.
   */
 {
    register CreateInstanceRequest *req = (CreateInstanceRequest *) &pd->msg;
    if( req->filemode != FCREATE ) return( MODE_NOT_SUPPORTED );

    if( EthernetInstance != NULL && 
        MapPid( EthernetInstance->owner) )
      {
	return( BUSY );
      }

    /*
     * Initialize the device instance, can assume all fields
     * are zero except for owner and id.
     */

    inst->readfunc = EnetRead;
    inst->writefunc = EnetWrite;
    inst->modifyfunc = EnetModify;
    inst->queryfunc = EnetQuery;
    inst->releasefunc = EnetRelease;
    inst->reader = 0;
    inst->writer = 0;

    EthernetInstance = inst; /* Record the instance for interrupt routine */

    inst->type = (READABLE+WRITEABLE+VARIABLE_BLOCK+STREAM);
    inst->blocksize = ENET_MAX_PACKET;

    return( OK );
  }

SystemCode EnetRelease( pd, inst )
    Process *pd;
    DeviceInstance *inst;
   /*
    * Release the ethernet instance.
    */
  {
    IoRequest *req = (IoRequest *) &(pd->msg);

    inst->owner = 0; /* Free the instance */
    /* It is assumed that the reader will unblock on next packet
     * if currently blocked.
     */
    return( OK );
  }


SystemCode EnetRead( pd, inst ) 
    register Process *pd;
    register DeviceInstance *inst;
 /*
  * Handle a read instance request for the Ethernet interface.
  */
  {
    IoRequest *req = (IoRequest *) &(pd->msg);
    SystemCode	r;
    register short *p;

    /*
     * Reply for RETRY if already a waiting reader process.
     * This effectively provides busy-wait queuing for reading.
     */
    if( MapPid(inst->reader) ) return( RETRY );

    if( (r=EnetCheckRequest(pd, req)) != OK ) return( r );

    /* Give the process the packet in the user buffer. If the buffer
     * is empty have the process wait.
     */
    if (UserPacketLength != 0)
      {
	/* First, fill in the bytecount in the reply */
	req = (IoRequest *) &(pd->msg);
    	if ( UserPacketLength < req->bytecount )
	  req->bytecount = UserPacketLength;
    	/* Now decide where to put the data */
    	if( req->bytecount <= IO_MSG_BUFFER ) 
	  p = (short *) req->shortbuffer;
    	else
	  p = (short *) req->bufferptr;

	Copy(p, UserPacketBuffer, req->bytecount);
	UserPacketLength = 0; /* Buffer is now empty */
	return( OK );
      }
    else
      {
	inst->reader = pd->pid;
	pd->state = AWAITING_INT;
	return( NO_REPLY );
      }
  }

SystemCode EnetWrite( pd, inst )
    register Process *pd;
    register DeviceInstance *inst;

   /* Handle a write instance request to the Ethernet interface.
    */
  {
    register IoRequest *req = (IoRequest *) &(pd->msg);
    SystemCode r;
    BufferList bufferlist[2];
    extern ProcessId EnetWriter;

    if( (r = EnetCheckRequest(pd, req)) != OK ) return( r );

    /*
     * Reply for RETRY if currently writing.
     * This effectively provides busy-wait queuing for writing.
     */

/*
 * Should use test-and-set of EnetWriter, since interrupt routines use it
 */
    if( EnetWriter ) return( RETRY );

    if ( pd->pid )
      {
	EnetWriter = pd->pid;
      }
    else
      {
	EnetWriter = 1;
#ifdef VERBOSE
	printx("EnetWrite: pd->pid == 0 !? (pd = 0x%x)\n", pd);
#endif VERBOSE
      }

    bufferlist[0].bytes = req->bytecount;
    bufferlist[0].ptr = req->bufferptr;
    bufferlist[1].ptr = NULL;
    
    NetworkWrite(bufferlist);

    return( OK );
  }

SystemCode EnetCheckRequest( pd, req ) 
    register Process *pd;
    register IoRequest *req;

  /* Check that the read or write request has a legitimate buffer, etc.
   */
  {
    register unsigned count;
    register SystemCode r;

    /*  Check length */
    count = req->bytecount;

    req->bytecount = 0; /* To be left zero if a check fails */
    if( count > ENET_MAX_PACKET || (count <= IO_MSG_BUFFER) )
	r = BAD_BYTE_COUNT;
    else  /* Make sure data pointer is valid.
	   *  Check that on a word boundary (WHY? --TPM)
	   *  and not in the kernel area.
	   */
    if( (BadUserPtr(req->bufferptr)) ||
        ( (unsigned)pd->team->team_space.size <
	  (unsigned)(req->bufferptr + count) ) ||
	( (int) req->bufferptr) & 1 )
	r = BAD_BUFFER;
    else
      {
	req->bytecount = count;
	r = OK;
      }
    return( r );
  }


WriteKPacket( pd )
    register Process *pd;

   /*
    * This routine has to be called with all network fields filled in.
    * A corresponding packet will be written out, with a segment
    * appended starting at currentSegmentPtr and length.
    * On return currentSegmentPtr is incremented by length.
    * Routing rule: as a WF processor, this routes the pd to
    * the delay queue if the pd->state != READY, else adds
    * it into the ready queue.
    */
  {
    extern Process_id EnetWriter;
    SystemCode error;

    pd->currentSegmentPtr = pd->segmentPtr;

#ifdef VM
    /* Be sure requested segment is in physical memory before starting */
    /* %%% not quite right -- must lock exactly once so have to resume
     *  BELOW this code after unblocking */
    error = LockSegment(pd, pd->segmentPtr, pd->segmentSize, PA_IKCOUT);
    if (error == NO_REPLY) return;	/* will come back later */
    if (error != OK)
      {
	/* This should be an exception, probably */
	printx("WriteKPacket: LockSegment failed, pd %x, error %x\n");
	return;	/* process hangs */
      }
#endif VM

    /* Check if device is busy. */
    if( EnetWriter == 0 )
      {
	EnetWriter = 1;		/* Test and set required here */
	WriteNextKPacket( pd );
      }
    else	
      {
   	/* Queue pd for later transmission. */
	switch (pd->packetType)
	  {
	  case breathOfLife:
	  case remoteMoveToReply:
	    /* Add to head of queue */
	    Lockq( &IkpOutq );
	    pd->queuePtr = &IkpOutq;
	    pd->link = IkpOutq.head;
	    if (IkpOutq.head == NULL) IkpOutq.tail = pd;
	    IkpOutq.head = pd;
	    Unlockq( &IkpOutq );
	    break;

	  default:
	    /* Add to end of queue */
	    pd->link = NULL;
	    Lockq( &IkpOutq );
	    pd->queuePtr = &IkpOutq;
	    IkpOutq.tail = (IkpOutq.tail->link = pd);
	    Unlockq( &IkpOutq );
	    break;
	  }
      }
  }

#define SwapPids(pd)				\
  {						\
    register Process_id tmp;			\
    tmp = pd->pid;				\
    pd->pid = pd->blocked_on;			\
    pd->blocked_on =tmp;			\
  }

WriteNextKPacket( pd )
register Process *pd;
  {
    BufferList bufferlist[4];
    register BufferList *bufferptr;
    EnetHeader enet;
    extern NetAddress HostCacheLookup();
    register unsigned bytes;
    register int more_to_come;	/* Set to 1 if this packet should stay  */
				/*   on IkpOutq, i.e. its segment can't */
				/*   be sent in one Ethernet packet     */
    register Team *oldteam;

    /* Management of the current AddressableTeam is a bit hairy.  We save */
    /*   its value here, arbitrarily fool with it below, and then must    */
    /*   ensure that we restore it before any return.                     */

    oldteam = GetAddressableTeam();

find_valid_KPacket:
	/*
	 * Some of the things we do below could be moved before or after the
	 *   goto-loop.  However, we only go around the loop when things go
	 *   fairly wrong, so we tolerate the inefficiency in the interests of
	 *   clarity and - who knows - even correctness.
	 */
    bufferptr = bufferlist;

    bufferptr->bytes = sizeof(enet);	/* We fill in enet below - except */
    bufferptr->ptr   = (char *)&enet;	/*   SrcHost, which is always set */
    bufferptr++;			/*   in NetworkWrite().		  */

    bufferptr->bytes = sizeof(kPacket);
    bufferptr->ptr   = (char *)&(pd->packetType);
    bufferptr++;
    
    more_to_come = 0;

    if( (pd->packetType == remoteMoveFromReq) ||
	(pd->packetType == remoteMoveToReply) )
	;	/* That's right, do nothing.  In this case pd->length has */
		/*   been set to a non-zero value to indicate desire for, */
		/*   or acknowledgement of, a segment.			  */
    else if( pd->segmentSize == 0 )
	pd->length = 0;
    else /* there really is a segment associated with this packet */
      {
	bytes = (unsigned)pd->segmentPtr + pd->segmentSize -
	    		(unsigned)pd->currentSegmentPtr;
	if( bytes > MAX_APPENDED_SEGMENT )
	  {
	    bytes = MAX_APPENDED_SEGMENT;
	    more_to_come = 1;
	  }
	SetAddressableTeam(pd->team);
/*
 * The team may have vanished while this pd was languishing on IkpOutq.
 *   This is most likely to happen with group ipc and a short-lived team
 *   ("listdir [team/whatever-my-name-is" used to tickle this problem,
 *   because my own teamserver would respond almost instantly, listdir would
 *   finish, and there would still be queued MoveFromReplies for the other
 *   umpteen team servers).
 * We check whether we can still read the segment.
 *
 * ---NOTE--- that this isn't a correct solution:  It's possible that the
 * team has been destroyed and the team descriptor is now used by a different
 * team which also maps the segment.  In that case, the segment data we send
 * will be completely bogus.
 */
	if( !KernelCanRead(pd->currentSegmentPtr, bytes) )
	  {
#ifdef DEBUG
	    printx("WNKP: Teamspace disappeared pid: %x\n", pd->pid);
#endif DEBUG
	    if (AlienProcess(pd)) 
		DestroyAlien( pd );
	    else
	      {
		printx(
	    "Offending pid is %x, pd->currentSegmentPtr = %x, length = %x\n",
			pd->pid, pd->currentSegmentPtr, bytes);
		Kabort(
	      "WriteNextKPacket: Expected an alien, got some other process");
	      }
	    /* If IkpOutq is non-empty, transmit next interkernel packet. */
	    Lockq( &IkpOutq );
	    if( (pd=IkpOutq.head) != NULL )
	      {
		if( (IkpOutq.head = pd->link) == NULL )
		    IkpOutq.tail = (Process *) &(IkpOutq.head);
		pd->queuePtr = NULL;
		Unlockq( &IkpOutq );
	      }
	    else
	      {
		EnetWriter = 0; /* No transmission in progress now */
/*
 * ^ Synchronization problem?  Is it possible that, while we are doing a
 *     WriteNextKPacket NOT in interrupt mode, we get an (ethernet) interrupt
 *     which pulls the last packet out of IkpOutq, and is currently
 *     transmitting it; then it returns to us, and we mistakenly clear this?
 */
		Unlockq( &IkpOutq );
		SetAddressableTeam(oldteam);
		return;
	      }
	    goto find_valid_KPacket;	/* I defy you to implement this  */
	  }				/*   more cleanly without a goto.*/

	pd->length = bytes;
	pd->remoteaddress = (Unspec *)
		    ( (unsigned)pd->remoteSegmentPtr
		      + ( (unsigned)pd->currentSegmentPtr
			  - (unsigned)pd->segmentPtr ) );
	if( bytes != 0 )
	    /* Don't want to put a zero length byte count in the buffer list*/
	    /*   in case NetworkWrite does the wrong thing.  Is it really   */
	    /*   possible to have bytes == 0?				    */
	  {
	    /* Does this prevent hassles on 68000/68010 processors? */
	    /*                       VVVVVV			    */
	    bufferptr->bytes = (bytes+1)&~1;
	    bufferptr->ptr =  (char *) pd->currentSegmentPtr;
	    bufferptr++;

	    /* If we're sending a remoteMoveFromReq or remoteMoveToReply, */
	    /*   we DON'T play with currentSegmentPtr.  Hope that's right.*/
	    pd->currentSegmentPtr = (Unspec *) 
			((unsigned)pd->currentSegmentPtr + bytes);
	  }
      }

    enet.EtherType = KERNEL_PACKET;

    if( AlienProcess(pd) ) SwapPids(pd);
    if( (pd->blocked_on&GROUP_ID_BIT) )
      {
	if( (pd->blocked_on&LOCAL_GROUP_BIT) )
	  {
	    ProcessId id;
	    /* Turn off group bit so cache lookup might work. */
	    id = pd->blocked_on & ~GROUP_ID_BIT;
	    enet.DestHost = HostCacheLookup(id >> 16);
	  }
	else /* Use a multicast address. */
	  {
	    enet.DestHost = MulticastDefault;
	    /* Now plug in the logical host group identifier from groupId. */
#ifdef ENET10MEG
	    enet.DestHost.addrlow = (pd->blocked_on>>17);
#endif
	  }
      }
    else
      {
	 enet.DestHost = HostCacheLookup(pd->blocked_on >> 16);
      }

#ifdef LITTLE_ENDIAN
    pd->packetType |= IKC_LITTLE_ENDIAN;
#else
    pd->packetType &= ~IKC_LITTLE_ENDIAN;
#endif
    
    bufferptr->ptr = NULL;
    
    NetworkWrite(bufferlist);

    SetAddressableTeam(oldteam);
    if( AlienProcess(pd) ) SwapPids(pd);

    /* Check if we have finished transmission for this pd. */
    if( more_to_come )
      {
	/* No: requeue on Ikp queue - at the end.*/
	pd->link = NULL;
	Lockq( &IkpOutq );
	pd->queuePtr = &IkpOutq;
	IkpOutq.tail = (IkpOutq.tail->link = pd);
	Unlockq( &IkpOutq );
      }
    else
      {
	/* Finished with this process; route to next queue. */
	if( pd->state == READY ) 
	    Addready( pd );
	else
	    DelayProcess( pd );
      }
  }

int ReadDataPacket( copier, kp )
register Process *copier;
    register kPacketWithSegment *kp;
  /* Copy kp->length bytes from segment portion of packet
   * associated with kp (kernel packet) into address space of copier,
   * starting at kp->remoteaddress.
   */
  {
    Team *oldteam;

    oldteam = GetAddressableTeam();
    SetAddressableTeam(copier->team);
    /* Copy starting right AFTER the msg array. */
    Copy( kp->remoteaddress, kp->data, kp->length );
    SetAddressableTeam(oldteam);
    return( OK );
  }

