/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Kernel device management: header file.
 */

#ifndef DM
#define DM

#include "Vioprotocol.h"
#include "config.h"

typedef struct
  {
    InstanceId		id;		/* File or device instance id */
    unsigned short	dirIndex;	/* Index into device directory */
    unsigned short	unit;		/* Device-dependent value */
    unsigned short	type;		/* I/O protocol type bits */
    unsigned short	lastbytes;
    ProcessId		owner;		/* Owner process */
    unsigned		blocksize;	/* Max. block size */
    unsigned		lastblock;
    unsigned		nextblock;
    SystemCode		(*readfunc)();	/* Device-dependent functions */
    SystemCode		(*writefunc)();
    SystemCode		(*modifyfunc)();
    SystemCode		(*queryfunc)();
    SystemCode		(*releasefunc)();
    ProcessId		reader;
    ProcessId		writer;
    char		*devicedesc;	/* Device-specific additional info */
  } DeviceInstance;

#endif
