/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 *
 * Header file describing Sun-1/1.5 memory mapping
 */

#ifndef MEMORY
#define MEMORY

#define VECTOR_BASE	0
#define PAGESIZE	2048
#define PAGE_SIZE	PAGESIZE
#define SEGSIZ		0x8000
#define PGPERSEG	(SEGSIZ/PAGESIZE)
#define PHYSSEGS	64

#ifdef SUN1
#define KERNEL_START	0x1000     /* Kernel is loaded at this address */
#else /* Sun-1.5 */
#define KERNEL_START	0x2000     /* Kernel is loaded at this address */
#endif


#define TEAM_START	(4*SEGSIZ) /* Team starting address */
#define TEAM_LIMIT	0x180000   /* Team size limit */
#define STACK		0x180000   /* Stack segment */
#define TEAM_SEG	0x1A0000   /* Space for team descriptor array */
#define PD_SEG		0x1B0000   /* Space for process descriptor array */
#define MBMEM		0x100000   /* Sun Monitor maps Multibus memory here */
#define MBHACK_END	0x180000   /* Kernel can always use mbmem above this */
#define MBIO		0x1F0000   /* Sun Monitor maps Multibus I/O here */
#define CONTEXT_SIZE	0x200000   /* End of mappable address space */
#define ADDR_LIMIT	0x1000000  /* Limit of 24-bit MC68000 address space */
#define XFERSEG		0x1C0000   /* Segment used for interteam copies */
#define KERNMB		0x1E8000   /* Used for kernel access to Multibus */

#define TESTPAGE 	XFERSEG    /* Used during memory size test */

#define MAX_ONBOARD_PAGES (1<<12)  /* 12-bit field */
#define MAX_MULTIBUS_PAGES (TEAM_LIMIT/PAGESIZE)
				   /* Assume no MB memory past standard
					framebuffer location */

/* More (Sun-2 style) names for things */
#define P_MBMEM_WINDOW		0x00000
#define P_MBMEM_LIMIT		0xF0000
#define V_MBMEM_WINDOW		MBMEM
#define V_MBMEM_LIMIT		MBIO
#define MBMEM_OFFSET		(V_MBMEM_WINDOW-P_MBMEM_WINDOW)
#define P_MBIO_WINDOW		0x0000
#define P_MBIO_LIMIT		0x10000
#define V_MBIO_WINDOW		MBIO
#define V_MBIO_LIMIT		CONTEXT_SIZE
#define V_SUN1_FRAMEBUFFER 	0x1C0000   /* Look for frame buffer here */
#define V_TIMER_CHIP		0x800000
#define V_PARALLEL_PORT		0xE00000


/* Page map entries */
#define PAGETYPE	(3<<12)	   /* Mask to get page type field */
#define ONBOARD		(0<<12)	   /* "Onboard" physical address space */
#define NONEXIS		(1<<12)    /* Nonexistent */
#define MULTMEM		(2<<12)    /* Multibus memory address space */
#define MULTIO		(3<<12)    /* Multibus I/O address space */
#define NOPAGE		NONEXIS

typedef short unsigned PageMapEntry;
typedef short unsigned SegMapEntry;

typedef union
  {
    PageMapEntry nextpage;
    char byte[PAGESIZE];
    short word[PAGESIZE/2];
    long longword[PAGESIZE/4];
  } Page;

typedef union
  {
    char byte[SEGSIZ];
    short word[SEGSIZ/2];
    long longword[SEGSIZ/4];
  } Segment;

#define NUMCTXS 16
#define NUMSEGS 64

/* Segment map */
#define SEGMAP	 0x0FFF		/* Mask off context register */
#define PERMMASK 0x0F00		/* See only permission field */
#define PermissionField(x) ( (x&PERMMASK)>>8 )

/* Permission types */
#define ______ (0<<8)
#define __X___ (1<<8)
#define R_____ (2<<8)
#define R_X___ (3<<8)
#define RW____ (4<<8)
#define RWX___ (5<<8)
#define R__R__ (6<<8)
#define RW_R__ (7<<8)
#define R__RW_ (8<<8)
#define RW_RW_ (9<<8)
#define RW_R_X (10<<8)
#define RW_RWX (11<<8)
#define R_XR_X (12<<8)
#define RWXR_X (13<<8)
#define RWX__X (14<<8)
#define RWXRWX (15<<8)
#define UNUSED ______

/* Bits in permission translation table */
#define SR 040
#define SW 020
#define SX 010
#define UR 004
#define UW 002
#define UX 001

/* Sun-2 style context register definition */
typedef union
  {
    /* Fields */
    struct
      {
        unsigned short context:4;	/* Context number */
        unsigned short	      :12;	/* Filler */
      }
    f;
    unsigned short u;	/* Whole thing as an unsigned quantity */
  }
ContextRegister;

/* Read the context register into the ContextRegister cxt points to */
#define GetContextReg(cxt) (cxt)->u = *(unsigned short *)0xC00000
/* Write the context register with a ContextRegister type */
#define SetContextReg(cxt) *((unsigned short *) 0xE00000) = (cxt).u
/* Write the context register with a short */
#define SetContextNum(cxt) *((unsigned short *) 0xE00000) = (cxt)
/* Get the addressable team */
#define	GetAddressableTeam() AddressableTeam
extern	struct _TD *AddressableTeam;


/* Get the current context */
#define getcontext() (*((short *) 0xC00000) >> 12)
/* Set the current context */
#define setcontext(cxt) *((short *) 0xE00000) = (cxt) << 12
/* Access the segment map entry for a given page */
#define segmap(pgaddr) \
  *((PageMapEntry *) (0xC00000 + ((long unsigned) pgaddr&~1)))
/* Access the page map entry for a given page */
#define pgmap(pgaddr)  \
  *((PageMapEntry *) (0xA00000 + ((long unsigned) pgaddr&~1)))

/* Round an address up to the next page boundary */
#define uptopage(addr)\
 ((Page *) (((((long unsigned) (addr)) - 1) & (~(PAGESIZE-1))) + PAGESIZE))
/* Round an address up to the next segment boundary */
#define uptoseg(addr)\
 ((Page *) (((((long unsigned) (addr)) - 1) & (~(SEGSIZ-1))) + SEGSIZ))

/* Modes for Probe() function -- see memory.c */
#define PROBE_READ 1
#define PROBE_INIT 2
#define PROBE_PRESERVE 3

#endif
