/*
 * Distributed V Kernel
 * Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Machine descriptive Header File for Motorola 68000
 */

/* See also Venviron.h */

#ifndef MACHINE
#define MACHINE

#include "memory.h"
#include <Vexceptions.h>

/* Processor state as maintained inside kernel */
typedef struct
  {
    /* Machine independent fields */
    Unspec *perProcess;	 	/* Pointer to per process area */
    Unspec **perProcessLoc;	/* perProcess pointer stored at
				 * this address on a process switch */

    /* Machine dependent fields */
    short unused;		/* Formerly context of associated team */
    Unspec regs[16];		/* 8 data + 8 address registers */
    				/* Supervisory stack ptr not stored */

#ifdef MC68020
    MC68020ExceptionStackFrame frame;
#else
#ifdef MC68010			/* State saved at last exception */
    MC68010ExceptionStackFrame frame;
#else
    unsigned short sr;		/* Same offset as frame.sr for 68010 */
    unsigned long pc;		/* Same offset as frame.pc for 68010 */
#endif MC68010
#endif MC68020

  } KProcessor_state;


typedef struct
  {
    ContextRegister context;	/* SUN processor context number */
#ifdef SUN3
    unsigned char unused[3];	/* Keep things on longword boundries for speed*/
#endif
    char *size;			/* Nominal size (actual size is this, rounded
				   up to a page boundary) */
#ifdef SUN3
    long timestamp;
    SegMapEntry segmap[SEGS_PER_CTX];
#else
#ifdef SUN2
    long timestamp;		/* Last time this team executed */
    SegMapEntry segmap[SEGS_PER_CTX];
				/* Save area for segment map while swapped
				 * out of hardware registers */
#endif SUN2
#endif SUN3
  } Team_space;

#ifdef SUN3
/* Disable/enable ALL interrupts */
#define DISABLE ;asm("andb #/fe, /fe0a000")	/* V_INTERRUPT_REG */
#define ENABLE  ;asm("orb  #/01, /fe0a000")
#else
/* Disable/enable ALL interrupts */
#define DISABLE \
	Fc3WriteBit16(SYSTEM_ENABLE_REGISTER, \
	              Fc3ReadBit16(SYSTEM_ENABLE_REGISTER)&0xffbf)
#define ENABLE \
	Fc3WriteBit16(SYSTEM_ENABLE_REGISTER, \
	              Fc3ReadBit16(SYSTEM_ENABLE_REGISTER)|0x0040)
#endif

#define disable ;asm("	orw	#/0700,sr")
#define enable  ;asm("	andw	#/FBFF,sr")  /* assumes we are at level 7,
						and sets to level 3 */

/* To save interrupt mask in Add_ready */
#define Interrupt_mask extern short sr; register short
#define Mask_interrupts()	sr; disable
#define Restore_interrupt_mask(mask) sr = mask

/* Locking and unlocking for SyncQueue structures. */
extern Unspec a0;

#define Lockq( q )	/* Just disables interrupts for now. */	\
	a0 = (Unspec) q; /* Get pointer is register a0 */	\
asm("	movw	sr, d0");    /* Get current interrupt level. */	\
asm("	orw	#/0700,sr"); /* Disable interrupts.*/		\
asm("	movw	d0, a0@(8)" ); /* Save interrupt level in lock */

#define Unlockq( q ) /* Reenable interrupts and clear lock. */	\
	a0 = (Unspec) q; /* Get pointer is register a0 */	\
asm("	movw	a0@(8), d0" );	/* Save status */		\
asm("	clrw	a0@(8)" );  /* Clear lock. */			\
asm("	movw	d0, sr" );  /* Reenable interrupts. */

#define Ms_pd_init(pd, i) /* Nothing to do */

#define ReturnPid( pd, value ) pd->trap_params[0] = (Unspec) value
#define ReturnSegmentSize( pd, value ) pd->trap_params[1] = (Unspec) value

#define SenderPid(pd) pd->trap_params[0] 
#define SentSegmentSize(pd) pd->trap_params[1] 

/* Message copying macro */
#define Copy_msg( dest, src ) /* Message copying macro */	\
	*((MsgStruct *) dest) = *((MsgStruct *) src)

/* User pointers must be outside kernel space and less than TEAM_LIMIT */
#define BadUserPtr(ptr) \
( ((unsigned)((unsigned)ptr - TEAM_START)) >= \
  ((unsigned)(TEAM_LIMIT    - TEAM_START)) )

/* Check whether the specified segment lies entirely within the
 *  specified process's team space */
#define SegOutsideTeamSpace(pd, ptr, len) \
( len != 0 &&  \
  ( (char *) (ptr) < (char *) TEAM_START || \
    (char *) (ptr) + (unsigned long) (len) > pd->team->team_space.size || \
    (unsigned long) (len) >= CONTEXT_SIZE ) )

/* Definitions for automatic config routines */
#define GetConfig() (*((short *) V_PARALLEL_PORT))  /* Read config register */

/* Pointers for use in debugging */
#define P_Pd_bundle	(*(Process ***) 0x800)
#define P_Active	(*(Process ***) 0x804)
#define P_Readyq_head	(*(Process ***) 0x808)
#define P_Delayq_head	(*(Process ***) 0x80C)
#define P_IdleProcess	(*(Process **)  0x810)
#define P_IkpOutq	(*(Process ***) 0x814)

#endif

