/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Interrupt service routine that calls a machine-independent
 * C routine to handle the interrupt.  The routine does four things:
 *
 *	1)  Save d0, d1, a0, and a1.  This is needed
 *	      because C functions destroy those registers.
 *	2)  Call the interrupt handler.
 *	3)  Restore the registers.
 *	4)  Cause a process switch if necessary.
 *
 * The parameter to the macro should be the name of the function to
 *  handle the interrupt.  If the function name is "func", the
 *  interrupt vector needs to be plugged with the address of the assembly
 *  language function "Asm_func".
 *
 * The location KernelInterrupted is set to a nonzero value if the
 *  interrupt occurred during a kernel operation (indicated by the
 *  supervisor bit being on and the interrupt level different from 0,
 *  the latter to exclude the idle process).  This assumes that all
 *  kernel code runs at a nonzero interrupt level, which is currently
 *  true.  If the kernel was not interrupted, we set ProcessInterrupted
 *  to allow the exception handler code to reliably detect exceptions
 *  in interrupt routines.
 */

#ifndef INTERRUPT
#define INTERRUPT

#include "process.h"
#include "asmprocess.h"

#define Call_inthandler(handler)\
   intserv(handler,end_/**/handler,Asm_/**/handler,Not_/**/handler)

#define	intserv(handler,end_handler,Asm_handler,Not_handler)\
extern SyncQueue Readyq;						\
extern Process *Active;							\
extern short KernelInterrupted, ProcessInterrupted;			\
asm("	.text");							\
asm("	.globl	Asm_handler");						\
asm("Asm_handler:");							\
asm("	moveml	#/c0c0,sp@-");		/* Save d0,d1,a0,a1 */		\
asm("	movw	sp@(16),d1");		/* Take status register */	\
asm("	andl	#/2700,d1");		/* Supervisor and int-level */	\
asm("	cmpw	#/2000,d1");		/* Interrupted the kernel ? */	\
asm("	bles	Not_handler");						\
asm("	addqw	#1,KernelInterrupted"); /* Kernel interrupted */	\
asm("	jbsr	handler");						\
asm("	subqw	#1,KernelInterrupted");					\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	rte");				/* Return */			\
asm("Not_handler:");			/* Kernel not interrupted */	\
asm("	addqw	#1,ProcessInterrupted"); /* Process interrupted */	\
asm("	jbsr	handler");						\
asm("	subqw	#1,ProcessInterrupted");				\
asm("	orw	#/0700,sr");		/* Disable interrupts */	\
asm("	tstl	Readyq");		/* Check ready queue non-empty */\
asm("	beqs	end_handler");		/* If yes, branch. */		\
asm("	movl	Active,a0");		/* Check if Active is still */	\
asm("	movl	Readyq, a1");		/* higher/equal priority than */\
asm("	movw	a1@(_PRIORITY), d0");   /* ready queue head */		\
asm("	cmpw	a0@(_PRIORITY), d0");					\
asm("	bhi	end_handler");		/* If not, switch */		\
asm("	movl	a0, sp@-" );		/* Arg to Addready */		\
asm("	jbsr	Addready");		/* Add active to readyq	*/	\
asm("	addql	#4, sp" );		/* Pop arg. */			\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	jmp	Switch");						\
asm("end_handler:");							\
asm("	moveml	sp@+,#/0303");		/* Restore registers */		\
asm("	rte");				/* Return */			\

int	Asm_handler();
#endif
