/*
 * V Kernel - Copyright (c) 1984 Stanford University.
 *
 * asm offsets for various fields in the process descriptor.
 *  Used by Message Kernel trap handler, etc.
 */

    /* PD state field values. */
    asm("_READY = 1");
    asm("_RECEIVE_BLKED = 2");
    asm("_AWAITING_REPLY = 3");

    /* Miscellany */
    asm("_CONTEXT_REG = 6" ); /* Address of context register. (Huh? --TPM) */
    asm("TEAM_START = /20000" );
    asm("SEGMENT_ACCESS = /0C000000" );
    asm("READ_ACCESS = /08000000" );
    asm("BAD_ADDRESS = /C005");
    asm("MSG_FLAG = 2");
    asm("MSG_FLAG_BIT = 1");

    /* PD field offsets.  Run m68k/pdinit.c to generate these. */
    asm("_LINK = 0");
    asm("_NEXT_PD = 4");
    asm("_FATHER = 8");
    asm("_BROTHER = 12");
    asm("_SON = 16");
    asm("_LOCALPID = 20");
    asm("_PD_FLAGS = 24");
    asm("_STATE = 25");
    asm("_PRIORITY = 26");
    asm("_TEAM = 28");
    asm("_NEXT_SENDER = 32");
    asm("_MSGQ_HEAD = 36");
    asm("_MSGQ_TAIL = 40");
    asm("_MSGQ_LOCK = 44");
    asm("_OLD_SEQ_NO = 60");
    asm("_NUM_TRANS = 62");
    asm("_DATA_SEG_PRO = 63");
    asm("_DATA_SEG_PTR = 64");
    asm("_DATA_SEG_SIZE = 68");
    asm("_DATA_EXPECTED = 72");
    asm("_REMOTE_SEGMENT_PTR = 76");
    asm("_QUEUE_PTR = 84");
    asm("_REC_BUF_SIZE_PTR = 88");
    asm("_FINISHUP = 92");
    asm("_RETURN_MSG = 96");
    asm("_SEGMENT_PTR = 100");
    asm("_SEGMENT_SIZE = 104");
    asm("_CURRENT_SEGMENT_PTR = 108");
    asm("_PACKET_TYPE = 112");
    asm("_SEQ_NO = 114");
    asm("_PID = 116");
    asm("_BLOCKED_ON = 120");
    asm("_FORWARDER = 124");
    asm("_USER_NUMBER = 128");
    asm("_LENGTH = 132");
    asm("_LOCAL_ADDRESS = 136");
    asm("_REMOTE_ADDRESS = 140");
    asm("_MSG = 144");
    asm("_END_MSG = 176");
    asm("_TRAP_PARAMS = 196");
    asm("_TIMEOUT_FUNC = 184");
    asm("_TIMEOUT_COUNT = 188");
    asm("_PROCESSOR_STATE = 212");
    asm("_D0 = 222");
    asm("_D1 = 226");
    asm("_D2 = 230");
    asm("_D3 = 234");
    asm("_D4 = 238");
    asm("_D5 = 242");
    asm("_D6 = 246");
    asm("_D7 = 250");
    asm("_A0 = 254");
    asm("_A1 = 258");
    asm("_A2 = 262");
    asm("_A3 = 266");
    asm("_A4 = 270");
    asm("_A5 = 274");
    asm("_A6 = 278");
    asm("_FP = 278");
    asm("_A7 = 282");
    asm("_USP = 282");
    asm("_FRAME = 286");
    asm("_SR = 286");
    asm("_PC = 288");
    asm("_FORMAT_OFFSET = 292");
    asm("_PER_PROCESS = 212");
    asm("_PER_PROCESS_LOC = 216");
    asm("_DECAY_RATE = 180");
    asm("_DECAY_TIME = 176");

