#include "memory.h"
#include "machine.h"

/* Initialize memory mapping, then set up the stack.
 * A memory segment is allocated in sun*mem.h;
 * The first page in the memory segment is left unallocated so that we
 * might catch kernel stack overflows.
 */
extern unsigned long a7;

unsigned long StackSize;	/* Just for debugging purposes */
unsigned long StackStart;

#define max(a,b)(((a)>(b))?(a):(b))
#define INIT_VALUE ((unsigned long)0x01234567)
_start()
  {
    register unsigned long *p, *e;

    Init_memory();
    StackSize = max(4096, PAGE_SIZE);		/* Minimum 4k stack */
    AllocateMemory(STACK+PAGE_SIZE, StackSize);
    e = (unsigned long *) (STACK+PAGE_SIZE+StackSize);
    for (p = (unsigned long *) STACK+PAGE_SIZE; p < e; *p++ = INIT_VALUE)
    /* Clear frame pointer */
    asm("movl #0,a6");	/* 'a6 = 0' generates an invalid instr. (clrl a6) */
    StackStart = (unsigned long) e;
    /* Set stack pointer */
    a7 = (unsigned long) e;
    
    Init_kernel();
  }

