#define TAPE_QUEUE 0
#define PRF_TAPE_TAPEMASTER 0

/*
 * V-System Generic Mag Tape include file, Michael Stumm
 * CopyRight (c) 1985 by Stanford University, All rights reserved.
 * 
 */

/*
 * Operations for modify
 *
 */
#define MTWEOF	0	/* write eof record */
#define MTFSF	1	/* forward space file */
#define MTBSF	2	/* backward space file */
#define MTFSR	3	/* forward space record */
#define MTBSR	4	/* backward space record */
#define MTREW	5	/* rewind */
#define MTOFFL	6	/* rewind and put offline */
#define MTNOP	7	/* nop, but sets status */
#define MTSTR_ON 8	/* set streaming mode */
#define MTSTR_OFF 9	/* set streaming mode */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode      requestcode ;	/* better be {N,}MODIFY_FILE */
    InstanceId	    fileid ;
#else LITTLE_ENDIAN
    InstanceId	    fileid ;
    SystemCode      requestcode ;
#endif LITTLE_ENDIAN
    unsigned	    opcode ;	        /* one of the above */
    int		    count ;
    unsigned        filler[5] ;
  } MtRequest ;

/*
 *
 * Bits in status
 *
 */
/* first byte */
#define TMS_EOF		(1<<0)	/* at eof marker */
#define TMS_ONLINE	(1<<1)	/* online */
#define TMS_LOAD	(1<<2)	/* at load point */
#define TMS_EOT		(1<<3)	/* at end of tape */
#define TMS_READY	(1<<4)
#define TMS_BUSY	(1<<5)
#define TMS_PROT	(1<<6)	/* writeprotected */
/* second byte */
#define TMS_FAST	(1<<8)	/* true if fast mode set */
#define TMS_STREAM	(1<<9)	/* true if in streaming mode 
				   (better turn it off!) */
#define TMS_REWIND	(1<<10)	/* true if it will rewind on eof 
				   ( have to fill up space somehow) */


/* 
 * 
 * 
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode      replycode;
    short unsigned  status;
#else LITTLE_ENDIAN
    short unsigned  status;
    SystemCode      replycode;
#endif LITTLE_ENDIAN
    unsigned        NumReads;
    unsigned        NumWrites;
    unsigned        nextblock ;
    unsigned        lastblock ;
    unsigned        filler[3] ;
  } MtReply ;

