#include <rasterops.h>
#include <sfont.h>
#include <text.h>
#include <m68000.h>

FontEntry *
LookupFont(i)
register int i;
  /* return FontEntry of font with number 'i'.
   * if the font itself is missing, try to get GetFontEntry to load it.
   */
  { register FontEntry *fontEntry;

    if (i < 16) fontEntry = Fonts.first16 + i;
    else
        for (fontEntry = (FontEntry *)Fonts.next; ;)
	  {
	    if (!fontEntry) return(0);
	    if (fontEntry->number >= i)
	        if (fontEntry->number > i) return(0); else break;
	    fontEntry = (FontEntry *)((FontLink *)fontEntry)->next;
	  }
    if (!fontEntry->font)
        if (!fontEntry->name || GetFontEntry(fontEntry->name, 0) < 0)
	    return(0);
    return(fontEntry);
  }

enum TextRetCode
ScanText (str,pn,px,xLim,pcodes)
    register char *str;			/* string to be drawn */
    int *pn;			/* maximum number of characters to draw */
    int *px,xLim;
    FontCodes *pcodes;		/* font, function to use and other codes */
  {
/*out:rightbb,count,stopcode*/
    register n = *pn;			/* d7 */
    register x = *px;			/* d6 */
    register short i;			/* d5 */
    register short offset;
    register Sfont *font;		/* a4 */
    register unsigned char c;
    int width;
    enum TextRetCode retCode;
    FontCodes codes;
    FontEntry *fontEntry;

    /* a compiler bug prevents codes=*pcodes from working: */
    *(long *)&codes = *(long *)pcodes;
    retCode = (enum TextRetCode)(FastScanText());
    *pn = n;
    *px = x;
    *pcodes = codes;
    return(retCode);

label(FastScanText);
    n++; /* compensate for one too many decrements of n in while-loop below */
    i = codes.fontNum;
  changeFont:
/* change to font number 'i' */
    if (!(fontEntry = LookupFont(i))) goto badFont;
    font = fontEntry->font;
    codes.fontNum = fontEntry->number;

    while (--n > 0)
      {
        c = *str++;
	if (c >= 0x80 && codes.inverseIfHigh) c &= 0x7F;
        if (c < MINCHAR || c > MAXCHAR)	 /* control character */
	    switch (c)
	      {
	        case STOP: returns((int)TextRetStop);
	        case FILL: case After1ByteArg:
		    continue;
	        case BS:
	            if (n && (*str != '_' || !UnderlineCode(font)))
	                i = *str;
	            else i = str[-2];
	            if (i < MINCHAR || i > MAXCHAR) width = font->maxWidth;
	            else {
	                width = font->widths[i-font->minChar].width;
	                if (width <= 0) width = font->maxWidth;
	            }
	            if (*str == '_' && UnderlineCode(font) && n) {
	               str++; --n; continue;
	            }
	            if (codes.mustClearBackground && codes.backgroundColor)
	              { 
	                str++; --n;
	                continue;
	              }
	            x -= width;
	            continue;
	        case TAB:
	            i = 8 * font->widths[' ' - font->minChar].width;
	            x += i;
	            continue;
		case SmallHskip:
		    if (--n < 0) returns((int)TextRetCount);
		    x += (int)(char)(*str++);
		    continue;
	        case LF:
	            returns((int)TextRetLine);
	        case BegInverse:
	        case EndInverse:
	            continue;
	        case BegItalic:
	            i = fontEntry->italic;
	            if (i != NOFONT && i > codes.fontNum)
	                goto changeFont;
	            continue;
	        case EndItalic:
	            i = fontEntry->italic;
	            if (i != NOFONT && i < codes.fontNum)
	                goto changeFont;
	            continue;
	        case BegBold:
	            i = fontEntry->bold;
	            if (i != NOFONT && i > codes.fontNum)
	                goto changeFont;
	            continue;
	        case EndBold: 
	            i = fontEntry->bold;
	            if (i != NOFONT && i < codes.fontNum)
	                goto changeFont;
	            continue;
		case FONTn:
	            if (--n < 0) return(TextRetCount);
		    i = *str++;
		    goto changeFont;
	        case FONT0: case FONT1: case FONT2: case FONT3:
	        case FONT4: case FONT5: case FONT6: case FONT7:
	        case FONT8: case FONT9: case FONT10: case FONT11:
	        case FONT12: case FONT13: case FONT14: case FONT15:
	            i = c & 0xF;
		    goto changeFont;
	        case QUOTE:
		    if (--n < 0) returns((int)TextRetCount);
	            c = *str++;
	            /* ... then fall through to ... */
	        default:
	            if (c < font->minChar || c > font->maxChar) continue; else break;
	    };
        c -= font->minChar;
        width = font->widths[c].width;
	if ((x += width) >= xLim)
	    { x -= width; returns((int)TextRetRight); }
      }
    returns((int)TextRetCount);
  badFont:
    printf("!!! Trying to use bad font number: %d !!!\n", i);
    returns(TextRetError);
}
