/*
 * getsfont(name,filename) -> fontnum (or -1 if font not found)
 * Finds the font called 'name'. If it already is in the FontTable Fonts,
 * (case is ignored) returns its number, else uses 'filename' to read it
 * from a remote file server.
 * Currently handles only upto 16 fonts, though there are hooks for 256.
 * 'name' is not copied, so must be in static or heap storage.
 * Per Bothner - January 1983
 */
#include <sfont.h>
extern FontTable Fonts;

GetSfont(name,filename)
  char *name,		/* name of font; e.g Helvetica12I. Must be stable! */
       *filename;	/* name of file to read font from */
  {
    register int i; register char *cpt, *cpn;
#ifdef LEAF
    char temp[66];
#else
    char temp[50];
#endif
    int fp; /* actually a file pointer */

    /* First see if font already loaded */
    for (i = 16; i >= 0; i--)
	if (cpt = Fonts.first16[i].name)
	    for (cpn = name; ; )
	      { register char cn = *cpn++, ct = *cpt++;
		if (cn >= 'A' && cn <= 'Z') cn += 'a' - 'A';
		if (ct >= 'A' && ct <= 'Z') ct += 'a' - 'A';
		if (cn != ct) break; /* i.e. continue with next i */
		if (!cn) if (Fonts.first16[i].font) return(i); else goto readFont;
	      }

    /* Nope; find an empty slot */
    for (i = 0; ; i++)
      {
	if (i >= 16)
	  { printf("[Warning: too many fonts already loaded!]\n"); return(-1);}
        if (!Fonts.first16[i].name) break;
      }
printf(" slot: %d " , i);
    readFont:
    /* try reading it */
    if (!filename)
      {
#ifdef LEAF
printf("name: ");
        sprintf(temp, "[shasta:ftpguest:ftpguest]/usr/local/fonts/sfont/%.12s.sf", name);
#else
        sprintf(temp, "/usr/local/fonts/sfont/%.23s.sf", name);
#endif
printf(" fopen(%s,r)",temp);
	fp = fopen(temp, "r");
printf("=> %x ",fp);
	if (!fp) return(-1);
      }
    else
	fp = fopen(filename, "r");
printf(" opened! ");
    if (!fp)
      {
#ifdef LEAF
	sprintf(temp, "[shasta:ftpguest:ftpguest]/usr/local/fonts/sfont/%.12s", filename);
#else
	sprintf(temp, "/usr/local/fonts/sfont/%.23s", filename);
#endif
	fp = fopen(temp, "r");
	if (!fp) return (-1);
      }
      { /* Actually allocate and read the font */
        register size;     register char *buf; /* word ? */
        size = (fgetc(fp) << 8) & 0xFF00;
	size += (fgetc(fp) & 0xFF);
        buf = (char *)(malloc(size));
        Fonts.first16[i].font = (Sfont *)buf;
        Fonts.first16[i].name = name;
        Fonts.first16[i].number = i;
        Fonts.first16[i].italic = NOFONT;
        Fonts.first16[i].bold = NOFONT;
	*buf++ = size>>8; *buf++ = size&0xFF;
        for (size -= 2; size > 0; size--) *buf++ = fgetc(fp);
	fclose(fp);
        return(i);
      }
  }
