/*
 * GetFont(name,filename) -> fontnum (or NOFONT if font not found)
 * Finds the font called 'name'. If it already is in the FontTable Fonts,
 * (case is ignored) returns its number, else uses 'filename' to read it
 * from a remote file server.
 * The font file may be a .b file defining 'name' in the data segment,
 * or an archive (.a), which may be random-access.
 * Per Bothner - February 1983
 * Change to alloc copy of name. PB May 83
 * Added random-access reading if __.SYMDEF component found.
 * Jan 1984. Bug fixes: close file on failure. Initialize fnt->name = NULL.
 * Warning: Spaghetti!
 */
#include <sfont.h>
#include <b.out.h>
#include <stdio.h>
/* -- file has been written so that it can be linked in with Vkernel library */
#include <ar.h>
#include <sys/types.h>
#include <ranlib.h>
#include <m68000.h>

static struct bhdr filhdr;
static struct sym cursym; 
static struct ar_hdr arhdr;
char *malloc(), *strcpy();

FontEntry *
GetFontEntry(name,filename)
  char *name,		/* name of font; e.g Helvetica12I. Must be stable! */
       *filename;	/* name of file to read font from */
  {
    register int i; char *cp;
    FILE *fp; /* actually a file pointer */
    int curfilestart = 0; /* for arhives, gives byte # in file of current component */
    int moreSymb; /* bytes remaining in a symbol section of binary file */
    register FontEntry *fnt; register FontLink *link;
    /* see if font already loaded. First try the static first 16 */
    for (fnt = Fonts.first16; fnt < Fonts.first16 + 16; fnt++)
        if (EqString(name, fnt->name))
	    if (fnt->font) return(fnt); else goto readFont;

    /* it's not in the first16; check if in linked list */
    for (link = Fonts.next; link != NULL; link = link->next)
	if (EqString(name, link->fontEntry.name))
	    if (link->fontEntry.font) return((FontEntry *)link);
	    else {fnt = (FontEntry *)link; goto readFont;}

    /* Nope; find an empty slot */
    for (i = 15, fnt = Fonts.first16; i >= 0; i--, fnt++)
        if (fnt->name == NULL) {fnt->number = 15 - i; goto readFont;}

    /* no space in the static part of Fonts; try the linked list part */
    link = (FontLink *)(Fonts.first16 + 15);
    for (;;)
      {
	fnt = (FontEntry *)(link->next);
	if (fnt == NULL)
	    if (link->fontEntry.number == NOFONT) return((FontEntry *)TooManyFonts);
	    else break;
	if (fnt->name == NULL) goto readFont;
	if (link->fontEntry.number + 1 < fnt->number) break;
	link = (FontLink *)fnt;
      }

    /* link in a new FontLink  just after *link */
    fnt = (FontEntry *)(malloc(sizeof(FontLink)));
    ((FontLink *)fnt)->next = link->next;
    link->next = (FontLink *)fnt;
    fnt->number = link->fontEntry.number + 1;
    fnt->name = NULL;

  readFont:
    /* try reading it */
    fp = fopen(filename ? filename : "/usr/sun/lib/libsfonts.a", "r");
    if (!fp) return((FontEntry *)FontFileNotFound);
    
    fread(&filhdr, SARMAG, 1, fp);
    if (strncmp(&filhdr, ARMAG, SARMAG))
        fread(SARMAG + (char *)&filhdr, sizeof(filhdr) - SARMAG, 1, fp);
    else
      {
	curfilestart = SARMAG + sizeof(arhdr);
	fread(&arhdr,sizeof(arhdr), 1, fp);
	if (!strncmp(arhdr.ar_name, "__.SYMDEF       ", 12))
	  { int i, strTabLen, symNo = 0;
	    fread(&i, 4, 1, fp); reverselongs(&i, 1);
	    fseek(fp, i, 1);
	    fread(&strTabLen, 4, 1, fp); reverselongs(&strTabLen, 1);
	    for (; strTabLen > 0; symNo++)
	      { char *cp = name;
		for (; ;)
		  { register char cn = *cp++, cf = fgetc(fp);	            
		    strTabLen--;
		    if (cn >= 'A' && cn <= 'Z') cn += 'a' - 'A';
		    if (cf >= 'A' && cf <= 'Z') cf += 'a' - 'A';
		    if (cf != cn)
		      {
		        while (cf) {cf = fgetc(fp); strTabLen--;}
			break;
		      }
		    if (!cf)
		      {
			fseek(fp, curfilestart + (symNo<<3) + 8, 0);
			fread(&i, 4, 1, fp);
			reverselongs(&i, 1);
			curfilestart = i;
			goto endComp;
		      }
		  }
	      }
	    fclose(fp);
	    return((FontEntry *)FontNotInFile);
	  }
	fread(&filhdr, sizeof(filhdr), 1, fp);
      }
  nextComp:
    if (filhdr.fmagic == RMAGIC) reverselongs(1 + (long *)&filhdr, 7);
    fseek(fp, curfilestart+(SYMPOS), 0);
    moreSymb = filhdr.ssize;
    while (moreSymb > 0)
      {
        fread(&cursym, sizeof(cursym), 1, fp);
	moreSymb -= sizeof(cursym);
	if (filhdr.fmagic == RMAGIC)
	  {
	    fseek(fp, -2, 1); moreSymb -= 2; /* compensate for Vax long alignment */
	    if (!fread(&cursym.svalue, sizeof(cursym.svalue), 1, fp))
	        {fclose(fp); return (FontEntry *)BadFontFile;}
	    reverselongs(&cursym.svalue, 1);
	  }
	i = cursym.slength; cp = name;
	if (cursym.stype == EXTERN + DATA)
	while (1)
	  { register char cn = *cp++, cf = fgetc(fp), *buf;
	    i--;
	    if (cn >= 'A' && cn <= 'Z') cn += 'a' - 'A';
	    if (cf >= 'A' && cf <= 'Z') cf += 'a' - 'A';
	    if (cn != cf) break; /* i.e. continue with next symbol */
	    if (i && *cp) continue;
	    if (i || *cp) break;

	    /* Actually allocate and read the font */
            buf = malloc(filhdr.dsize);
	    fseek(fp, curfilestart + DATAPOS, 0);
	    fread(buf, filhdr.dsize, 1, fp);
	    fclose(fp);
	    fnt->font = (Sfont *)(cursym.svalue + buf);
	    if (!fnt->name) fnt->name = strcpy(malloc(strlen(name) + 1), name);
            fnt->italic = NOFONT;
            fnt->bold = NOFONT;
            return(fnt);
	  }
	if (cursym.slength & 1) { fgetc(fp); moreSymb--; }
	moreSymb -= cursym.slength;
      }
    if (curfilestart)
      {
	curfilestart += ((atoi(arhdr.ar_size) + 1) >> 1) << 1;
      endComp:
	fseek(fp, curfilestart, 0);
	if (!fread(&arhdr,sizeof(arhdr), 1, fp))
	    { fclose(fp); return (FontEntry *)FontNotInFile; }
	curfilestart += sizeof(arhdr);
	fread(&filhdr, sizeof(filhdr), 1, fp);
	goto nextComp;
      }
    fclose(fp);
    return((FontEntry *)FontNotInFile);
  }

reverselongs(p,n)
  /* byte reverse n longs: *p..p[n-1] */
  long *p; int n;
  {
    union
      {
	long l;
	char c[4];
      } ul;
    char ch;

    while (--n >= 0)
      {
	ul.l = *p;
	ch = ul.c[2]; ul.c[2] = ul.c[1]; ul.c[1] = ch;
	ch = ul.c[3]; ul.c[3] = ul.c[0]; ul.c[0] = ch;
	*p++ = ul.l;
      }
  }

EqString(s1, s2)
register char *s1, *s2;
/* test if strings s1 and s2 are equal, ignoring case.
 * s1 must be != 0. s2 can be 0, in which case 0 is returned.
 */
  {
    if (!s2) return(0);
    for (;;)
      { register char c1 = *s1++, c2 = *s2++;
	if (c1 >= 'A' && c1 <= 'Z') c1 += 'a' - 'A';
	if (c2 >= 'A' && c2 <= 'Z') c2 += 'a' - 'A';
	if (c1 != c2) return(0);
	if (!c1) return(1);
      }
  }

GetFont(name, filename)
  char *name,		/* name of font; e.g Helvetica12I. Must be stable! */
       *filename;	/* name of file to read font from */
  {
    GetFontEntry(name, filename);
    if (d0 < 0) return(NOFONT);
    a0 = (long *)d0;
    return(((FontEntry *) a0)->number);
  }
