@Part( unix, root "manual" )
@Chapter(Unix Server)
@Index[Unix server]@index(V server)
@label(UnixServer)

The V Unix server
is a Unix program (and not a V program or command)
designed to simulate a V kernel/storage server on a VAX
Unix system (currently only Berkeley Unix 4.2 or 4.3).
It provides access to some of the
Unix system services via the V kernel interprocess communication 
primitives.
To workstations running the V kernel, the Unix server appears as a
standard V server, primarily providing Unix file access using the
standard V I/O protocol.
Note: Unix servers are also frequently referred to 
as @i[V servers].  (Someday we may even implement such a server for an 
operating system other than Unix.)

Unix servers, like true V storage servers, implement the V-System naming
protocol.
The Unix system's complete directory tree is rooted at a node called
@t{[storage/@i(hostname)]}, where
@i(hostname) is the name returned by the Unix @t[gethostname()] 
routine (converted to lower case).@Foot{@i[hostname] can also be set by 
starting the server (@t[Vserver]) with the @t[-n] option.}
A Unix server may be either @i[public]@index[public] (if it is started with the
@t[-p] option), or non-public.
A public Unix server implements the generic name @t{[storage/any}, 
and therefore such a host must maintain the up-to-date versions of all the
standard V-System files and commands.
On the other hand, hosts that run non-public Unix servers are not required to
be kept up-to-date.


@Section(Sessions)
@index[Sessions]
If a V server is running on a Unix system, then remote access to the resources
of this system is provided by @i[session] processes.
Sessions are `forked' copies of the main V server, each dedicated to a 
particular V user number.
Like the main V server, each session appears externally as a regular V process.
On each Unix host, the main V server, plus all of its sessions, belong to a
local V process group.  The `group id' of this process group is usually
used to communicate with the Unix server.
@foot[@i[Individual] pids are used for file instance I/O, however.]
As mentioned above, each session is dedicated to a particular V user number.
Any message that is sent to the common group id will be handled by the
particular session that is responsible for that message's user number.
(If no such session exists, then the main server will create one automatically.)
The distribution of incoming packets to the individual sessions is handled by 
the @i[packet filtering] code in the Unix kernel (see the ``installation 
notes'' for further details).
@begin[warning]
As an optimization, the packet filters for each session currently 
assume that the high-order 16 bits of each user number are zero.  Thus, one 
should beware of using user numbers higher than 65535.
This restriction is likely to be eliminated in future releases of the system.
@end[warning]

@Subsection[User Correspondences]
@Index[UserCorrespondences]
@Label[UserCorrespondences]
The main V server always runs as `root'.
The Unix uid of a session, however, is determined by a V-to-Unix
@i[user correspondence] table, which is a mapping from V user numbers to Unix
user names.
The user correspondence table is maintained as a file on each Unix host.  The 
name of this file is given by the macro USER@us()CORRESPONDENCE@us()FILE, 
defined in the header file @t[config.h] (in the Unix server source directory).
(At Stanford, this file is named @t[/etc/V/Vusercorrespondence].)
For security, the user correspondence file should be writeable only by ``root''.
The file should contain user correspondences for at least the following V 
user numbers:
@begin[description]
0 (SUPER@us()USER), and 1 (SYSTEM@us()USER)@\These should correspond to
whatever Unix account is used
to manage V-System files on Unix (although preferably @i[not] ``root'').

2 (UNKNOWN@us()USER)@\This should correspond to a Unix user with very few 
privileges.
@end[description]

@Subsubsection[Adding and Deleting User Correspondences]
If a user correspondence for a particular V user number is not present in the 
user correspondence file, then the user correspondence for the V UNKNOWN@us()USER
is used instead.
That is, a session for a V user who does @i[not] have a user correspondence 
will run with the same permissions as a non-logged in user.
In addition, such users are not permitted to execute programs remotely on the 
Unix host (see section @ref[UnixProgEx]).

A V user can use the (V) @t[addcorr]@index[addcorr]
program to create (or modify) a user 
correspondence on any Unix host (provided that it is running a V server, of 
course).
@t[addcorr] repeatedly prompts for a host name, then a (Unix) user name and
password on this host.  It then attempts to create a new user correspondence.
(If this is successful, then any existing correspondence for the V user will
be removed.)

The @t[delcorr]@index[delcorr] program can be used to delete an existing
user correspondence.
@t[delcorr] repeatedly prompts for a host name, and attempts to delete an 
existing user correspondence for the V user on this host.

The V SUPER@us()USER can use @t[addcorr] and @t[delcorr] to modify user 
correspondences for @i[any] V user (not just for SUPER@us()USER).  (In this case 
these programs will also prompt for a V user name.)

The following additional points should be noted:
@begin[itemize]
When a user correspondence for a V user on a particular
host is added/modified (using @t[addcorr]) or deleted (using @t[delcorr]),
then any existing session for the V user on this host will be 
destroyed.  (Subsequently, a new session will still be created automatically,
if needed.)

The V UNKNOWN@us()USER is not permitted to modify his own user correspondences.

For security, the Unix servers do not allow user correspondences to be made 
to ``root'', nor to Unix accounts with a null password.

If your current context is a Unix V session, then
the (Unix) @t[whoami] program 
can be executed remotely, in order to show the Unix uid of this session.
(Recall that the (V) @t[name] program can be used to show your exec's V user
number.)
@end[itemize]

@Subsection[Lifetime of Sessions]
A session will die automatically if it has been inactive for a certain period 
of time (defined by MAX@us()SESSION@us()INACTIVITY in @t[config.h]_15 minutes
at Stanford), and if it is not maintaining any instances with valid owner pids.

@Section(File Access)
When a session receives a CREATE@us()INSTANCE request,
it attempts to open the named file.
If the session has the correct permissions, then an instance is
created, with the @i[type] field set according to the request mode.
Files opened in FREAD mode are
of type READABLE, FIXED@us()LENGTH, and MULTI@us()BLOCK.
The modes FCREATE and FMODIFY create instances of type READABLE,
WRITEABLE, and MULTI@us()BLOCK.  FAPPEND mode adds the further
constraint of APPEND@us()ONLY.
All instances are random access, but operations must
start on a block boundary.  The block size of these instances is
equal to the maximum appended segment size for V kernel messages.

If the mode is FCREATE, or it is FMODIFY and the file does not exist,
then a new file is created along with the
associated instance.
Files are created with Unix file protection bits (``mode bits'') set to
allow reading and writing by the owner, and reading by group and others.
This protection mode is given by the macro DEFAULT@us()CREAT@us()MODE, defined 
in @t[config.h].
A client may change the
mode bits using a WRITE@us()DESCRIPTOR or NWRITE@us()DESCRIPTOR request.

@Section(Program Execution)
@label[UnixProgEx]
A client can execute Unix programs through a V session by sending
a CREATE@us()INSTANCE request with the FEXECUTE flag set in the
mode field.  The name and arguments of the program to be executed
are sent in the segment with the NULL character being a field
separator. The last argument need not be null terminated.
The context in which the program is to be executed is also
specified in the request.  

Given a request, the session has a built-in search path
that it uses to determine which Unix program to execute.
This search path is given by the macro PROGRAM@us()SEARCH@us()PATH, defined 
in @t[config.h].
@foot{
Alternatively, the search path can be found by
executing the Unix command
@t(printenv).  This will display the environment variables
that are passed on to programs executed via the session.
}
The session tries to find the first file in a directory along the search
path that matches the given name.  If the name contains
a `/', then the search path mechanism is not used and only the
context specified in the request is searched.
If the program is a shell script, the Bourne shell is invoked
explicitly, and it determines which shell should execute the script
based on the normal Berkeley Unix conventions.
As a side-effect,
the shell expands any wild-card characters (such as `*' and `?') found
in the arguments.  This expansion does not occur if the Unix program
is not a shell script.

After all of the preliminary checking is done, the session forks
and its child attempts to run the program.
The parent
process replies to the requestor with an OK status.  However, there
is no guarantee that the execution will be successful.  A failure
can occur after the OK reply has been returned,
since the program is not loaded until the child
has been forked off and the reply is sent asynchronously.  If a failure
of this nature occurs, then an error message should appear
in the program's output.

In the reply message, the session includes an instance id for the 
running program.   If the file mode in the CREATE@us()INSTANCE request 
was FREAD, then the instance id specifies an instance of type
READABLE, VARIABLE@us()BLOCK, and STREAM.  The client can read
the program's standard output using this instance.

If the mode was
FCREATE, FMODIFY, or FAPPEND, then the instance returned in the reply
message is of type WRITEABLE, VARIABLE@us()BLOCK,
APPEND@us()ONLY, and STREAM.  Data written into this instance is piped
into the program's standard input.
An instance with id 1 greater than the one returned in the reply is
also created, of type READABLE, VARIABLE@us()BLOCK, and STREAM.
Reading from this instance provides access to the program's standard output.

When the program terminates (either normally or abnormally), the
session returns an END@us()OF@us()FILE reply to any write requests.  Read
requests will continue to be accepted as long as data is left in
the pipe.  Write requests will block if the pipe is full 
and the Unix program is not reading from it. (Unix pipes can buffer
up to 4096 bytes of data.)

A client may terminate the program by releasing all instances associated
with it.   If only one of the instances is closed, the program
will not terminate immediately.  This allows a client to close the
program's input and have it clean up before exiting.  One should
be careful not to release the readable instance before program termination, 
because Unix sends a 
signal to any program that writes to a pipe with only one end. 
The signal will kill the Unix process, if the process is not 
catching or ignoring it.

@Section(File Descriptors)
@label(Descriptors)
The server supports V context directories and descriptor requests.
One can open a Unix directory with the FDIRECTORY 
flag set in the mode field and the server will automatically translate
standard Unix directory entries to V Unix file descriptors.
Directories are 
not writeable directly, but descriptors
can be modified using a WRITE@us()DESCRIPTOR or NWRITE@us()DESCRIPTOR
request.
The @i(UnixFileDescriptor) type is defined in the system include file
@t[<Vdirectory.h>].  

@Section[Debugging Sessions]
It is possible to turn on debugging output from a session (or the main server),
by `killing' it with the SIGTSTP signal.
Debugging output is redirected to the file @t[/tmp/VserverDebug@i{n}], 
where @i[n] is the (Unix) pid of the server or session.
To turn off debugging output, kill the process with the SIGTSTP signal once 
again.
@i[Warning:] Debugging should be turned off as soon as possible, because this 
file quickly gets to be @i[very] big.
Note that debugging output is likely to be of use only to wizards.

If your current context is a Unix V session, then the (V) @t[instances] 
program can be used to find out the status of whatever file instances
this session is maintaining at the time.
