@Part( vstorageserver, root "manual" ) 
@Chapter(V Storage Server)@label(VStorageServer)
@index(Storage server)

The V storage server is a file system that implements the V I/O protocol.
It is intended to run on any workstation with mass disk storage, and
can provide file access for local and remote users.  It provides an alternative
to the Unix Server for file storage.  It implements a hierarchical name
space with a syntax very similar to that of the UNIX file system (i.e. pathname
components are separated by a "/").  Additionally, there is no distinction
between files and directories in the V storage server (i.e. any file can "act"
like a directory in that it can have descendents in the tree structure).

One word of caution is that there is currently no backup facility for 
the V storage server.
Thus, files requiring backups should use the file storage
provided by the Unix Server.  However, the V storage server is very useful
for storing executable programs and temporary files.

@Section(Running the V storage server)
One can start up the V storage server from within a V executive
by typing
@programexample(storageserver)
or
@programexample(storageserver @i<devicename>)
If no device name is specified, the storage server attempts to open 
two devices,
[device]disk0 and [device]disk1.  Non-existence of a second device does not
affect correct operation of the program.
Note that the devices must be attached to the workstation from which
the command is invoked and the kernel running on the workstation must include
the proper disk driver (see the Kernel Section for details on which
kernel should be booted).

@Section(Accessing the V storage server)
The V storage server participates in the standard V-System naming protocol.
Currently, each storage server implements a single tree of named files,
rooted at a node called @t{[storage/@i(hostname)]}, where
@i(hostname) is the name of the workstation where the server is running,
as obtained from the workstation
configuration database (Section @ref(ConfigDatabase)).

A CREATE@us()INSTANCE request causes the server to attempt to open the named
file.  Files opened in FREAD mode are
of type READABLE, FIXED@us()LENGTH, and MULTI@us()BLOCK.
The modes FCREATE and FMODIFY create instances of type READABLE,
WRITEABLE, and MULTI@us()BLOCK.  FAPPEND mode adds the further
constraint of APPEND@us()ONLY.
All instances are random access, but operations must
start on a block boundary.

If the mode is FCREATE, and the file does not exist, then a new file is created
along with the associated instance.  The permission bits of the new file
will be the same as those of its parent node in the directory tree structure.

If a CREATE@us()INSTANCE request is successful, a file instance identifier
is returned by the server that is used by the client for all subsequent 
accesses to this instance.  In addition, the server returns a 
@i<file instance server>
pid which is the process to which all subsequent I/O requests will be directed.
This pid is different from
that of the main server because one process (namely, the one registered as
the VSTORAGE@us()SERVER)
handles CREATE@us()INSTANCE
requests and other processes handle I/O requests.

Once an instance has been created, a client can perform I/O operations
on the file represented by the instance using READ@us()INSTANCE and
WRITE@us()INSTANCE requests.  These requests, if legitimate, result in the
@i<file instance server> carrying out the desired tasks.  When a client is
finished accessing a file, it closes the file by issuing a RELEASE@us()INSTANCE
request.  

The V storage server implements most of the V-System Naming Protocol,
including the GET@us()CONTEXT@us()ID, GET@us()CONTEXT@us()NAME,
GET@us()FILE@us()NAME, GET@us()ABSOLUTE@us()NAME, and QUERY@us()NAME
requests.  In addition, context directories
are supported by allowing the FDIRECTORY bit to be set in the mode field
of a CREATE@us()INSTANCE request.  Object descriptors can
be examined using READ@us()DESCRIPTOR and NREAD@us()DESCRIPTOR requests,
but modification of object descriptors (using WRITE@us()DESCRIPTOR and 
NWRITE@us()DESCRIPTOR requests) is not yet implemented.

The V storage server supports many other types of requests including ones
to create, remove, and rename files and most other relevant requests
associated with the V I/O and naming protocols.  Note that many applications
need not be concerned with message types and formats as actual message
construction usually takes place within V commands and standard library
routines.  For example, CREATE@us()INSTANCE, READ@us()INSTANCE,
WRITE@us()INSTANCE, and RELEASE@us()INSTANCE requests are encapsulated
in the library routines Open(), Read(), Write(), and Close(), respectively.

@Section(Permissions)
Each node in the directory tree structure supports access by three classes
of users: owner, group, and others.  There are five permission bits for
each class.  Three of the bits relate to the file attributes of
the node; they control the @i(read), @i(write), and @i(execute) access to 
the contents of the file represented by the node.

The other two bits correspond to the "directory" attributes of the node.
They control @i(list) and @i(modify) access to the descendents of the node.
List allows the tree substructure to be examined while modify allows
it to be altered.

