@Part( pipe, root "manual" )
@Chapter(Pipe Server)@label(PipeServer)

The pipe server is an I/O server that implements a synchronized stream file
called a pipe.
A pipe is a unidirectional flow-controlled communication channel
between two processes using the standard I/O protocol.
V pipes are similar to Unix pipes.

A pipe file instance is type STREAM, VARIABLE@us()BLOCK,
and READABLE (for the read end) or WRITEABLE (for the write end).

In response to a CREATE@us()INSTANCE request,
the pipe server creates an instance of a pipe,
which is actually two file instances representing the read and write ends of
the pipe.
The file id returned in the reply to the CREATE@us()INSTANCE request is
the file id of the write end.
The file id of the file instance for the read end is one greater than
the file id for the write end.
The file instances are owned initially by the processes specified
in the @i[readowner] and @i[writeowner] fields of the CreatePipeRequest.
When a pipe is created,
it is allocated a fixed number of buffers between 2 and 10
as specified by the @i[buffers] field of the CreatePipeRequest.
Include <Vpipe.h> in a program to define CreatePipeRequest.

Pipe synchronization provides that
a request to read a block that has not yet been written is
queued until that block is written.
Also, a request to write a block when the current buffer limit for
the pipe is exceeded is queued until buffer space is available.
@Foot(Actually only one reader and one writer
are queued; the rest are replied to with a RETRY reply code.)

A request to read from an empty pipe whose write file instance
has been released is replied to with an END@us()OF@us()FILE reply code.
When the read end file instance is released,
unread data is discarded and the data of subsequent writes to the write
instance
are discarded with the write returning successfully.
A pipe no longer exists when both the read and write instances are released.
The pipe server periodically checks that the owners of both file instances
of the pipe exist.
When the server determines that the owner of an instance no longer exists,
it effectively releases that instance.

The pipe server is located by
@programexample{server@uf()pid = GetPid(PIPE@uf()SERVER,ANY@uf()PID)}
where the pipe server may be local to the workstation or located
on a server node.

The pipe server can be compiled as an independent V program
or included in another program.
To include the pipe server directly in a V program,
call the function @t[InitPipeServer()] at the start of the program
and cause the linker to search the pipe server library when loading the
program (i.e., add -lVpipe on the C compilation command line).
The standard V command @i[pipeserver] may be run in the background
to provide a local pipe server on any workstation.  The V executive
automatically starts up a local pipe server if there is not one available 
when a pipe is needed.

