@string(LastEditDate="Tue Jun 17 17:14:30 1986")
@comment(Current maintainer: Keith Lantz)

@Part(ServersOverview, root "manual" )
@Chapter(Servers Overview)
@label(Servers Overview)

All system services other than those implemented by the
kernel@Index[services] are provided by sending a message to one of the
system server processes.  This part of the manual describes the various
protocols for requesting these services,@Index[protocol] including the
format of request and reply messages, the possible values for the message
fields, and the server process that handles the request.  A secondary role
of this part of the manual is to act as an implementation guide to the
various servers; at some future time, these implementation details will be
removed to a separate manual.

The information contained in this part of the manual is generally not
required by application programmers because most protocols are implemented
in the standard C program library described in Part II of the manual.
However, more sophisticated use of the system may require the more detailed
information in this part of the manual.

This chapter gives an overview of the interactions among the different
servers and the kernel.  The next three chapters present the standard
message formats and codes, and the details of two standard protocols, the
V-System I/O Protocol and V-System Naming Protocol.  The remaining chapters
give the details of the individual servers, describing which of the standard
protocols they implement, additional server-specific protocols they
provide, and, in many cases, how they are implemented.

@section(The Basic Servers - In Isolation)

Figure @ref(FigVSWV) shows the configuration of
servers on a typical workstation.  The various interactions indicated are
discussed in the following section.  Here we discuss the basic functions 
and structure of each server more or less in isolation from the others.
@Begin(Figure)
@PressPicture( Height = "8.0 Inches", File = "bigsing.fig" )
@Caption(The V-System: A single workstation view.)
@Tag(FigVSWV)
@End(Figure)

@subsection(General Considerations)

There are two basic dimensions by which servers may be classified: whether
they are implemented as pseudo-processes@index(pseudo-processes) within the kernel or outside the
kernel, and whether an instance of the server exists on each workstation or
not.  Several servers are implemented internal to the kernel primarily for
performance reasons.  Naturally, these servers must exist on every
workstation.  As discussed below, there are several additional servers,
including those that manage teams and exceptions, instances of which must
also exist on every workstation.  Other servers exist, however, that need
not be resident on every workstation, the most common example being a
storage server.

Regardless of how (or where) servers are implemented, they are always
accessible via the usual IPC facilities and standard protocols.  The
``main'' server process typically consists of an infinite loop that receives
a request for service, processes it, receives the next request, and so on.  

Because all message-passing is synchronous, the main process typically
cannot employ the @t[Send()] primitive, lest it block indefinitely.  For
this reason and others, servers implemented outside the kernel often employ
additional processes, for example, to send messages for them, to service
multiple input streams in a responsive fashion, or to manage multiple open
``instances'' (of objects) without complex multiplexing.  These auxiliary
processes are generally called @i(helpers)@index(helper process).

@subsection(Machine-relative Servers)
@index(machine-relative servers)

Machine-relative servers are servers, instances of which exist on every
workstation running V.

@paragraph(Kernel Server)@index(kernel server)

The kernel server is a pseudo-process embedded in the kernel that handles
all requests to manage processes, as well as the requests to create and
terminate teams.  

@paragraph(Device Server)@index(device server)

All hardware I/O devices attached to the workstation are serviced by the
 @i(device server), which is a pseudo-process embedded in the kernel.  The
device server supports the standard I/O and naming protocols discussed in
Chapters @ref(IOProtocol) and @ref(NamingProtocol), respectively.
Consequently, it behaves like any other I/O server as far as applications
are concerned.

@paragraph(Team Server)@index(team server)

The team server is the manager of the physical host.@foot[In some documents
it is also referred to as the @i(program manager).]
It loads, executes, and monitors  all teams other than the first.
(Recall that a team usually corresponds to a program,
although some programs consist of more than one team.)
Requests to the team server ask it to load and start a team, to
terminate one, or to print the directory of currently executing teams.  

The team server also provides the bulk of the remote execution and
migration facilities.  It implements the policies that determine whether to
accept other workstations' programs for execution to begin with and whether to
preempt them later on.  It also implements the facilities needed
to migrate programs between workstations.

@paragraph(Exception Server)@index(exception server)

The exception server is notified whenever a process incurs an exception.
If another process has registered itself as the exception handler for the
process that incurred the exception, the exception server simply forwards
the exception to the registered handler.  Otherwise, it prints a message on
the screen (using the console device).  The latter case does not arise very
often in practice, however, because the team server registers itself as the
exception handler of last resort for almost all processes.  

@paragraph(Workstation Agents)
@index(workstation agent)

Workstation agents were discussed at length in Chapter @ref(User Interface 
Overview).  Here, we merely present the basic implementation of the VGTS as a
canonical example of server structure.

The VGTS is structured as one server process with three helper processes
(see Figure @ref(FigVGTS)).@index(Helper Processes) There is one helper
process to receive input from the mouse (through the device server), one to
read from the keyboard, and a timer process to invoke periodic functions
like redrawing the screen.  The keyboard and mouse helper send requests to
the device server, and block until input arrives.  When they receive a
reply, they then send the input to the main server process, and request more
input from the device server.  This is a typical use of helper processes for
processing multiple input streams, simultaneously and in a responsive manner.
@Begin(Figure)
@PressPicture( Height = "6.25 Inches", File = "vgtsproc.fig" )
@Caption(VGTS process structure.)
@Tag(FigVGTS)
@End(Figure)
@Begin(note)
Although grouped with all the other machine-relative servers, workstation
agents are distinguished by the fact that they need not exist at all.  That
is, if the workstation does not support any user I/O devices there is no need
for it to support a workstation agent.  
@End(note)

@begin(comment) **** REDUNDANT AS INDICATED AND ALSO INCORRECT -- KAL, 5/1/86

Terminal agents are a generic class of server used in the V-System.
A terminal agent mediates between the terminal hardware, the user, and the
other programs, including servers, in the system.
It is called upon by programs or other servers to receive input from
devices controlled by the user, or to display output to the terminal screen.
Our terminal agents read from the keyboard and the mouse by sending
requests to the kernel device management routines.@index(Device server)
(Of course, helper processes send these requests and then block until
they receive a reply with new input.
They then send a message to the
main terminal agent process so that it can take appropriate action.
The terminal agent doesn't send the request to the kernel itself
because it would then be blocked waiting for input and couldn't fulfill
any output requests while it waited.)

Each workstation has one terminal agent running on it.
All of our terminal agents provide basic line editing capabilities.
They make sure that the backspace key does not add a backspace character
to the input stream, deleting the previous character instead.
They translate the newline character to a carriage return/linefeed sequence
on terminals that require it.
Terminal agents may, but need not, support multiple I/O streams.
Our terminal agents can differ for two reasons:  because they offer different
services to users, or because they run on different kinds of terminals.

@b(Simple Terminal Server)

The V-System currently can be configured with two different terminal agents,
the Simple Terminal Server@index(Simple Terminal Server) (STS)@index(STS)
and the Virtual Graphics Terminal Server (VGTS)@index(VGTS).
The STS is a minimal terminal agent.
It provides a single I/O stream, using the terminal facilities provided
by the firmware monitor of the workstation.
It gains access to these by sending messages to the kernel device server
using the V I/O protocol@index(I/O Protocol),
which includes commands for initializing the device,
querying its state, reading a ``block'' of data, and releasing access to the
device.
A standard line editing facility is implemented, but no graphics or mouse
capabilities are supported by the STS.

The STS, besides taking requests from its clients for the next line of
input, also handle requests for modifying the @i[input/output cooking].
For instance, it is possible to turn off the feature that echoes character
input, or set a switch that keeps a screenful of output from
whizzing by before the user can read it.
Indeed, though most programs can execute using any terminal agent,
those that want direct access to the screen must use the STS and ask it
to turn off all the features it usually implements.

@b(Virtual Graphics Terminal Server)

The VGTS@index(VGTS) is our more powerful terminal agent;
it provides a large
set of facilities, including multiple I/O streams in multiple windows,
graphics output, and mouse-controlled menus.
It multiplexes both the output devices (the screen)  and the input devices
(the keyboard and mouse) among all the programs that use them.
My screen while preparing this section looked like Figure @ref(FigSCRE).
@Begin(Figure)
@PressPicture( Height = "6.25 Inches", File = "vgtsout.fig" )
@Caption(VGTS Screen Output.)
@Tag(FigSCRE)
@End(Figure)
The command interface within each of the @i[executive windows] is identical
to that provided in only one window by the STS, including the line editing
and I/O cooking features.

Both users and applications can use the facilities of whichever terminal
agent is running on the workstation.
However, whereas the STS can handle only line-at-a-time input and output,
the VGTS provides applications with considerably more options.
The central concept of the VGTS is that application programs should only
have to deal with creating and maintaining abstract graphical objects.
The details of viewing these objects are taken care of by the VGTS.
This is in contrast to traditional graphics systems in which users perform the
operations directly on the screen, or on an area of the screen referred to
as a viewport or window.
Thus the VGTS deals with declarative information rather than procedural;
the user describes what the objects are rather than how to draw them.

Clients of the VGTS can define and display @i[items]@index(Item), which can be
either graphical primitives, like lines, rectangles, text, and raster
bitmaps, or @i[symbols], which consist of other items.
They can also create virtual terminals
to display items, or to emulate ANSI standard text terminals.
(If a virtual terminal displays only text, it is sometimes called a @i[pad]@index(Pad).)
The VGTS functions, like those of most servers, are accessible to
applications programs through library routines.
The library routines take appropriate parameters, format a message to
the server and send it.
Thus the message interface used for requesting system services is hidden
from the casual programmer by a conventional procedure call interface.

Users can also use the facilities of the VGTS directly to control the
layout of the screen and the way in which the virtual graphics terminals
are viewed.
The module that performs this function is called the @i[view manager]@index(
View Manager).
Though currently tightly coupled to the rest of the VGTS, it is logically
almost a separate server, providing an interface between the user and
the drawing routines of the VGTS.
Through the view manager, the user maps VGTs onto the physical screen
and manipulates the resulting views.
It executes commands to create views of defined VGTs, delete them, move
them around the screen, zoom in on the items in them, change their
sizes, and so on.
These commands are primarily given by the user through pop-up menus and
mouse clicks and movement.

The view manager is, in effect, responsible for the graphical user
interface.
In fulfilling this duty, it acts logically as a client of the rest
of the VGTS:  it asks the input handling routines for mouse clicks,
calls upon the drawing routines to display the appropriate menu,
receives the next click for the command selection, and uses more output routines
to perform the selected operation.
Some members of the group have even suggested attempting to implement
the view manager as a separate server, but the tight interaction between
it and the other parts of the VGTS has so far prevented the decoupling.

@blankspace(.25 inches)

The STS and VGTS are not the only terminal agents we can envision creating
for the V-System.
On terminals without graphics capabilities, it still seems to be reasonable
to run a Virtual Terminal Server, which will provide multiple windows for
input and output.
Users could issue commands to switch between them and merely have the
screen cleared and rewritten with the requested window.
Indeed, because the terminal management facilities are often a matter of
user preference, the designers of our terminal agents have provided a
command (@i[newterm])@index(Newterm)
which allows the user to replace one terminal
agent with another, including another of his or her own design.
When issued, this command orders the existing agent to destroy all its
views and then destroy itself.
Newterm then loads the new server and starts it.
@end(comment)

@paragraph(Executives and the Exec Server)
@index(executives)
@index(exec server)

While the workstation agent provides the low-level I/O interface for the
user, the executive provides the command processing interface.  It
corresponds to the Unix shell or the Tops-20 Exec, in that it is a
user-level process providing command parsing and convenient access to system
services.  The basic operation of the executive is documented fully
in Chapter @ref(UsingExec). 

All instances of the executive on a workstation are managed by the @i(exec
server)@index(exec server).  Its purpose is to allow sharing of code and
data (such as aliases) among all executives.

@subsection(Global Servers)
@index(global servers)

A @i[global] server is distinguished by the fact that it is designed to
service requests from any workstation, not just from processes running on
the workstation on which it happens to be running.  

@paragraph(Authentication Server)
@index(authentication server)

The authentication server provides the basic mechanisms by which users log in
to the V-System and by which security is maintained.  

@paragraph(Storage Server)
@index(storage server)
@index(memory server)
@index(RAM disk)

Storage servers generally provide for long-term information storage.  They
typically run on workstations will large disks attached, or on
V@c(ax)/@c(UNIX) systems.  Each host may support at most one storage server.
A ``RAM disk'' facility is also provided, in the form of the @i(memory
server).  

@paragraph(Internet Servers)

Internet servers provide for network communications using standard
(inter)net protocols, as compared to the inter-kernel protocol implemented
by the V kernel.  They are essentially protocol converters that allow
applications that communicate by means of the V I/O protocol to communicate
with hosts that can only (or prefer to) be reached by a protocol other than
the inter-kernel protocol.

@section(The System in Operation)

Having summarized the functions of each of the major servers in isolation,
we now describe some of the ways in which these servers interact.  The
intent is not only to help the reader understand the basic structure of the
system, but also to understand some basic techniques for multi-process
structuring.

@subSection(System Initialization)
@index(initialization)

When a workstation is booted, its @c[PROM] loads a program that loads the V
kernel and the @i(first team).@index(First Team) After the kernel has
completed its internal initialization, it creates an initial team space and
an initial bootstrap process on this team, and assigns the processor to this
process.  The bootstrap process starts all the servers necessary to run the
system on the workstation:  the exception server, the team server, the exec
server, and some version of a workstation agent.    All but the last are
always loaded together on the first team, and thus share a single address
space; the workstation agent may or may not be loaded on the first team, at
the discretion of the user.  The advantage of placing it on its own team is
that then it may be replaced dynamically using the @t[newterm] command.  

@subsection(Loading a Team)
@label(Loading a Team)
@index(loading)

Teams other than the first can be loaded from object code files using
routines in the V C program library.@index(Team Loading) These routines
package an appropriate request to the team server and take care of matters
such as initializing the team's data space as discussed in
Section @ref(Program Initialization).  The detailed message traffic
involved is illustrated in Figure @ref(FigLoad):  In its request to the team
server (edge 1), a client includes an open file descriptor specifying the
file to be loaded.  This descriptor references the storage server that
manages the file (edge 2) and from which the file will be loaded.  After
receiving the request, the team server requests the kernel server to create
a new team with initial process (edges 3 and 4).  Like all processes, it is
created in the @i(awaiting reply) state@index(awaiting reply) @ld() waiting
for a reply from its creator.  In effect, the kernel simulates a @t[Send()]
from the process to the team server (edge 5).  The team server forwards
this message, and its associated privileges (including access to the entire
address space of the new team), to the client that originally asked for the
team to be loaded (edge 6).  At this point, the client (or the library
routine it called) can initialize the team's environment variables and the
like,  and then @t[Reply()] (edge 7), thus allowing the new team to begin
execution @ld() all as discussed in Section @ref(Program Initialization).
@Begin(Figure)
@PressPicture( Height = "6.75 Inches", File = "loadteam.fig" )
@Caption(Loading a team.)
@Tag(FigLOAD)
@End(Figure)

@subsection(Team Termination and Exit Status)
@index(termination)
@index(exit)

Barring catastrophic failures, the @t[@uf()start] routine loaded with every
team will ensure that the team's owner is always notified of the termination
of the team @ld() by sending it an appropriate message.  If the team
terminated gracefully @ld() by calling @t[exit()] or returning from
@t[main()] with a valid exit status @ld() the owner will be able to
ascertain the team's exit status.  

@subsection(Command Processing)
@index(command processing)

Prior to running an application, the executive must determine what program
is to be run!  It does so by parsing the command line returned in response
to its request for line-edited input from the workstation agent.  The
executive then opens the file that contains the program (edge 2 in Figure
 @ref(FigLoad)), and any other files as necessary to handle redirected I/O.
Finally, it invokes the procedure discussed in Section @ref(Loading a Team)
above.

Unless the program is being run in the background, the executive waits for
it to complete execution by waiting for a message from it.
@Foot(Programs running in the background@index(Background Processes)
have the team server as their
@i[owner].  Then, if the executive that started them is deleted by the user,
which usually results in the destruction of any program it owns, the
background program will continue execution.)  If the team terminates by
calling @t[exit()] or returning from @t[main()], the executive will indeed
receive a message from it containing the team's exit status.  Otherwise, the
team will have died abnormally, in which case the executive will awakened
by the kernel and informed of that fact.  At this point, it is ready to ask
for the next command line.

@subsection(Exception Handling)
@index(exception handling)

As described above, the team server uses only the services of the kernel and
a storage server.  However, the team server is also the principal client of
the exception server.  Figure @ref(FigEXTE) illustrates the message flow
involved:  The team server creates the team to begin with (edges 1 and 2) as
described above.  It then registers itself as the exception handler
@index(exception handler) for the team (edge 3).
If a process on the team incurs an exception, the kernel simulates the
effect of the offending process sending an exception message to the
exception server (edge 4), which forwards the message to the team server
(edge 5).
The team server then uses its own facilities to load the V debugger (edge 6),
and forwards the exception message to it (edge 7).
@Begin(Figure)
@PressPicture( Height = "4.0 Inches", File = "excepteam.fig" )
@Caption(Handling an exception.)
@Tag(FigEXTE)
@End(Figure)

Upon receipt of the message, the debugger prints the exception data on the
screen and registers itself as the (new) exception handler for the offending
team.  It then handles user commands, one of which may cause the team to be
``resumed'', in which case the debugger simply replies to the original
exception message, freeing the team to continue execution until it either
gets another exception or terminates normally.  The next exception, if any,
will of course be handled by the debugger.

@begin(note)
If a process other than the team server had registered interest
in the offending process before it incurred an exception, the exception
message would have been forwarded directly to the registered exception 
handler.  The handler can then take any action it deems appropriate,
including loading the debugger as discussed above.
@end(note)

@section(Summary)

One of the principles guiding the V-System design has been to place as many
the usual operating system functions outside the kernel as efficiency
permits.  Moreover, functions have been partitioned as far as practical into
separate servers.  Consequently, the kernel and each server have been kept
reasonably small and independent of each other, which has in turn simplified
debugging, maintenance, and experimentation with new servers.


