@part( naming, root "manual" )
@chapter(The V-System Naming Protocol)@index(Naming Protocol)
@label(NamingProtocol)

A number of V-System services use character string names to specify the
objects to be operated on, and many standard message types include space for
such a name.
Examples include
the CREATE@us()INSTANCE request and several other requests
described above as part of the I/O
Protocol.

Name mapping in the V-System is decentralized,
being performed by a collection of cooperating server processes
rather than a single,
monolithic ``name server.''
The @i[V-System Naming Protocol]
consists of a uniform format for request messages 
that contain high-level names,
a method for locating the server that implements any given named
object, and a small set of request types that
must be handled specially by any server that implements the protocol.

In this chapter, we describe the naming protocol in detail and give
implementation hints for servers that use it.
Refer to Chapter @ref(naming) for a description of the
naming library routines available to client programs.

@section(Overview)

Conceptually, the V-System naming facility is a system-wide global directory
providing reference by high-level (character-string) name
to objects implemented by multiple object managers (servers).
The global directory contains a
(name, object)-tuple for each binding of global name to
object.@foot{Note that high-level names are bound directly to objects, not
to low-level names (such as globally unique numeric identifiers).
Our design views high-level names as the only permanent,
globally unique identifiers for objects.}
Each client may also have its own directory of bindings from local names (or
@i{aliases}) to global names.
The naming facility provides operations for
@begin{itemize}
Binding names to objects

Removing name bindings

Name mapping: finding objects bound to a given name

Inverse name mapping: finding the name bound to a given object
@end{itemize}

In the decentralized V naming facility,
the global directory is distributed across the object managers such that
each object manager stores and maintains that portion of the directory
corresponding to the objects it implements.
Each client program maintains a cache of bindings from name to object manager,
as illustrated in Figure @ref{basicmodel}.
@begin{figure}
@presspicture{file="cliserv.fig", height=4.2in}
@caption{Decentralized Global Directory}
@tag{basicmodel}
@end{figure}
When a client invokes an operation using a high-level object name,
the client checks its cache for an entry that maps the name to an
object manager.
If a cache entry for the name is found
(as is the case with @i{name2} in Figure @ref{basicmodel}),
the operation and name
are then sent to the object manager indicated by the cache
entry.
Otherwise, a query is multicast to the object managers to determine
the correct object manager for the named object
(as is the case for @i{name1} in Figure @ref{basicmodel}).
If an object manager responds, a cache entry is created and the processing
of the request proceeds as before, with the operation being sent to
the responding object manager.
Otherwise, the specified object name is assumed to be invalid
and an error indication is returned to the client.

Inverse name mapping is simply a lookup in
the global directory using an object's low-level identifier
(for example, its instance identifier) in place of its high-level name.
We assume that the low-level identifier provides enough information
to determine which manager implements the object in question,
and hence which manager stores the portion of the global directory
containing its name.
The same (absolute) global name is returned for a given object
even if the client originally accessed the object using
a local name, alias, etc.
Low level identifiers are not standardized across all object types,
so the inverse name mapping operators provided are type-specific.

@section(Character String Names)
Syntactically, a
character string name (@i[CSname])@index(CSname)
is a sequence of zero or more bytes, of
a specified length or else terminated by a null byte.
Operationally, a character string name is a byte string as above that is
used to specify an object relative to a server that can interpret
the name.
There is no universal limit on the length of character string names.
Two CSnames are equal if and only if they are byte-wise identical
and equal in length (where a null in the name takes precedence
over the length specification).

Although CSnames may contain arbitrary bytes, they
are generally specified or chosen by the client
(as opposed to the server) and are usually human-readable
ASCII strings.

The term @i[character string name handling server
(CSNH server)]@index(CSNH server)
refers to any server that performs
character string name mapping, regardless of what else it does.
The term @i[CSname request] describes any request
containing a character string name that must be mapped in order to perform
the requested operation.

@section(Contexts and Context Ids)
@index(Context)@label(ContextIds)
The V-System name space is hierarchically structured,
and we refer to each internal node of the naming hierarchy as a
@i{context}
Names are @i{pathnames} in that they describe a path through the
hierarchy, beginning at (i.e., @i{relative} to) some specific context.
Absolute names are those that begin at the root context.

The global directory is divided among object managers
using a technique we call @i{vertical partitioning}.
Each object manager implements a tree of
contexts starting @i{at the root} of the complete name hierarchy,
thus storing the absolute names of the objects it implements.
Some contexts (the root in particular) are implemented by
multiple object managers.  Such @i{multi-manager} contexts are
partitioned across the managers that participate in their implementation.
Each participating manager stores only that subset
of the context needed to name objects it manages.

A context can be referenced by its absolute name, or by its
@i{context identifier}:
a compact low-level identifier that is
effectively a pointer into the name space,
providing direct, efficient access to the object manager(s)
implementing the context.
Referencing an object using a context identifier plus relative name
allows the name lookup to start at the identified context
rather than from the global root,
thereby reducing the need for multicast
and reducing the length of the name that must be looked up by the object
managers.

In V, a context identifier is structured as
a (@i{manager-id}, @i{specific-context-id}) pair,
where the @i{manager-id}
is a process identifier or process group identifier
specifying the object manager(s) that implement
the context, and the @i{specific-context-id}
is mapped by the identified manager(s) to one of the contexts
they implement.
The standard system header file <Venviron.h>
defines the types @t[ProcessId],
@t[ContextId] (corresponding to @i{specific-context-id}),
and @t[ContextPair], for these identifiers.

When a context is renamed, its old context identifier
becomes invalid and another is assigned.
Thus, in effect, a context identifier is bound to a context @i{name},
not to the context object itself.

Context identifiers are considered @i{hints}.
That is, a context identifier is allowed to become invalid
even if the corresponding character-string name is still bound to
the same context.
For example, if a V object manager crashes and is restarted under
a different process identifier, all its old context identifiers
become invalid (since they contain the manager's process identifier
as a subfield), even if all the objects it manages are recovered.

@section(Prefix Caching)

The client naming library maintains a @i[prefix cache]
mapping from name prefixes to context identifiers,
Before sending off any CSname request, the @t[NameSend()]
library routine finds the longest name prefix that can be
matched in the cache.
(If the matched prefix maps to a multi-manager context,
@t[NameSend()] issues a QUERY@us()NAME request (see below) to
obtain a longer prefix.)
The matched prefix is then stripped off, and the resulting
relative name is sent off together with the context
identifier to which the prefix mapped.
If the request fails because the stored context identifier was
invalid, @t[NameSend()] removes the offending cache entry and
retries the request, continuing until the request succeeds or
the name is known to be invalid.

The naming library also caches the context identifier
of each client process's current context (``working directory'').
The context's absolute name is also stored, allowing
@t[NameSend()] to recover if its context identifier becomes invalid.

@section(Static Context Identifiers)

Static context identifiers are defined for a few
of the most commonly used multi-manager contexts.
For each identifier, the specific-context-id portion is
defined in <Vnaming.h>
and the manager-id portion is defined in <Vgroupids.h>.
Static specific context ids are small non-negative integers, less
than the manifest constant MAX@us()WELL@us()KNOWN@us()CONTEXTS.

In principle these identifiers need only be known to servers.
To improve performance, however,
several of the identifiers and corresponding
name prefixes are preloaded into client caches by the @t[PrimeCache()]
library routine.

The following static (or @i[well-known]) context identifiers
are defined at this writing.
@begin(description)
(VCSNH@us()SERVER@us()GROUP, GLOBAL@us()ROOT@us()CONTEXT)@\Corresponds
to the CSname ``[''.

(VTEAM@us()SERVER@us()GROUP, TEAM@us()SERVER@us()CONTEXT)@\Corresponds
to the CSname ``[team]''.

(VSTORAGE@us()SERVER@us()GROUP, STORAGE@us()SERVER@us()CONTEXT)@\Corresponds
to the CSname ``[storage]''.

(VTIMER@us()SERVER@us()GROUP, TIME@us()SERVER@us()CONTEXT)@\Currently
not used for naming.

(VAUTH@us()SERVER@us()GROUP, AUTH@us()SERVER@us()CONTEXT)@\Currently not
used for naming.

(VEXCEPTION@us()SERVER@us()GROUP, 
EXCEPTION@us()SERVER@us()CONTEXT)@\Currently unused.

(VDEVICE@us()SERVER@us()GROUP, DEVICE@us()SERVER@us()CONTEXT)@\Currently
unused.

(VINTERNET@us()SERVER@us()GROUP, INTERNET@us()SERVER@us()CONTEXT)@\Currently
unused.

(VPRINT@us()SERVER@us()GROUP, PRINT@us()SERVER@us()CONTEXT)@\Currently
unused.

(VVGT@us()SERVER@us()GROUP, VGT@us()SERVER@us()CONTEXT)@\Currently unused.

(VPIPE@us()SERVER@us()GROUP, PIPE@us()SERVER@us()CONTEXT)@\Currently unused.

(VEXEC@us()SERVER@us()GROUP, EXEC@us()SERVER@us()CONTEXT)@\Currently unused.

(VTEST@us()SERVER@us()GROUP, TEST@us()SERVER@us()CONTEXT)@\Reserved.

DEFAULT@us()CONTEXT@\Conventionally used for the local root context
by many servers that implement a single tree of single-manager 
contexts.  The name is an anachronism, left over from a previous
version of the naming protocol.@index(Default Context)

(VSTORAGE@us()SERVER@us()GROUP, PUBLIC@us()CONTEXT)@\Holds
publically-available V programs on storage servers.@index(Public Context)
Corresponds to the CSname @i{[sys]}.
@end(description)

@section(Generic Names and Group Names)

A @i{group name} is a name that refers to a
group (i.e., set) of objects, which need not all be implemented
by the same server.
A @i{generic name} refers to one member selected from
such a group according to a rule
associated with the name.
The simplest (and most commonly used) rule is to select one member
arbitrarily.

The naming protocol supports generic and group naming by permitting
more than one server to respond to a CSname request.
In general,
the client issuing the name request determines whether the CSname is to be
interpreted as a group name or generic name by receiving and processing all
the responses (group name), or only the first (generic name with
arbitrary selection).
Selecting the first response has the pleasant side effect
of favoring the most lightly-loaded server.

Servers can also define generic or group names for contexts.
In this case
the servers determine whether the name can be used as a group name, or only
as a generic name.
Issuing a @t(GetContextId) request on a group name for a
set of contexts must return a @t(ContextPair) that refers to @i[all] the
contexts.@foot{Multi-manager contexts follow this rule, with the context
name viewed as a group name for the set of partitions held by the
participating servers.}
Subsequent name lookups that find the given prefix in the cache
and substitute the returned context identifier will then correctly refer to
all members of the set.
In contrast, each response to a
@t[GetContextId] on a generic name for the same set of contexts
may return an identifier for just one server's member(s) of the set.
Subsequent name lookups that find this prefix in the cache
will then map it to the identifier that was returned in the first response.

@section(Name Request Format)

All V-System request messages that contain CSnames are built on a common
skeleton, defined as the NameRequest structure
in the standard header file <Vnaming.h>.@index(Name Request)

@Hbar(2 inches)
@begin(description)
requestcode@\Any valid request code that grants read access to a segment.

nameindex@\The byte offset of the name, within the segment specified
by the last two long words of the message.

unspecified@\Request-specific information.

namecontextid@\A 32-bit identifier for the context in which this name is to be
interpreted.

nameptr@\Pointer to the segment containing the symbolic name.

namelength@\Length of the segment containing the name.
@end(Description)
@Hbar(2 inches)

The reply is not specified by this protocol because it is generally
dependent on the operation requested.

The name need not be first in the segment but is considered
to start at the byte offset specified by @i[nameindex].
If the name is not last in the segment, it must be terminated
by a null.

The CSname request format includes only the specific-context-id field of the
@t[ContextPair] for the context in which the name is to be interpreted.
The manager-id portion is implicitly specified by sending the request
to the appropriate manager or group.

@section(Name Lookup Algorithm)
@label(LookupAlgorithm)

A server receiving a NameRequest performs the following algorithm
to look up the name.
@begin(enumerate)
Set @t[CurrentNode] to the context specified by the namecontextid.
If the context identifier is not recognized, fail with status
INVALID@us()CONTEXT@us()ID.  Go to step @ref(fail).

While the name still has unmapped components, do
@begin(itemize)
Attempt to map the next component of the name, relative to @t[CurrentNode].
@begin(itemize)
If the name component
is not defined locally, but @t[CurrentNode] is a multi-manager context,
fail with status NOT@us()HERE.  Go to step @ref(fail).

If the name component
is not defined, and @t[CurrentNode] is not a multi-manager context,
fail with status NOT@us()FOUND.  (We know the name cannot be defined by any
other server.)
Go to step @ref(fail).

If the name component is an upward reference (``..''), and
the context @t[C] to which it refers is a multi-manager context implemented
by a different (larger) group than @t[CurrentNode],
advance @i[nameindex] to the next component following the upward reference,
set @i[namecontextid] to @t[C.cid], and @t[Forward] the request
to @t[C.pid].  Done.

Otherwise, the name component is defined.
Set @t[CurrentNode] to the object it maps to and repeat.
@end(itemize)
@end(itemize)

The entire name has been mapped, and
@t[CurrentNode] is the named object.  Done.

Fail.@tag(fail)
@begin(itemize)
If the failure status was NOT@us()FOUND, and the request is of a type that
permits automatic creation of an object in this case (for example,
CREATE@us()INSTANCE in FCREATE mode on a file storage server),
the object may be created at this
point.  Its name will be the remaining unmapped portion of the given name,
defined relative to the context @t[CurrentNode].

If the request was multicast and the failure status was other than
NOT@us()FOUND,
do not reply (that is, invoke @t[Reply()] with
replycode DISCARD@us()REPLY),
since another server in the multicast group
may have succeeded in processing it.

Otherwise, the request was unicast.  Reply with the failure status.
@end(itemize)
@end(enumerate)

@section(Standard CSNH Server Requests)

There are several standard CSNH requests that must be implemented by all
CSNH servers, plus a few optional ones.  All of the request and reply
formats described below are subsets of the ContextRequest structure defined
in the standard system header file <Vnaming.h>.@index(Context Request)

@subsection(QUERY NAME)@index(Query Name)
@Hbar(2 inches)
@begin(description)
requestcode@\QUERY@us()NAME

nameindex@\The byte offset of the name relative to @i[nameptr].

namecontextid@\Context in which to interpret the given name.

nameptr@\Pointer to the segment containing the symbolic name.

namelength@\Length of the segment containing the name.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

nameindex@\Advanced to indicate the context
prefix recognized by the responding server.

context@\A @t[ContextPair] for the recognized context prefix.
@end(description)
@Hbar(2 inches)

Query a name to get information that can be cached, typically to avoid
multicast when mapping the name in the future.
Implementation required of all CSNH servers.

The query returns the shortest prefix of the given name that specifies a
single-manager context, together with a context identifier for that context.
If no prefix of the name specifies a valid single-manager context,
but the entire name specifies a valid multi-manager context,
the entire name is returned together with a context identifier for that
context.
Otherwise, the query fails.
A failing query returns KERNEL@us()TIMEOUT if multicast,
or a more specific error code if unicast.
(Multicast is the normal case.)

A server receiving this request performs
a variant of the general name-mapping algorithm, as follows.
@begin(enumerate)
Set @t[CurrentNode] to the context specified by the namecontextid.
If the context identifier is not recognized, fail with status
INVALID@us()CONTEXT@us()ID.  Go to step @ref(fail2).

While @t[CurrentNode] is a multi-manager context 
participated in by this server, do
@begin(itemize)
Attempt to map the next component of the name, relative to @t[CurrentNode].
@begin(itemize)
If the name has no more components, go to step @ref(succeed).

If the name component
is not defined locally, fail with status NOT@us()HERE.  Go to step
@ref(fail2).

If the name component is defined, set @t[CurrentNode] to the object 
it maps to and repeat.@foot{Exception: upward references are handled as
described in section @ref(LookupAlgorithm)}
@end(itemize)
@end(itemize)

Succeed.@tag(succeed)  
In the reply, set @i[nameindex] to point to to the first
component of the name that was not mapped, or if the entire name
was mapped, to just beyond the last character of the name
(i.e., to the terminating null byte if there is one).
Set @i[context] to the context identifier of @t[CurrentNode].  Done.

Fail.@tag(fail2)
If the request was multicast,
do not reply (that is, invoke @t[Reply()] with
replycode DISCARD@us()REPLY),
since another server in the multicast group
may have succeeded in processing it.
If the request was unicast, reply with the failure status.
@end(enumerate)

@subsection(GET ABSOLUTE NAME)@index(Get Absolute Name)
@Hbar(2 inches)
@begin(description)
requestcode@\GET@us()ABSOLUTE@us()NAME

nameindex@\The byte offset of the name relative to @i[nameptr].

namecontextid@\Context in which to interpret the given name.

nameptr@\Pointer to a buffer containing a symbolic name, and
in which the absolute name is to be returned.

namelength@\Size of the buffer.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

context@\If the given name specified an existing context, a
@t[ContextPair] identifying it is returned in this field.

nameptr@\The value provided is returned unchanged.

namelength@\Length of the returned name.
@end(description)
@Hbar(2 inches)

Returns an absolute CSname for the object whose (relative)
CSname is given.
The returned name overwrites the given name.
If the name was not bound to a context,
@i[context.pid] is set to 0 in the reply.
Implementation required of all CSNH servers.

A server receiving this request performs a slight variant of
the general name-lookup algorithm.
The named object need not exist, as long 
as it is clear what its absolute name would be if it were created.
If the lookup fails with status NOT@us()FOUND,
but it would be possible to create an object with the given name,
the server constructs an absolute name by appending
the undefined name suffix to the absolute name for the last
@t[CurrentNode] reached.

@subsection(GET CONTEXT ID)@index(Get Context Id)
@Hbar(2 inches)
@begin(description)
requestcode@\GET@us()CONTEXT@us()ID

nameindex@\The byte offset of the name, within the segment specified
by the last two long words of the message.

namecontextid@\Context in which to interpret the given name.

nameptr@\Pointer to the segment containing the symbolic name.

namelength@\Length of the segment containing the name.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

context@\A @t[ContextPair] identifying the named context.
@end(description)
@Hbar(2 inches)

Given a CSname that names a context,
this request returns a (serverpid, contextid) pair that
identifies the same context.  
Implementation required of all CSNH servers.

@subsection(GET CONTEXT NAME)@index(Get Context Name)
@Hbar(2 inches)
@begin(description)
requestcode@\GET@us()CONTEXT@us()NAME

context@\The @t[ContextPair] for which a name is to be found.

nameptr@\Pointer to a buffer in which the name is to be
returned.

namelength@\Size of the buffer.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

nameptr@\The value provided is returned unchanged.

namelength@\Length of the returned name.
@end(description)
@Hbar(2 inches)

Inverse name-mapping for context identifiers.
Provides a subset of the functionality of
GET@us()ABSOLUTE@us()NAME.  Implementation recommended for all CSNH servers.

Returns an absolute CSname for the context corresponding to
the specified context identifier, if the context
identifier is valid and known to the server receiving the request.
This request should be sent to the process or group identified
by the @i[pid] component of the @t[ContextPair].

@subsection(GET FILE NAME)@index(Get File Name)
@Hbar(2 inches)
@begin(description)
requestcode@\GET@us()FILE@us()NAME

instanceid@\A file instance id for the file whose name is desired.

nameptr@\Pointer to a buffer in which the name is to be returned.

namelength@\Size of the buffer.

@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

nameptr@\The value provided is returned unchanged.

namelength@\Length of the returned name.
@end(description)
@Hbar(2 inches)

Inverse name-mapping for instance identifiers.
Returns an absolute CSname for the file associated with
the specified file instance.
Implementation recommended for all CSNH servers.

@subsection(RENAME OBJECT)@index(Rename Object)@index(Rename File)
@Hbar(2 inches)
@begin(description)
requestcode@\RENAME@us()OBJECT

nameindex@\The byte offset of the old name relative to nameptr.

namecontextid@\Context in which to interpret the old name.

nameptr@\Pointer to the segment containing the old and new names.

namelength@\Length of the segment containing the names.
@end(description)
@Hbar(2 inches)
@begin(description)
replycode@\Standard system reply code.

context@\A @t[ContextPair] identifying the named context.
@end(description)
@Hbar(2 inches)

Given a CSname for an existing object,
this request binds a new name to the object
and removes the binding of the existing name.
Implementation is optional.

The new name must be absolute.
(The initial ``['' character is omitted.)
It follows the old name in the segment,
separated by a single null byte.
The request fails, returning ILLEGAL@us()NAME,
if the new name is in a portion of the name
space not implemented by the object's current manager, and
that manager is unable or unwilling to expand its name space as required.

@section(Context Directories and Object Descriptors)
@label(ContextDirectories)
@index(Context Directories)
@index(Object Descriptors)
An important aspect of system operation is supporting query
operations about objects or sets of objects.
A simple example is that of listing the names of all objects in a given
context.
In general, one may wish to list a variety of information about objects
in a context, perhaps ignoring some of the objects based on their properties.

Each CSNH server implements a @i[context directory] for each
context that it manages.
A context directory appears as a file of records,
with each record describing an object in the associated context.
A directory file is accessed using the I/O protocol with the
CREATE@us()INSTANCE request specifying the name of the context to be used.
The FDIRECTORY bit is set in the mode field of such a request.
A client can then use the standard I/O routines to read the contents of
the directory and derive the information required.
The selection of the information required is done by the client,
not the server.
The client may also be able to modify some or all of the fields of a
directory record by writing it, using the standard I/O protocol.  A server
is not obliged to make all fields presented in a directory modifiable.
If a client attempts to change a non-modifiable field, that field is
left unaltered, but any other changes indicated in the request are
carried out.

The FDIRECTORY bit is primarily for the benefit of Verex-like
file systems, which permit each node in the naming 
hierarchy to be (in UNIX terms)
both a file and a directory.  
It discriminates between access to the data content of such a node, and the
context directory associated with it.

Each record in a directory starts with a @i[descriptor-type] field that
specifies the format of the record describing the object.
For space economy, this field is an identifier that specifies a
description of the record format stored elsewhere in a system database
of such formats.  (The standard formats and descriptor type identifiers are
defined in the header file <Vdirectory.h>.)
Applications can read a directory and extract the required information
by referring to the descriptor-type field and these format descriptions,
even when a directory contains heterogeneous records.

A similar query activity involves accessing the descriptor of a single
object.
For efficiency and consistency,
this is supported by a separate NREAD@us()DESCRIPTOR function on the object
(as opposed to being subsumed by the context directory facility),
which returns the same record as found in the context directory.
A corresponding NWRITE@us()DESCRIPTOR operation is
available for modifying an object's descriptor.

A server need not store information about
objects as it is presented in a context directory.
For instance, the UNIX file system stores the names of files
separate from their descriptors with the association provided by
so-called ``i-node numbers.''
A context directory entry in this case is fabricated dynamically
by replacing the i-node number in each record by its
descriptor.

The standard descriptor reading and writing operations are described below.
The message formats used are described by the DescriptorRequest and
DescriptorReply structures defined in <Vdirectory.h>.

@subsection(READ DESCRIPTOR and NREAD DESCRIPTOR)
@index(Read Descriptor)@index(NRead Descriptor)
@Hbar(2 inches)
@begin(description)
requestcode@\NREAD@us()DESCRIPTOR

nameindex@\The byte offset of the name relative to @i[segmentptr].

dataindex@\The byte offset from the start of the
specified segment where the returned descriptor is to be placed.

namecontextid@\The context id of the context
in which the given name is to be interpreted.

segmentptr@\Pointer to a buffer that contains the object name
and in which the descriptor is to be returned.

segmentlen@\Length of the buffer.
@end(description)
@Hbar(2 inches)
@begin(description)
requestcode@\READ@us()DESCRIPTOR

fileid@\File instance id of the object whose descriptor is to be read.

dataindex@\The byte offset from the start of the specified segment where the returned
descriptor is to be placed.

segmentptr@\Pointer to a buffer in which the descriptor is to be returned.

segmentlen@\Length of the buffer.

@end(description)
@Hbar(2 inches)
@begin(description)

replycode@\Standard system reply code.

@end(description)
@Hbar(2 inches)

These request types provide a way of reading the descriptor (context
directory entry) of a single object.  READ@us()DESCRIPTOR specifies the
object by file instance id, while NREAD@us()DESCRIPTOR specifies it by
CSname.
Implementation of both is recommended for all CSNH servers.

@subsection(WRITE DESCRIPTOR and NWRITE DESCRIPTOR)
@index(Write Descriptor)@index(NWrite Descriptor)
@Hbar(2 inches)
@begin(description)
requestcode@\NWRITE@us()DESCRIPTOR

nameindex@\The byte offset of the name relative to @i[segmentptr].

dataindex@\The byte offset from the start of the specified segment where the
new descriptor value begins.

namecontextid@\The context id of the context in which the given name 
is to be interpreted.

segmentptr@\Pointer to a buffer that contains the object name
and the new descriptor value.

segmentlen@\Length of the buffer.

@end(description)
@Hbar(2 inches)
@begin(description)
requestcode@\WRITE@us()DESCRIPTOR

fileid@\File instance id of the file whose descriptor is to be modified.

dataindex@\The byte offset from the start of the specified segment where the
new descriptor value begins.

segmentptr@\Pointer to a buffer that contains
the new descriptor value.

segmentlen@\Length of the buffer.

@end(description)
@Hbar(2 inches)
@begin(description)

replycode@\Standard system reply code.

@end(description)
@Hbar(2 inches)

These request types provide a way of modifying the descriptor (context
directory entry) of a single object.  WRITE@us()DESCRIPTOR specifies the
object by file instance id, while NWRITE@us()DESCRIPTOR specifies it by
CSname.  The server will modify each field in the object's descriptor for
which the value written differs from the existing value, if the field is
client-modifiable and the new value is legal.  A client normally uses one of
these operations by
first reading the descriptor, then modifying the field(s) of interest, and
finally writing it back.

@subsection(Multi-Manager Context Directories)
@index(Multi-manager context directory)

A multi-manager context directory is implemented as multiple
context directory files, one per manager participating in the context.
To list a multi-manager context directory,
the client opens the context directory for each object manager
in the context and then merges the object entries into a single list.
Merging the lists entails
eliminating duplicates, since some objects
in the context may themselves be multi-manager contexts, and will thus
appear in several managers' directory files.
All the context directories for a context are
opened in parallel, using a multicast CREATE@us()INSTANCE request.
To compensate for the inherently
unreliable delivery of multicast messages and responses,
a followup message containing the list of managers from which replies were
received can be multicast to the object managers.
Only omitted object managers respond to the followup message.
For full reliability, additional followup messages can be transmitted
until no more replies are received.@index(Followup message)

The format of a followup message is as follows.
The message structure @t[CreateInstanceRequest], as defined
in <Vioprotocol.h>, is used.

@Hbar(2 inches)
@begin(description)
requestcode@\CREATE@us()INSTANCE@us()RETRY@index(Create Instance Retry)

filenameindex@\The byte offset of the start of the actual
CSname, relative to @i[filename].

type@*
unspecified@*
filemode@*
contextid@\Identical to the corresponding fields of the original 
CREATE@us()INSTANCE request (chapter @ref(IOprotocol)).

filename@\Address of a data segment beginning with an
array of process ids specifying the
managers that should not reply to the request, terminated by
a process id of 0.  The CSname appears later in the segment,
as specified by @i[filenameindex].

filenamelen@\Length of the segment.

@end(description)
@Hbar(2 inches)

The reply format is identical to that for CREATE@us()INSTANCE.

