@Part( exceptions, root "manual" )
@Chapter(Exception Server)


When a process incurs an exception,
it causes a trap which is fielded by the kernel.
The kernel effectively causes the process to send a message
to the exception server with the contents of the message describing
the exception incurred.
If there is no exception server,
the kernel prints an error message and
disables the faulting process
by causing it to send to itself, which permanently blocks the process.

The exception server checks to see if another exception handler
has registered
for this process or an ancestor.
If so, it forwards the message to the handler.
For ordinary programs, arrangements are made for
such messages to be passed on
to the V debugger.@index(Debugger)
The format of the exception request and
registration messages are defined in <Vexceptions.h>@index(Vexceptions.h).
The only request types supported
are EXCEPTION@us()REQUEST@index(Exception Request)
and REGISTER@us()HANDLER@index(Register Handler).
EXCEPTION@us()REQUEST messages should only
be generated by the kernel.
The REGISTER@us()HANDLER request code is used both for registering
and deregistering handlers.

If no process was registered, the exception server
prints a message on the screen indicating
the type of exception, the pid of the faulting process,
and the instruction, program counter and status register at the
time the exception occurred.
The exception server then destroys the faulting process,
thus preventing it from doing further harm.
Note: the program counter may have been incremented beyond the
actual instruction incurring the exception so it should not be
considered exact, although the error message routine
attempts to find the correct PC by searching for the opcode of the
instruction that was reported in the exception message.

The error printing routine used by the exception server
is available to other exception handlers as the library 
routine @t[StandardExceptionHandler].
