@Part( devices, root "manual" )
@Chapter(Device Server)@Label(devices)

The device server provides access to the
@Index[device server]
raw kernel-supported devices via the I/O protocol.
It is implemented directly by the kernel as a pseudo-process
as opposed to being a normal process like other system servers.
Consequently, it is always configured when the V kernel is used.
However, the device server behaves like
any other I/O server process as far as applications are concerned.

The device server appears as a single process that supports different
types of devices using the same I/O protocol.
Access to a device is established by sending a create instance request to
the pid returned by GetPid(DEVICE@us()SERVER, LOCAL@us()PID), or, if
using the standard name cache, by prefixing
the device name with the context name ``[device]'' in a create
instance request or Open() call.
@Index[device type]
Using the standard information returned by the create instance request,
the device can then be accessed using I/O protocol messages, either
directly or by means of the standard I/O library routines described
in chapter @ref(IO).
There are also some device-specific operations defined for some devices.
The currently supported devices are described below.

@Section(Ethernet)
@Index[Ethernet]
@Label[Ethernet]

The Ethernet interface is accessed by specifying a device name of the form
@t[enet]@p[ts], where @p[t] is replaced by the Ethernet type, either @i[3]
for 3 Mbit experimental Ethernet, or @i[10] for standard Ethernet, and
@p[s] is a suffix, which is null for the first Ethernet interface, @i[a]
for the second, @i[b] for the third, and so forth.
Currently only one Ethernet instance may exist at a time and only
one Ethernet interface is supported, and the name @i[ethernet] is defined
as an alias for either @i[enet3] or @i[enet10], whichever is present.

The standard header file
<Vethernet.h> defines Ethernet-specific information,
@Index[Vethernet.h]
including the Ethernet packet format
and various constants such as ENET@us()MAX@us()DATA, the maximum size
of the data portion of an Ethernet packet.

In a create instance request,
the filemode must be FCREATE.
The type of an Ethernet instance is always a readable, writeable,
variable block stream.

Read and write instance requests are standard except for
the Ethernet block format.
The Ethernet is only sensibly accessed as a block (or packet) device,
as opposed to a byte stream.
The Ethernet block format is exactly that expected by the
interface, namely, on the 3 Mbit Ethernet, one byte for
destination, one byte for source, two bytes for Ethernet packet type,
followed by some number of data bytes, and on the 10 Mbit Ethernet,
six bytes for destination, six bytes for source, two bytes for
packet type, followed by data bytes.
The number of bytes specified in a write and returned by a read
includes the destination, source and type bytes as well as the data bytes.

An Ethernet-specific QUERY@us()FILE request is supported that returns
the host number, the number of collisions, receiver overflows,
CRC errors, receiver synchronization errors, transmission timeouts detected,
and the number of valid packets received.
The host number should be used as the source address for every packet
transmitted.
The format for the request and reply messages is given by the
QueryEnetRequest struct defined in <Vethernet.h>.

@Section(Disk)
@Index[Disk]

The disk interface is accessed by specifying the device name @i(disk0) or
@i(disk1).  These names correspond to the first and second drives attached
to the interface, respectively.  Currently, only the Xylogics disk interface
is supported.

In a create instance request, the filemode must be FCREATE.  The type of
the disk instance is always readable, writeable, multi-block.

Upon "opening" a disk device, the disk driver reads the label off of the 
first sector to obtain disk-specific information (such as the number of
cylinders, number of heads, etc.).
The disk label must have previously been written to the disk using the
@i(diskdiag) program.  The format of a disk label is defined in 
"/V/kernel/m68k/disklabel.h".

Read and write instance requests are standard and allow a maximum of
DISK@us()MAX@us()BYTES (as defined in "/V/kernel/m68k/xyl.h", 
usually 64 kbytes)
bytes to be accessed.  The disk driver translates from a (block, byte count)
pair to a (cylinder, head, sector, sector count) tuple.

A disk-specific QUERY@us()FILE request is supported that returns device
access statistics (e.g., the average seek distance per I/O).
A MODIFY@us()FILE request allows these statistics to be modified (e.g.,
reset to zero).  The format for the QUERY@us()FILE reply message is given
by the QueryStorageReply struct defined in <Vstorage.h>.

@Section(Mouse: The Graphics Pointing Device)

The mouse is a graphics pointing device.
@Index[mouse]
It provides a means of indicating a coordinate position
plus signalling different states via its three buttons.
The device server provides access to the mouse through the I/O protocol,
thus viewing it as a file.

The mouse file appears as a 10-byte file divided into 3 major fields.
The first two bytes specify the mouse button positions,
the three buttons being the low-order three bits of the second byte.
A bit with value 0 indicates the button is up, otherwise down.
The next 4 bytes specify its current X coordinate.
The last 4 bytes specify its current Y coordinate.
The kernel updates this file according to the input from the device.
These fields are specified in <Vmouse.h> as @i[buttons],
@Index[Vmouse.h]
@i[xcoordinate] and @i[ycoordinate] with MBUTTON1, MBUTTON2
and MBUTTON3 specifying the button bit field assignments
in the @i[buttons] field.

A create instance request for a mouse specifies the name @i[mouse]
in the filename field.
Only one mouse and one instance of that mouse are currently
supported.
The @i[filemode] field of the create instance
request must be FCREATE.
The mouse file instance created is initialized to have X and Y coordinates
of 0.
It has type attributes READABLE, WRITEABLE, and FIXED@us()LENGTH.

Read and write requests must specify block 0 and a byte count of 10 bytes.
A read instance request returns 10 bytes specifying the current
state of the mouse ``file.''
A read instance request is queued until a change to the mouse file
occurs, providing no change has occurred since the last read request.
Thus, for instance, a mouse reader process that repeatedly reads
from the mouse and updates a cursor is suspended when the mouse
is not being moved and no button positions are changing.
Conversely, the read returns every time a change does occur.

A write instance operation changes the kernel-maintained
record of the mouse button positions and the X and Y coordinates
to that specified by the 10 bytes in the buffer.
Setting the mouse buttons in the kernel has no significant effect because
this record is updated to agree with the actual button positions on the
next input (or ``squeak'') received from the mouse.

There is no need to provide a query function that simply returns
the current mouse position because that should always
be stored outside the kernel.
That is, the application decides where the mouse is;
the kernel simply updates the position relative to the
absolute position specified.

The kernel does not provide any scaling of mouse movements.
That is left to the application.

@Section(Serial Line)
@Index[serial line]
The kernel device server provides access to raw serial lines through the serial
device.  Two serial lines are supported, but only one instance for each may
exist at a time.  

In a create instance request, the name @i[serial0] or @i[serial1] specifies
a serial line.  The @i[filemode] must be FCREATE.
The instance id returned is used for output;
the instance id + 1 is used for input. 
Parameters for the input instance can be obtained using QueryInstance.

Each serial line is a pair of streams, one readable and one 
writeable.
Characters read from each serial line are buffered in the kernel until a
process reads from the device, but the buffer is rather small, so a user who
is interested in input from a serial line should keep a process ``listening''
to it at all times.
The serial line device
does not provide any echoing of input characters, nor does it convert
input editing or conversion of
newline characters to a carriage return/line feed sequence on output.

The serial device drivers support QueryFile and ModifyFile operations
to allow changing such parameters as the data rate, bits per character,
and the state of the modem control outputs DTR and RTS.  The necessary
message structures and constants for these operations are defined in
the standard header file <Vserial.h>.  (At this
writing, the Query and Modify operations are not implemented in the Sun-1 
serial device driver.)

@Section(Console)
@Index[console]
The kernel console device is intended to provide a measure of hardware
independence to programs doing interactive 
character stream input and output.
The console device provides access to the console keyboard and display of the
workstation the kernel is running on, independent of the type of
workstation.  On workstations whose keyboards are connected to serial line
0, reading from the console device reads from serial line 0; on others, it
reads from the port to which the keyboard is connected.  Likewise, on
workstations with frame buffers, writing to the console device draws
characters on the frame buffer; for those without, writing to the console
sends output to serial line 0.
In cases where the console uses serial line 0, instances for serial line 0 and
the console may not both exist at the same time.

A create instance request must specify filemode FCREATE, and name @i[console].
The console device is a pair of streams, one readable and one writeable.
As with the serial line device, the instance id returned by a CreateInstance
is writeable, and that instance id + 1 is readable.
The parameters of the second instance can be
obtained using QueryInstance.
Both instances are marked INTERACTIVE, but SET@us()PROMPT and 
SET@us()BREAK@us()PROCESS are not supported.

Console device input is buffered in the same way as serial line input (see
above).  The console device does not provide any echoing or output
conversion, but it does make an effort to sound the workstation's beeper
when an ASCII BEL character is output.

The console device is automatically opened by the kernel upon creation
of the first team, and is ordinarily never closed.

@Section(Framebuffer)
@index(framebuffer)

There are device drivers available for 

@subsection(Sun framebuffers)
The current Sun (and Cadlinc) drivers allow one to enable and disable video
output through modify file requests.
The device may be opened and modified, or may be modified directly with a
NMODIFY@us()FILE request. The following routine turns the framebuffer off:
@begin(programexample)
#include <Vframebuffer.h>
FbOff()
  {
    ModifyFramebufferMsg *req;
    
    req.sysCode = NMODIFY_FILE;
    req.request = FB@us()OFF;
    req.nameindex = 0;
    req.nameptr = "[device]framebuffer";
    req.namelength = sizeof("[device]framebuffer");
    NameSend( &req );
  }
@end(programexample)

@subsection(MicroVax QVSS Framebuffer)
@index(QVSS)
Caution is advised when using this device driver. Opening the device
maps the QVSS frame buffer memory into one's address space. One cannot
directly access the framebuffer until the device has been opened. To find
where the framebuffer has been mapped, perform a QUERY@us()INSTANCE on the
file and look at the field @t[unspecified[0@]].
Once opened this driver allows
direct user access to QVSS device registers. The device is
made up of six sixteen bit (short) blocks referencing the first six
device registers.
More information can be found in the top secret DEC Engineering
specification @t[VCB01-KP]. @t[/V/kernel/vax/qvss.h] defines all of the useful
control bits.

The registers available are:
@begin(programexample)
0 Control Status
1 Cursor X position (not used by the V-System)
2 Mouse Position (x is low byte, y is high byte)
3 Spare
4 CRT controller address pointer
5 CRT data
@end(programexample)

@Section(Null Devices)
@index(null devices)
Two null devices are available, and are normally configured into all versions
of the V kernel.  The @i[nullin] device is a readable, 0-length file; it
thus returns
an end-of-file indication on every read attempt.  The @i[nullout] device
is an endless sink for output.

