@part(auth, root "manual")
@Chapter(Authentication and the Authentication Server)
@index(Authentication)@index(Authentication server)@index(authserver)
@label(authserver)

Since processes are the active entities in V,
the kernel associates each V process
with a particular user or account on whose behalf it is acting.
Each authorized user within a V
domain is assigned a unique @i[user number], and each V process bears
exactly one user number.@foot(Processes on the same team need not all
run under the same user number.)
A process runs with the privileges associated with
its user, and that user is considered responsible
for its actions.  An @i[authentication server] maintains a
database of information about each user, including
login name, personal name, encrypted password, user number, and 
preferred home directory.  The authentication server supports simple
queries on this database, which is keyed by user number and by login
name.  The authentication server will also set the user number of a
requesting process if the correct password for that user number is
presented in the request.

The V authentication service does not provide a very high level of security.
Its main purpose is to provide a sense of user identity to programs
that need to exhibit user-specific behavior, and to protect against
inadvertent mistakes.
Its design is grounded on the belief
that the benefits of increased security in a research system like V
are very quickly outweighed
by its cost in reduced performance and increased complexity.

@section(Authserver)

The authentication server itself is available as a program called
@t[authserver].
Starting the server with the @t[-d] flag turns on debug output.
The @t[-F] flag, followed by a filename, specifies a non-standard
authentication database file.

The V executive automatically starts up
an authentication server if none is running when a user attempts to log in.

@section(User Numbers)
In general, a
process running with user number @i[u] has control over other 
processes running as user @i[u], and over server-maintained
objects owned by user @i[u].
Certain special user numbers are exceptions to this rule, however.

A process running with the predefined user number SUPER@us()USER 
has total privilege to do anything that the kernel and servers
implement.  The authentication server runs as super-user.

Somewhat more restricted privileges are associated with the user number
SYSTEM@us()USER.  Server processes that need special permissions
to enable them to act on behalf of other processes, but do
not need the full SUPER@us()USER privilege level, run as SYSTEM@us()USER.  

User processes running on a workstation in
the ``not logged in'' state have user number UNKNOWN@us()USER.
The UNKNOWN@us()USER is somewhat more restricted than normal users,
since not all processes running as UNKNOWN@us()USER really belong
to the same person.  An unknown user on one machine is not
allowed to manipulate processes belonging to unknown users on other
machines.

When a process is created, it initially has the user number of
its parent.
The root process of each workstation's initial team is created
with user number SYSTEM@us()USER, allowing server
processes on the first team to run as SYSTEM@us()USER if desired.
User numbers can be queried with the @t[User()] kernel primitive
or changed with the @t[SetUserNumber()] kernel
primitive.

@section(Authentication Library Functions)

The following authentication functions are available in the
standard V library.

@function{SystemCode AddUser(name, passwd, fullname, home)
   char *name, *passwd, *fullname, *home;}@index(AddUser)

Add a new user with the given login name, password, full name, and
home directory.  
Returns OK if successful, else a standard system code
indicating the reason for failure.
The requesting process must be authenticated as
SUPER@us()USER.
Requires that an authentication server be running somewhere on the local
network.

@function{SystemCode Authenticate(name, passwd)
  char *name, *passwd;}@index(Authenticate)

Authenticate the calling process as the given user, specified
by login name.
Returns OK if successful, else a standard system code
indicating the reason for failure.
Requires that an authentication server be running somewhere on the local
network.

@function{SystemCode DeleteUser(name)
  char *name;}@index(DeleteUser)

Delete the user with the given login name from the authentication
database.
Returns OK if successful, else a standard system code
indicating the reason for failure.
The requesting process must be authenticated as
SUPER@us()USER.
Requires that an authentication server be running somewhere on the local
network.

@function{DestroyAuthRec(ar)
  AuthRec ar;}@index(DestroyAuthRec)
Free each string in the given AuthRec.

@function{char *FullUserName(pid)
  ProcessId pid;}@index(FullUserName)
Return the full name of the user associated with the given process
as a dynamically allocated string.
The string should be freed by the caller when no longer
needed, using @t[free].
Requires that an authentication server be running somewhere on the local
network.

@function{SystemCode MapUID(uid, ar)
  UID uid;  AuthRec *ar;}@index(MapUID)
Obtain an AuthRec containing the given user's authentication
database entry.
The user is specified by user number.
Returns OK if successful, else a standard system code
indicating the reason for failure.
Requires that an authentication server be running somewhere on the local
network.
Note: this function dynamically allocates several strings
to construct the AuthRec.
The caller should invoke @t[DestroyAuthRec(ar)] when the
AuthRec is no longer needed.


@function{SystemCode MapUserName(name, ar)
  char *name;  AuthRec *ar;}@index(MapUserName)
Obtain an AuthRec containing the given user's authentication
database entry.
The user is specified by login name.
Returns OK if successful, else a standard system code
indicating the reason for failure.
Requires that an authentication server be running somewhere on the local
network.
Note: this function dynamically allocates several strings
to construct the AuthRec.
The caller should invoke @t[DestroyAuthRec(ar)] when the
AuthRec is no longer needed.


@function{SystemCode ModifyUser(ar)
  AuthRec *ar;}@index(ModifyUser)
Modify the given user's authentication database entry to be
as specified by the given AuthRec.
The user is specified by the @t[uid] (user number) field of the AuthRec;
a user with the given number must exist.
Returns OK if successful, else a standard system code
indicating the reason for failure.
The calling process must be authenticated as the given
user or as superuser.
Requires that an authentication server be running somewhere on the local
network.

@function{SystemCode Password(name, passwd)
  char *name, *passwd;}@index(Password)
Check whether the given password is correct for the given user name.
Returns OK if so, else a standard system code
indicating the reason for failure.
Requires that an authentication server be running somewhere on the local
network.

@function{SystemCode SetUserNumber(pid, uid)
  ProcessId pid;  UID uid;}@index(SetUserNumber)
Set the given process's user number to the given value.
Returns OK if successful, else a standard system code
indicating the reason for failure.
The kernel places the following restrictions on setting
user numbers:
@begin(enumerate)
Any process can set its own user number to be UNKNOWN@us()USER.

Normal user processes are allowed to set the user numbers of 
descendents to match their own.  (This privilege is useful if
a parent process must change its user number after having created other
processes.)

A process running as SYSTEM@us()USER can set its own user number, or that
of any descendent, to match the user number of any process that is
awaiting reply from it.  (This privilege allows servers to create processes
that act on behalf of clients.)

The SUPER@us()USER can set any process's user number to any value.
@end(enumerate)

@function{UID User(pid)
  ProcessId pid;}@index(User)
Return the user number of the user associated with the given process.

@function{char *UserName(pid)
  ProcessId pid;}@index(UserName)
Return the login name of the user associated with the given process
as a dynamically allocated string.
The string can be freed by the caller_using @t[free()]_when no longer
needed.
Requires that an authentication server be running somewhere on the local
network.

@section(Adding a New User)

The following is the recommended procedure for adding a new V user.
See section @ref(auth-database) if you are installing V for the first time
and need to add many users in one session.

@begin(enumerate)
If you are using a UNIX host for file service, create a UNIX account
for the new user.

Under V, use the @t[su superuser] command to begin running as the V super-user.

@begin(multiple)
Run the V @t[password] program.
@begin(enumerate)
Click on the @i[user name] field, edit it to contain
the user's desired login name, and hit return.

Modify the @i[full name] field to contain the user's personal name,
in the same way.

Modify the @i[home] field to contain the V absolute pathname of the user's
home directory.

Click on @i[add], and enter the user's desired initial password.

Click on @i[exit], or repeat to add more users.
@end(enumerate)
@end(multiple)

Run @t[addcorr] and answer the prompts.
When it requests a password, type the user's UNIX 
password.@foot{The user can run @t[addcorr]
himself if you do not know his UNIX password.}
@end(enumerate)

@section(Authentication Database)@label(auth-database)@index(Vpassword)

There is one Vpassword file per network segment. For each user it contains a
username, usernumber, password (using the same format as Unix), full name,
and home directory. Each machine providing V fileservice needs a user
correspondence file, which lives in /etc/V. It maps between V user numbers
and the local Unix account name of the corresponding user.

The authentication server keeps its database in the
file @t{[sys]misc/Vpassword}.
This file should be made writeable only by the V super-user.
The file format is similar, but not identical, to the UNIX
password file.
You can convert your UNIX password file to a V password file
using the @i[awk] program provided in @t[/etc/V/Vpassword.awk].

The authentication server supports a simple form of 
password file replication.
The first few lines of each file copy should list the absolute names 
of the master and all slave copies of the password file, as follows:
@begin(programexample)
master:[storage/pescadero/usr/V/misc/Vpassword
slave:[storage/gregorio/usr/V/misc/Vpassword
slave:[storage/navajo/usr/V/misc/Vpassword
@end(programexample)
Whenever a new authentication server starts up, it reads
[sys]misc/Vpassword, which may come from any public Vserver.  When
modifications are made, it attempts to first modify the master file. If this
file is inaccessible, no password files are updated and the authserver
returns the standard reply code POWER_FAILER. If the master file is
correctly updated then as many slave sites as possible are also updated.

Changes made when the master site is unavailable are kept in the
authserver's in-memory database, so future updates may cause changes made
when the master file server is up at a later date. In general, users should
refrain from changing the authentication database when the master password
file is inaccessible. The design goal is to have a close-to-current password
file available if the master site is down when the authserver needs to be
restarted. Redundant distribution of the master password file should be
carried out to slave sites using @i[rdist] or similar tools on a regular
basis. We do it every night.

Each UNIX system that makes its files accessible from V maintains
a @i[correspondence table] mapping from V user numbers to UNIX
login names.
See section @ref{UserCorrespondences}
for more information about
correspondence tables. Another @i[awk] script, @t[/etc/V/Vusercorr.awk], is
provided to create this table.

