@string(LastEditDate="Thu May  1 15:39:21 1986")

@Part( VGTS, root "manual" )
@Chapter(User Interface Functions)
@label(User Interface Functions)
@Label(VGTSlibc)

@begin(comment)
In the V-System, all interaction between users and applications is mediated
by a @i(terminal agent)@index(terminal agent).  The Simple Terminal Server
(STS)@index(Simple Terminal Server) makes the workstation appear as a
traditional page-mode (character) terminal  similar to a VT-100.  The
Virtual Graphics Terminal Server (VGTS)@index(Virtual Graphics Terminal
Server) provides considerably greater functionality, including the support
of multiple virtual terminals or windows@index(virtual
terminal)@index(window).  In this case, each virtual terminal may be
identical to the page-mode terminal presented by the STS or it may provide
considerable graphics capabilities.@index(graphics)
@end(comment)

This chapter outlines the facilities available to programs for interacting
with the user  via the workstation agents.  The manner in which this
interaction is manifested to the user was discussed in Chapter @ref(User
Interface Overview).  Implementation details of the various workstation agents
may be found in Chapters @ref(Workstation Agents), @ref(VGTS), and @ref(STS).

The discussion here is broken down into two basic components: terminal
emulation and graphics.@index(terminal emulation)  The terminal emulation
facilities support ANSI virtual terminals and are common to all
configurations of the V-System  that is, to both the STS and the VGTS.
Indeed, virtually all applications use these facilities, in lieu of or in
addition to any graphics facilities they employ.  That is, each executive is
associated with a separate AVT and any application created by
that executive inherits access to the same AVT.

The graphics facilities are provided only by the VGTS.  Attempts to
use them in conjunction with the STS will fail.
@begin(warning)
Take special note of the ``warning'' in the Preface!
@end(warning)

@section(Virtual Terminal and View Management)
@begin(comment)
Common to all workstation agents is their use of @i(virtual terminals) to
abstract away the idiosyncrasies of the workstation hardware.  Indeed, for
good or ill, it is impossible for applications to "get at" the raw hardware.
Rather, applications must request input from a virtual keyboard or mouse and
must write output to a virtual store.  While the abstractions for keyboard
and mouse are common across (existing) workstation agents, the abstractions for
the store are quite different, as will be discussed in subsequent sections.

True to its name, a virtual terminal need have no physical, real-world
manifestation.  In particular, it is possible to write output to a virtual
terminal without seeing that output displayed on the screen.  In order to
actually see the output, the virtual terminal must be mapped to the screen
through a @i[view].@index(view)  A view defines the portion of the virtual
terminal's store that should be displayed and the area on the screen in
which it should be displayed.  Using traditional graphics terminology, the
portion of the store is referred to as the @i[window]@index(window) and the
area on the screen is referred to as the
 @i[viewport]@index(viewport).@foot(Unfortunately, traditional "window
system" terminology tends to use the word "window" to mean any or all of
window (as just defined), viewport, view, or virtual terminal.@index(window
system))  Viewports are invariably rectangular, although there is no
conceptual reason for this to be the case.  

Typically, an application will create one view of a virtual terminal at the
same time it creates the virtual terminal.  Indeed, this is the only thing
that makes sense when running with the Simple Terminal Server  there is
only one executive, which uses one virtual terminal, of which there can only
be one view.  Nevertheless, views are maintained as entities distinct from
virtual terminals because, in general, each virtual terminal may have more
than one view associated with it.  When using the VGTS, for example, the
same picture, maintained as one entity by the program, may appear in two
separate viewports on the screen, possibly with different viewing
parameters.  That is, a second view may look upon a different portion of the
virtual terminal's store from the first, or at a different magnification.

So, a virtual terminal many be associated with more than one view.  On the
other hand, because the virtual terminal is independent of its physical
manifestation, there need be no views associated with it.  Destruction of
all views does not in any way affect the virtual terminal, though it will
make it rather difficult for the user to see what is going on.

The customary policy in dealing with the VGTS is that views are the domain
of the user.  A program that creates a virtual terminal should create a view
of it, so that the user knows that it exists, but after that, in the
ordinary course of things, the program should leave the view alone.  Let the
user decide where on the screen he wants it to be, and how big, and with
what viewing magnification.  That is what the view manager is for.  

@subsection(Functions)
@end(comment)
Several routines for applications' manipulation of virtual terminals and
views follow.  All of these routines may be used with respect to any type of
virtual terminal, although some are more useful for one type of virtual
terminal than for other types.
The virtual terminal identifier, @t[vt], used in all routines is equal to
the value returned by @t[CreateVGT()] or to the @t[fileid] field of the file
descriptor returned by @t[OpenPad()] or @t[OpenAndPositionPad()].
These type-dependent routines, and
others, are presented in subsequent sections.

@function{int DeleteVGT(vt)
    short vt;}
Destroy the virtual terminal identified by @t[vt].@index(DeleteVGT)
All the views associated with the virtual terminal will also be destroyed.
@Begin(note)
Badly named, since it may be used with AVT's as well as SGVT's (a.k.a.
VGT's).
@End(note)

@function{int DefaultView(vt, width, height, wXmin, wYmin, 
	zoom, showGrid, pWidth, pHeight)
    short vt, width, height, wXmin, wYmin, zoom, showGrid;
    short *pWidth, *pHeight;}@index(DefaultView)
Create a view of the virtual terminal identified by @t[vt],
with the user determining
the position on the screen with the graphical input device (mouse).
The @t[width] and @t[height] parameters give the initial size
of the viewport if they are positive; non-positive values
indicate that the user should determine the size
with the mouse at run-time.  Note that these are physical device coordinates,
not @i[normalized] device coordinates.
@t[wXmin] and @t[wYmin] are the world coordinates to map to the left
and bottom edges of the viewport.  
If the
 @t[pWidth] and @t[pHeight] pointers are non-@c[NULL], then the shorts that
they point to receive the selected width and height.  Returns negative on
error.  See Chapter @ref(ViewManagerChapter) for more information about how
this call is manifested to the user.

@t[zoom] and @t[showGrid] are relevant
only to SGVT's.
@t[zoom] is the power of two
to multiply world coordinates to get screen coordinates; it may be negative,
to denote that a view is zoomed out.  If @t[showGrid] is non-zero a grid of
points every 16 pixels is displayed in the window.  
@begin(note)
In general,
this routine is not particularly well-suited to creating views of 
AVT's, as explained in the following section.
@end(note)

@function{int CreateView(vt, sxmin, symin, sxmax, symax, 
	xmin, wymin, zoom, showGrid)
    short vt;
    short sxmin, symin, sxmax, symax, wxmin, wymin, zoom;
    BOOLEAN showGrid;}@index(CreateView)
Create a view of the virtual terminal identified by @t[vt] 
without interacting with the user.
The initial position and size are 
determined by the @t[sxmin], @t[symin], @t[sxmax] and @t[symax] parameters.
@t[wxmin] and @t[wymin] are the world coordinates to map to the left
and bottom edges of the viewport.  Returns negative on error.

The @t[zoom] factor is the power of two to multiply world coordinates to get
screen coordinates.  The zoom factor may be negative, to denote that a view
is zoomed out.  If @t[showGrid] is non-zero a grid of points every 16 pixels
is displayed in the window.  Again, these parameters are relevant only for
SGVT's.
@begin(note)
In general, this routine is not
particularly well-suited to creating views of AVT's, as
explained in the following section.
@end(note)

We now proceed with the description of the terminal emulation and graphics
facilities.  In the process the differences between the two underlying types
of virtual terminals should become clear.

@section(ANSI Terminal Emulation)

ANSI terminal emulation is provided by what we call @i(ANSI virtual
terminals) (AVT).  An AVT emulates a (almost complete) subset of ANSI
standard X.64  often equated with the D@c(EC) VT-100; the precise subset
is given in Chapter @ref(VGTS).  An application may use the ANSI terminal
protocol to communicate with the workstation agent, including escape sequences
for cursor control.  Additional V-specific support is provided for graphics
input and line-editing, but applications may ignore these features as they
wish.

The "store" of an AVT is referred to as a @i[pad].  Conceptually, a pad may
be of infinite size, allowing an application to store arbitrary amounts of
data and allowing a user to scroll back and forth through this data.  In
current practice, a pad provides only enough storage for one "page" of data
 one virtual screen- or viewport-full.  Consequently, it is not
particularly useful to create multiple views of a pad.

@begin(note)
Unfortunately, the term "pad" has been adopted to mean both pad
and AVT.  Hence, most routines specific to AVT employ @t(Pad) in their names
rather than @t(AVT).  Consequently, in the following discussion the terms
are used interchangeably.
@end(note)

@subsection(Cooking Your AVT's)
@index(Cooking)@index(Raw)

The following mode bits are maintained for each AVT to indicate the degree
of ``cooking'' to be applied to I/O:
@begin(description)
@t(CR@uf()Input)@\Change@index(CR Input)
the @c[CR] (return) character to @c[LF] (@c[UNIX] newline)
on input.
This is for the benefit of @c[UNIX] programs which expect `\n'
as a line terminator.

@t[DiscardOutput]@\When set, this bit causes all output to an AVT to be
ignored.  It is automatically set when the user types `q' to an AVT that is
blocked at the end of a page in @t[PageOutput] mode.  It is automatically
cleared whenever the workstation agent sends input to a program that is reading
from the AVT.  The bit may also be cleared ``manually'' via @t[ModifyPad()].
In particular, application programs should call @t[ModifyPad()] to clear
this bit before sending a prompt to an AVT, to insure that the prompt is not
discarded along with any previous output that was discarded at the user's
request.@index(DiscardOutput)

@t[Echo]@\Echo input characters.@index(Echo)

@t(LF@uf()Output)@\Change @c[LF] to @c[CR-LF] on output.@index(LF Output)
That is, every line-feed operation is preceded by a return.

@t[LineBuffer]@\Wait for a line of input before returning.  In addition, the
line will be line-edited as described
in section @ref(LineEditing).@index(LineBuffer)@index(Line Editing)

@t[NoCursor]@\Do not display a cursor in the indicated AVT.@index(NoCursor)

@t[PageOutput]@\Block the writer each time the AVT fills up with output, and
wait for the user to issue a command which unblocks the AVT.  The user
interface to the this feature is described in section
@ref(Paged Output Mode).  This
bit is `on' by default.@index(PageOutput)

@t[PageOutputEnable]@\@comment(What a disgusting kludge!)
Associated with each AVT is an internal flag, which, when `off', disables
turning on the @t[PageOutput] bit as described above.  This internal flag is
normally sticky, but can be changed by setting the @t[PageOutputEnable] bit
in a @t[ModifyPad()] request.  In this case, the @t[PageOutput] bit is also
used to set the new value of the internal flag.  The @t[PageOutputEnable]
bit should only be used by certain ``privileged'' programs, as a means of
allowing the user to ``permanently'' disable paged output
mode.@index(PageOutputEnable) 

@t[ReportClick]@\Report ``clicks'' of the graphical input device
 a press of at least one button, followed the release of @i[all] buttons  
in response to requests for graphical events.@index(Report Click)

@t[ReportEscSeq]@\Enable the ``Emacs hack'' described in Section
@ref(EmacsHack).  The encodings of the associated escape sequences are
presented in the next subsection.

@t[ReportTransition]@\Report ``transitions'' of the graphical input device
 pressing or releasing any combination of
buttons  in response to requests for graphical
events.@index(Report Transition)
@end(description)

By default, keyboard input is line-buffered and echoed by the workstation
agent, with line-editing.  More specifically, the following mode bits are
set:
@begin(example, leftmargin +1in)
CR@uf()Input
Echo
LF@uf()Output
LineBuffer
@end(example)

@subsection(Encoding Graphical Input Events)
@label(EmacsHack2)

As noted, @t[ReportEscSeq] indicates that the
application is capable of interpreting the associated escape sequences.
This allows many useful programs that deal with conventional terminals to be
extended to take advantage of the graphical input capability  without
major redesign.  For example, an EMACS library can be loaded to bind these
character strings to commands that position the cursor, set the EMACS mark,
delete and insert text.  In fact, these sequences were added precisely to
support EMACS  which, unfortunately, affected their design somewhat.

The exact encoding of the escape sequences is given in Table
26-1,@comment[@ref(Escape Encodings),] where
@i(<line>) and @i(<column>) are the position within the AVT where the mouse
button(s) were pressed  encoded as bytes.
@begin(table)
@Begin(format, leftmargin +.25in)
@tabclear
@tabset(+.25in, +.25in, +.25in, +5.5in)
 Mouse 
Buttons@\@=Escape Sequence
@ux(L@\M@\R@\@\)
x@\.@\.\@\ESC M @i[<line><column>]@index(Left Button)

x@\x@\.@\ESC M @i[<line><column>] null@index(Left+Middle Buttons)

x@\.@\x@\ESC M @i[<line><column>] @c(CTRL)-w@index(Left+Right Buttons)

.@\x@\x@\ESC M @i[<line><column>] @c(CTRL)-y@index(Middle+Right Buttons)
@end(format)
@caption(Encodings for graphical escape sequences.)
@tag(Escape Encodings)
@end(table)


@begin(note)
These are escape sequences that the workstation agent generates and
the application must interpret.  The standard ANSI protocol contains escape
sequences that the application generates and the workstation agent must
interpret.
@end(note)

@subsection(Functions)

Terminal emulation is implemented in terms of the standard V-System I/O
protocol as defined in Chapters @ref(IO) and @ref(IOProtocol).  For example,
applications may read from and write to AVTs using the standard
@t[Read()] and @t[Write()] primitives.  Consequently, the application
interface to an AVT is through a V-System file access descriptor (of type
@t[File]).  The following "AVT-specific" routines are also provided:

@function{File *OpenPad(name, lines, columns, error)
    char *name;
    short lines, columns;
    SystemCode *error;}@index(OpenPad)
Create a new AVT @i[and] interact with the user to create a view of the AVT.
@t[name] is a text
name for the AVT. @t[lines] and @t[columns] specify the size of the pad.
Returns a pointer to a file access descriptor for the pad; @c[NULL] on an
error.  @t[error] is a pointer to the
reply code.
@begin(note)
The file descriptor returned is open for writing.  If you want to read
from it, you must use @t[OpenFile()] to create another file
descriptor with the same @t[fileserver] (= workstation agent) and @t[fileid]
(= virtual terminal / AVT id).
@end(note)

@function{File *OpenAndPositionPad( name, x, y, lines, columns, error )
    char       *name;
    short      x, y, lines, columns;
    SystemCode *error;}@index(OpenAndPositionPad)
Create a new AVT of size @t[lines] and @t[columns], and place the view of
this AVT at @t[x], @t[y].  @t[name] is a text name for the AVT. 
Returns a pointer to a file access descriptor for the AVT; @c[NULL] on an
error.  @t[error] is a pointer to the
reply code.
@begin(note)
The note for @t[OpenPad()] also applies to @t[OpenAndPositionPad()].
@end(note)

@function{ModifyPad(avt, mode)
    File *avt;
    int mode;}
Set the cooking @t[mode] of @t[avt].@index(ModifyPad)
@t[mode] is some combination of the bits described in the previous subsection.

@function{int QueryPad(avt)
    File *avt;}
Return the cooking mode of @t[avt],@index(QueryPad)
some combination of the bits described in the previous subsection.
@begin(note)
Rarely used, since its function is subsumed by @t[QueryPadSize()].
@end(note)

@function{int QueryPadSize(avt, plines, pcols)
    File *avt;
    short *plines, *pcols;}
Get the size @t[and] mode of @t[avt].@index(QueryPadSize)
The number of lines and columns are
store in the shorts pointed to by @t[plines] and @t[pcols], respectively.  
The cooking mode is returned as the value of the function.

@function{PadFindPoint(avt, nlines, x, y, pline, pcol)
    short avt, nlines, x, y;
    short *pline, *pcol;
}
Convert@index(PadFindPoint)
the world coordinates @w((@t[x],@t[y])) into a
a line and column position within @t[avt], stored in the shorts pointed to by
@t[pline] and @t[pcol], respectively.  
@begin(note)
The @t[avt] parameter
is currently unused, and the number of lines in the AVT
must be specified in @t[nlines].
@end(note)

@function{RedrawPad(avt)
    File *avt;}
Redraw the indicated @t[avt].@index(RedrawPad)
@begin(note)
The same
functionality should be available for SGVT's, but isn't.
@end(note)

@function{SystemCode EditLine(avt, string, count)
    File *avt;
    char *string;
    int count;
}@index(EditLine)@index(Line Editing)
Enter line-editing mode in @t[avt], as defined in Section @ref(LineEditing).
The line-edit buffer is pre-loaded with the
first @t[count] characters of @t[string].
On return, @t[string] will contain the
line-edited input.  Function returns one of the standard system reply codes.

@section(Graphical Output)

The central graphical concept of the VGTS is that application programs
should only have to deal with creating and maintaining abstract graphical
objects.  The details of viewing these objects are taken care of by the
VGTS.  This is in contrast to traditional graphics systems in which users
perform the operations directly on the screen, or on an area of the screen
referred to as a viewport or window.  Thus the VGTS deals with declarative
information rather than procedural; you describe what the objects are rather
than how to draw them.

The abstract graphical objects created and manipulated by a program are
stored in a @i(structured display file) (SDF).@index(structured display
file)@index(SDF)  An SDF is a name space in which graphical @i(items) and
 @i(symbols) are defined; it may be thought of as the "store" of a virtual
terminal.@index(item)@index(symbol) The SDF is structured as
a hierarchy, a directed acyclic graph of symbols calling other symbols.  
A
symbol is an interior node of the graph, a logical grouping of graphical
information.  The leaves of the graph consist of graphical primitives such
as rectangles, lines, or pieces of text.  An item may be either one of these
primitives or a call to another symbol  the "call statement" itself, not
the symbol definition.  Regardless, every item is contained in some symbol.

Note that a symbol call is like a procedure call, not like a macro.
Changing the symbol definition changes all instances.

Each symbol is defined within its own 2-dimensional integer world coordinate
space  although the dimensions of that coordinate space are the same
across all symbols, namely, -32768 to 32767.  Translation is the only
modeling transformation permitted on ``called'' symbols.  All other
transformations, such as rotation or projection from higher dimensions, must
be handled by the application.

As discussed in the previous section, defining symbols and filling them with
items does not make anything appear on the screen.  In order for a symbol to
appear, it must be displayed on a @i(structured graphics virtual terminal)
(SGVT).@index(structured  graphics virtual  terminal)@index(SGVT)  An SGVT
 may be thought of as a large, two-dimensional, imaginary
display surface upon which graphical objects may be displayed.  As for
symbols, its coordinate space is from -32768 to 32767 in x and y, vastly
larger than the actual screen.  On this display space, one symbol in the SDF
is displayed as the @i(top-level symbol).  Every item that is in that
symbol, or in any symbol called by that symbol, etc., will be displayed on
the SGVT.  An item in a symbol that is called several times, will be
displayed several times.  Thus for example, in our SGVT we might display a
bicycle as the top-level symbol.  The bicycle symbol contains a call to the
frame symbol, and two calls, with different coordinates, to the wheel
symbol.  The wheel symbol contains several items: a circle for the rim and
lines for the spokes.  Each of these items will be displayed twice, once for
each wheel, though they were defined only once.

@subsection(SDF Manipulation)

@paragraph(Item Attributes)
@label(ItemAttributes)

Each item has the following attributes, as used in many of the procedures
discussed below:
@begin(description)
@t[item]@\A 16 bit unique (within the SDF) identifier for this object,
or zero.@index(Item)@index(zero)
This identifier is assigned by the program, guidelines for which are given
in Section @ref(ItemNaming).

@t[type]@\One of the predefined primitive types described below.
Currently eight bits are allocated for this.@index(Item Type)

@t[typeData]@\Eight bits of type-dependent information, as described in the
next section.

@t[xmin], @t[xmax], @t[ymin], @t[ymax]@\Typically used to define the bounding
box (or @i[extent]) of the item, in world coordinates.  Also may be used for
additional purposes, as discussed in the next section.  Stored as 16-bit
signed integers.  
@begin(note)
These names are misleading, since the VGTS
actually sorts the endpoints and calculates the bounding box correctly.
@end(note)

@t[string]@\A "string's" worth of type-dependent information, as described
in the next section.
@end(description)

@paragraph(Primitive Item Types)
@label(ItemTypes)

Some of the meanings of the fields above depend on the type of the item.
The following are the types of primitive items that occur in 
a structured display file, with their type-dependent uses of the various
attributes:
@begin(description)
@t[SDF@uf()CIRCLE]@\A circle, centered at @w((@t[xmin],@t[ymin)]) with a radius
given by the @t[typeData] field.  
@begin(note)
This item type is currently
supported only for the Sun model 100 framebuffer.
@end(note)

@t[SDF@uf()FILLED@uf()RECTANGLE]@\A filled rectangle.@index(Filled Rectangle)
@t[typeData] determines the@index(Rectangle)
pattern.  There are two possible sets of patterns, each influenced by the
application for which they were developed.  The first set was defined for a
VLSI layout editor and is not likely to be of general use; they are defined
in @t[<Vgts.h>].  The second set was defined for a document illustrator and
are likely to be of greater interest; they are defined in @t[<splines.h>].
To use one of them for a filled rectangle, add its index (as defined in
@t[<splines.h>]) to the constant @t(STIPPLE_OFFSET) (defined in
@t[<Vgts.h>], and use the resulting value as @t[typeData].


@t[SDF@uf()GENERAL@uf()LINE]@\A@index(General Line) generalized line, from
 @w((@t[xmin],@t[ymin])) to @w((@t[xmax],@t[ymax])).  

@t[SDF@uf()HORIZONTAL@uf()LINE]@\Horizontal line from @w((@t[xmin],@t[ymin]))
to @w((@t[xmax],@t[ymin])).  @t[ymax] is ignored.@index(Horizontal Line)
@index(Line)

@t[SDF@uf()HORIZONTAL@uf()REF]@\A@index(Reference Line)
horizontal reference line at @w((@t[ymin] + @t[ymax]) / 2).
Reference lines consist of a thick line with two tick marks
at the ends, and some associated text.
They are intended for use in computer aided design applications
like the @t[dale]@index(Dale) layout editor.

@t[SDF@uf()OUTLINE]@\Outline for a selected symbol.@index(Outline)
@t[xmin], @t[xmax], @t[ymin] and @t[ymax] give the box for the outline.
@t[typeData] specifies flag bits to select each of the edges:
@t(LeftEdge), @t(RightEdge), @t[TopEdge] or @t[BottomEdge].

@t[SDF@uf()POINT]@\A@index(Point)
point, which usually appears as a 2-by-2 pixel square at 
@w((@t[xmin],@t[ymin])).

@t[SDF@uf()POLYLINE]@\A poly-line, consisting of a connected set of line
segments.@index(Polyline).  @i[string] points to an array of points, as in:
@Begin(bigprogramexample)
typedef struct
  {
    short x;
    shor y;
  } SdfPoint;
@End(bigprogramexample)
@begin(note)
This item type is currently
supported only for the Sun model 100 framebuffer.
@end(note)

@t[SDF@uf()RASTER]@\A@index(Raster)
general raster bitmap with a lower left corner at @w((@t[xmin],@t[ymin]))
and upper right corner at @w((@t[xmax],@t[ymax])).
@t[typeData] determines if the raster is written with ones as black
or white.  @t[string] points to the actual bitmap, in 16 bit-wide swaths.
@begin(note)
On the Sun model 100 framebuffer, a raster can be displayed at zoom
factors 0, 1, 2, 3, and 4 (only); on the model 120 framebuffer, only zoom
factor 0 (no magnification) is currently supported.  In all cases,
the VGTS only supports the ``display'' of bitmaps, not any operations
on them.  An application-level libary containing ``RasterOp'' routines is, 
however, available (see Section @ref(Rolling Your Own)).
@end(note)

@t[SDF@uf()SEL@uf()HORIZ@uf()REF]@\A@index(Selected Horizontal Reference Line)
thick (selected) horizontal reference line at @w((@t[ymin] + @t[ymax]) / 2).

@t[SDF@uf()SEL@uf()VERT@uf()REF]@\A@index(Selected Vertical Reference Line)
thick (selected) vertical reference line at @w((@t[xmin] + @t[xmax]) / 2).

@t[SDF@uf()SIMPLE@uf()TEXT]@\A@index(Simple Text) simple text string employing a
fixed-width font (typically 8 pixels wide by 16 pixels high).  The lower
left corner of the string will be placed at @w((@t[xmin],@t[ymin])).  The
values of @t[xmax] and @t[ymax] need not surround the text, but they are
used as aids for redrawing, so should correspond roughly to the real
bounding box.

@t[SDF@uf()SPLINE]@\A@index(Spline) spline object, of which a special case is a polygon.
Splines may be filled with any of a number of different patterns or drawn
with any of a number of different ``nibs'', as defined in
@t[<splines.h>].  @t[string] points to a @t(SPLINE) structure as defined
in the @t[<splines.h>]:@index(Spline)
@Begin(bigProgramExample)
typedef struct
  {
    short x, y;
  } POINT;

typedef struct
  {
    unsigned short	order;	/* Order of the spline		*/
    unsigned short	numvert;/* Number of vertices present.	*/
    enum Nib		nib;	/* Nib to be used for drawing.	*/
    unsigned short	border;	/* Is the border visible?	*/
    unsigned short	closed;	/* Is this object closed or open?*/
    unsigned short	filled;	/* Is this object filled?	*/
    unsigned short	opaque;	/* Is the filling opaque (solid)?*/
    enum Pattern	pat;	/* Fill (stipple) pattern.	*/
    POINT		head;	/* Head of the list of vertices	*/
  } SPLINE;
@End(bigProgramexample)
@begin(note)
The patterns used for splines are a subset of those used for
filled rectangles.  (See the discussion of @t(SDF@uf()FILLED@uf()RECTANGLE)
above.)
@end(note)

@t[SDF@uf()TEXT]@\A@index(General Text) string of general text, with the left end at
 @t[xmin] and the baseline at @t[ymin].  @t[typeData] determines the
font number.  (To get the actual bounding box (calculated from information
in the font file), use @t[InquireItem()] after the @t[AddItem()], as defined
in the following section.)  See section @ref(GeneralText) for an example.

@t[SDF@uf()VERTICAL@uf()LINE]@\Vertical line from @w((@t[xmin],@t[ymin]))
to @w((@t[xmin],@t[ymax])).  @t[xmax] is ignored.@index(Line)@index(Vertical Line)

@t[SDF@uf()VERTICAL@uf()REF]@\A vertical reference line at
@w((@t[xmin] + @t[xmax]) / 2).@index(Vertical Reference Line)
@end(description)

@paragraph(Functions)

The following are the currently defined functions used to manipulate an SDF
and, hence, generate graphical output.  All return values except the actual
function value are passed via pointer parameters.  If any pointer is @c[NULL],
no value is returned for that parameter.  For performance reasons, many of
these calls are batched (several calls in one request) and/or pipelined (no
return values).  In either case there are no meaningful return values and
any error conditions simply cause the VGTS to drop the call on the floor.
The description for each routine indicates whether this is the case.

@function{short CreateSDF()}
Create a structured display file, returning its id.
Returns -1 if the VGTS runs out of resources.
Must be called before any symbols are defined.@index(CreateSDF)  Forces all
pending calls to be executed.

@function{int DeleteSDF(sdf)
    short sdf;}
Return all the items defined in the given @t[sdf]
to free storage.@index(DeleteSDF)
This includes all data structures
associated with items in the SDF.  
Returns @t[sdf] or -1 on error.
Forces all pending calls to be executed.

@function{DefineSymbol(sdf, symbol, textName)
    short sdf, symbol;
    char *textName;}
Enter@index(DefineSymbol)
@t[symbol] into the @t[sdf] and open it for editing.  Only one symbol may be
open in any given SDF at a time.
@t[textName] is an optional descriptive name for the symbol,
used in the hit selection routines for disambiguating
selections.  Buffered call, but always returns @t[symbol] for backward
compatibility.

@function{short EndSymbol(sdf, symbol, sgvt)
    short sdf, item;
    short sgvt;}
Close@index(EndSymbol)
@t[symbol] in @t[sdf]
so no more insertions can be done and cause all views of @t[sgvt] displaying 
the symbol to be redrawn.  The VGTS ensures that, if only additions have
been made since the last @t[EndSymbol], only those additions are drawn.
Called at the end of a
list of @t[AddItem()] and @t[AddCall()] calls defining a symbol, started
with @t[DefineSymbol()] or @t[EditSymbol()].  Forces all pending calls to 
be executed.  Always returns @t[symbol] for backward compatibility.
@begin(note)
@t[symbol] is actually redundant, since only one symbol can be
"open" in any SDF at a time, but it must be provided.
@end(note)

@function{EditSymbol(sdf, symbol)
    short sdf, symbol;}
Open@index(EditSymbol)
(already existing) @t[symbol] in @t[sdf] for modification.
This has the effect of calling @t[DefineSymbol()] and inserting
all the already existing entries.
The editing process is ended in the same way as the initial
definition process  a call to @t[EndSymbol()].
Buffered call, but always returns @t[symbol] for backward compatibility.

@function{short DeleteSymbol(sdf, symbol)
    short sdf, symbol;}
Delete@index(DeleteSymbol) @t[symbol] from @t[sdf].  More correctly, render
the symbol definition "empty" to prevent problems with dangling references
(calls) to the definition.  The dangling references will be interpreted but
will have no effect, since the symbol will no longer contain any items.
Returns @t[symbol] if successful, else 0.  Forces all pending calls to be
executed.

@function{AddItem(sdf, item, xmin, xmax, ymin, ymax, 
	typeData, type, string)
    short sdf, item, xmin, xmax, ymin, ymax;
    unsigned char type, typeData;  char *string;}
Add @t[item] to the currently open symbol in @t[sdf].
@index(AddItem)  
Remaining parameters as defined above (Sections @ref(ItemAttributes) and 
@ref(ItemTypes)).
Buffered call, but always returns @t[item] for backward compatibility.

@function{AddCall(sdf, item, xoffset, yoffset, calledSymbol)
    short sdf, item, xoffset, yoffset, calledSymbol;} 
Add@index(AddCall) an
instance of the @t[calledSymbol] to the currently open symbol in @t[sdf].
The "call statement" itself is given the name @t[item].  The origin of the
called symbol
instance is placed at @w((@t[xoffset],@t[yoffset])) in the coordinate space
of the calling symbol.
May be called
 @i[before] the called symbol is defined, in which case a dummy entry for
the symbol is inserted in the SDF; any future attempts to define the symbol
will use the dummy entry.  Buffered call, but always returns @t[item] for
backward compatibility.  

@function{DeleteItem(sdf, item)
    short sdf, item;}
Delete@index(DeleteItem)
@t[item] from the currently open symbol in @t[sdf].  
Symbol calls can be deleted just like any other item, but
symbol definitions are deleted by the @t[DeleteSymbol()] function.
Buffered call, but always returns @t[item] for backward compatibility.

@function{int InquireItem(sdf, item, xmin, xmax, 
	ymin, ymax, typeData, type, string)
    short sdf, item;  short *xmin, *xmax, *ymin, *ymax;
    unsigned char *type, *typeData;  char *string;}
Read the attributes of @t[item] in @t[sdf].  Parameter semantics are
defined above  (Sections @ref(ItemAttributes) and 
@ref(ItemTypes)).
All
parameters except @t[sdf] and @t[item] are pointers.@index(InquireItem)
For each non-null pointer, the value of the field for that item
is returned.
Zero is returned if the item could not be found; otherwise, non-zero.
Forces all pending calls to be executed.

@function{short InquireCall(sdf, item)
    short sdf, item;}
Return@index(InquireCall)
the name of the symbol called by @t[item] in @t[sdf].
Returns zero if the item is not a call, or could not be found.
Forces all pending calls to be executed.

@function{ChangeItem(sdf, item, xmin, xmax,
	ymin, ymax, typeData, type, string)
    short sdf, item, xmin, xmax, ymin, ymax;
    unsigned char type, typeData;  char *string;}
Change
the parameters of (already existing) @t[item] in @t[sdf].@index(ChangeItem)
Remaining parameters as defined above (Sections @ref(ItemAttributes) and 
@ref(ItemTypes)).
This is equivalent to deleting an item and then reinserting it,
so the item must be part of the open symbol.  Buffered call, but always
returns @t[item] for backward compatibility.

@paragraph(Naming Items and Symbols)
@label(ItemNaming)

Items and symbols are both identified by 16-bit identifiers, most commonly
thought of as unsigned integers.  The identifiers are specified by the
application.   It is assumed that the application will maintain some
higher-level data structures, along with the appropriate mapping to these
internal item names.  Items that will never be referenced can be given item
number zero.  The item names are global to each SDF, so the programmer
should be careful not to assign the same item number within the same SDF
twice.  However, applications may use multiple SDFs for multiple name
spaces.@foot{The intended use of multiple SDFs is that an application would
have both "private" and "shared" graphical data, such that the shared data
was stored in an SDF used by multiple (cooperating) applications.}

For example, a picture of a bicycle might define a symbol for a wheel.  This
definition of the wheel symbol is given item number 4.  There may then be
two instances of item number 4, that are given item numbers 5 and 6.  The
individual spokes of the wheel are components of symbol number 4, but are
all given item number 0, since we will never want to refer to any of them.
If it is desired to delete or move any individual spoke, then the items may
be given numbers.

@paragraph(Output Modes)

By appropriate use of the various functions, programs may achieve the effect
of deferral modes for graphical output.  First, they may construct
graphical objects in their entirety and @i[then] display them, by executing
a @t[DefineSymbol()] or @t[EditSymbol()], followed by many @t[AddItem()] or
 @t[AddCall()] calls, followed by an @t[EndSymbol()].  This corresponds to
creating an ``invisible segment'' and then displaying it in traditional
graphics systems.

Alternatively, an application many construct and display an object ``on the
fly'', that is, display each item as it is added to the object.
This is done, for example, by repeatedly executing an @t[EditSymbol()] - 
@t[AddItem()] - @t[EndSymbol()] sequence, such that each @t[EndSymbol()]
causes the symbol to be redrawn.  This corresponds to creating a ``visible
segment'' in traditional graphics systems.  (Note the optimization discussed
in the description for @t[EndSymbol()], which reduces redraw
time.)

The first style of output yields higher throughput, whereas the second
yields faster response.

@paragraph(An Example)

To create the bicycle figure of the previous section, we would use code like
the following:
@begin(bigprogramexample)
short sdf;

sdf = CreateSDF();
DefineSymbol(sdf, 4, "Wheel");
	.
AddItem(sdf, 0, xmin, xmax, ymin, ymax, 0, SDF@uf()GENERAL@uf()LINE, NULL);
	.
   (add the components of the wheel symbol)
	.
EndSymbol(sdf, 4, 0);

DefineSymbol(sdf, 3, "Bicycle");
AddCall(sdf, 5, x1, ymin, 4);
AddCall(sdf, 6, x2, ymin, 4);
EndSymbol(sdf, 3, 0);
	.
    (whoops ... forgot the frame)
	.
EditSymbol(sdf, 4)
	.
    (add frame)
	.
EndSymbol(sdf, 4, 0)
@end(bigprogramexample)

@subsection(SGVT Management)

@function{int CreateVGT(sdf, type, topSymbol, string)
    short sdf;  int type;  short topSymbol;  char *string;}
Create an SGVT of the indicated @t[type].
Put the indicated symbol  @t[topSymbol] in @t[sdf] 
as the top-level symbol in the SGVT.
@t[topSymbol] can be zero to indicate a blank SGVT.
@t[type] can be some combination of @t[TTY], @t[GRAPHICS], and @t[ZOOMABLE],
but programmers are advised to use the terminal emulation functions
described above for @t[TTY]'s.
If the @t[ZOOMABLE] bit is set, the view zooming factor can be 
changed by the user.
Returns@index(CreateVGT)
the virtual terminal id or negative on errors.

@function{DisplayItem(sdf, topSymbol, sgvt)
    short sdf, topSymbol;  int sgvt;}
Change@index(DisplayItem)
the top-level symbol for @t[sgvt] to @t[topSymbol] in @t[sdf].
The new symbol is displayed in every view of the SGVT.

@subsection(Defining and Using Fonts)
@index(Font)@label(GeneralText)

@function{short DefineFont(name, fileName)
    char *name, *fileName;}
Defines@index(Define Font)
a font to be used in subsequent SDF@uf()TEXT items.
The @t[name] is a pointer to a string giving the name of the font,
for example, ``Helvetica10B''.
The font is read by the VGTS from the file with the pathname
given as the second argument.
The @t[fileName] argument can be null to indicate a read from the
standard place.
The font-id returned by this call is used as the @t[typeData] field
for SDF@ux()TEXT items.
A negative return value indicates an error.
For example,
@begin(bigProgramExample)
short roman = DefineFont("TimesRoman12", NULL);
AddItem(sdf, 0, x, x, y, y, roman, SDF@uf()TEXT, "Hello")
@end(bigProgramExample)
will display the string ``Hello'' in the Times Roman font at 12 point
size, at the position (x,y) on the screen.

@section(Graphical Input)

The VGTS maintains an event queue for each virtual terminal  whether AVT
or SGVT  on which both graphical (mouse) and keyboard events are queued.

@subsection(Common Functions)
@label(CommonGraphics)

The following functions are (more or less) independent of the type of
virtual terminal.  To maintain compatibility with the AVT-specific routines
and the V I/O protocol, the desired virtual terminal must be bound to a V
file access descriptor before calling these functions.  Specifically, in the
descriptions below,
@t(vt->fileserver) must contain the process id of the workstation agent and
@t(vt->fileid) must contain the id of the virtual terminal.
The file descriptor returned from
@t[OpenPad()] is set up precisely in this fashion, but if @t[CreateVGT()] is
used, the application must explicitly construct an appropriate file
descriptor, storing the result of @t[CreateVGT()] in @t(vt->fileid).
The file pointer @t[stdin] may be used to receive
input from the virtual terminal (usually an AVT) associated with the
application's ``standard input''.

@function{GetEvent(vt, px, py, pbuttons, cbuf)
	File *vt;
	short *px, *py, *pbuttons;
	char *cbuf;}
Wait@index(GetEvent) for any input event in the indicated virtual terminal.
This currently means mouse clicks, mouse transitions, or keyboard input 
 @i[not] mouse movements.  If the virtual terminal is an AVT, then the type
of graphical event reported depends on the cooking mode of the AVT.  Returns
the world X and Y coordinates of the mouse in the shorts pointed to by
 @t[px] and @t[py], and the buttons in the short pointed to by @t[pbuttons]
if the event is graphical or else returns the characters in the buffer
pointed to by @t[cbuf].  The function value is negative on error (in which
case, @t(vt->lastexception) contains the error code), 0 on mouse event, or
the number of characters returned on a keyboard event.
@begin(note)
At most IO@uf()MSG@uf()BUFFER
(defined in @t[<Vioprotocol.h>] - currently 20) characters will be returned
in @t[cbuf].  The corresponding actual parameter should be (at least) this
size.  
@end(note)

@function{int GetGraphicsEvent(vt, px, py, pbuttons)
    File *vt;
    short *px, *py, *pbuttons;}
Wait@index(GetGraphicsEvent)
for a graphical event
in the virtual terminal associated with the file descriptor @t[vt].
Currently, graphical events consist of transitions and clicks of the mouse
buttons  @i[not] movements.
If the virtual terminal is an AVT, then the type of graphical event reported
depends on the cooking mode of the AVT  which must be set appropriately
via @t[ModifyPad()].
Returns the world X and Y coordinates in the shorts
pointed to by @t[px] and @t[py];
the state of the buttons is returned both in the short pointed
to by @t[pbuttons] and as the value of the function.  The function value is
negative on error, in which cast @t(vt->lastexception) contains the error
code.


@function{int GetGraphicsStatus(vt, px, py, pbuttons)
	File *vt;
	short *px, *py, *pbuttons;}
Sample the graphical input device relative to the virtual terminal
associated with the file descriptor @t[vt]@index(GetGraphicsStatus).
Currently, this means returning the current location
and button status of the mouse, whether or not the mouse currently resides in
a view of the virtual terminal and @i[without] waiting for the mouse to
move.  All events queued for the virtual terminal are flushed prior to
sampling.  Returns the world X and Y coordinates in the shorts pointed to by
 @t[px] and @t[py]; the state of the buttons is returned both in the short
pointed to by @t[pbuttons] and as the value of the function.  The
function returns negative on error, in which case
@t(vt->lastexception) contains the error code  typically @t[EOF] to
indicate that the mouse cursor was not in a view of the virtual terminal.

@paragraph(Antiquated Routines)

The following routines pre-date those listed above.  The only reason for
their continued existence is that they currently are the only graphical
input routines that may be employed by applications running on non-V hosts
(see Section @ref(OtherHosts)).  However, their days are numbered.

@function{short GetMouseClick(x, y, buttons)
    short *x, *y, *buttons;
}
Wait@Index[GetMouseClick]
for a mouse click in the virtual terminal corresponding to @t[stdin].
The world X and Y coordinates are returned in the shorts
pointed to by @t[x] and @t[y], and the state of the buttons is returned in the
short pointed
to by @t[buttons]. If a key is pressed, a message is printed stating that
a mouse click is expected, and the key is ignored.
Forces all pending calls to be executed and blocks until a mouse click does 
come in.  
@begin(note)
This function is semantically
equivalent to both @t[GetGraphicsEvent()] and @t[GetMouseOrKeyboard()]
(where any character returned is dropped on the floor).  
@end(note)

@function{short GetMouseOrKeyboard(c, x, y, buttons)
    short *x, *y, *buttons;
    char *c;
}
Wait@Index[GetMouseOrKeyboard]
for a mouse click or keyboard press in the virtual terminal
 corresponding to @t[stdin].
If the mouse is clicked,
the world X and Y coordinates are returned in the shorts
pointed to by @t[x] and @t[y], the state of the buttons is returned in the
short pointed
to by @t[buttons], and the function returns the identifier of the virtual
terminal in which the click occurred.
If a key was pressed, the character is returned in the
location pointed to by @t[c], and the function returns 0.
@begin(note)
This function is semantically equivalent to @t[GetEvent()].
@end(note)

@subsection(SGVT-only Functions)

Mouse events often signify an attempt on the part of the user to ``select''
some graphical object.  When such an event is reported to the application,
it should respond by calling the following function to determine which, if
any, graphical object was so selected.

@function{LISTTYPE FindSelectedObject(sdf, x, y, sgvt, searchType)
    short sdf, x, y, sgvt;
    char searchType;}
Return a list of items that are at or near @w[(@t[x],@t[y])] in 
@t[sgvt].@index(FindSelectedObject)
Along with each item is a set of edges, to indicate that 
the hit was near one or more edges of the object.
The @t[searchType] selects one of several modes of hit 
detection@index(Hit Detection):
@Begin(description, leftmargin +20, indent -12, spread 0)
@t[All]@\Anything will do.

@t[AllLines]@\Any lines.

@t[JustHoriz]@\Just horizontal lines.

@t[JustRasters]@\Just rasters.

@t[JustRects]@\Just rectangles.

@t[JustSplines]@\Just splines.

@t[JustText]@\Just text strings.

@t[JustVerts]@\Just vertical lines.
@End(description)
Usually the constant value @t[All] will be used.@index(All)
The return value is defined as follows:
@begin(bigProgramExample)
typedef struct MinElement
  {
    short		      item;	
    short		      edgeset;	
    struct MinElement        *next;
  } MINREC, *MINPTR;

typedef struct ListInfo
  {
    MINPTR            Header;
    short             NumOfElements;
  } LISTTYPE;
@end(bigProgramExample)

@begin(comment)  I WISH!!!!!!
GetEvent(searchButtons,searchType) => buttons,x,y,hitList,sgvt@\Waits
for some input event,
such as a mouse click, and returns the SGVT
in which the click took place.  
X and Y world coordinates of the mouse click are returned in x and y.
The buttons parameter indicates a set of mouse buttons which were pressed;
one of @t[LeftButton], @t[MiddleButton], and @t[RightButton] currently.
If searchButtons matches any of the buttons pushed,
an attempt is made to find possible items picked.
Returns a list of items that are at or near that location in hitList.
Along with each item is a set of edges, to indicate that 
the mouse was near one or more edges of the object.
The searchType selects one of several modes of hit detection.
@end(comment)

@section(Miscellaneous Functions)

The following functions are (more or less) independent of the type of
virtual terminal  despite the occurrence of @t[Pad], or @t[Vgt]
in their names.  As in Section @ref(CommonGraphics),
to maintain compatibility with the AVT-specific routines
and the V I/O protocol, the desired virtual terminal must be bound to a V
file access descriptor before calling these functions.  Specifically, in the
descriptions below,
@t(vt->fileserver) must contain the process id of the workstation agent and
@t(vt->fileid) must contain the id of the virtual terminal.
The file descriptor returned from
@t[OpenPad()] is set up precisely in this fashion, but if @t[CreateVGT()] is
used, the application must explicitly construct an appropriate file
descriptor, storing the result of @t[CreateVGT()] in @t(vt->fileid).
The file pointer @t[stdin] may be used to receive
input from the virtual terminal (usually an AVT) associated with the
application's ``standard input''.

@function{GetTTY()}
Put the terminal in raw mode.@index(GetTTY)
The (remote) @c[UNIX] version of this routine does the appropriate @c[UNIX]
operation if standard input is a tty device, otherwise it sends the 
proper code for the remote execution facility.

@function{short popup(menu)
    PopUpEntry menu[];}
Display a ``pop-up'' menu and wait for the user to select an option.
@index(popup)@index(Menu)
The menu argument points to an array of @t[PopUpEntry] structures:
@begin(bigProgramExample)
 typedef struct
  {
    char *string;		/* String to display. */
    unsigned char menuNumber;	/* Number returned if entry selected. */
   } PopUpEntry;
@end(bigProgramExample)
The array is terminated
by a @c[NULL] string.
The code of the menu item selected by the user is returned.
If the user clicks outside the menu, a negative value is returned.

@function{ResetTTY()}
Restore the mode before the last @t[GetTTY()].@index(ResetTTY)
Runs under @c[UNIX] as well, checking standard input properly.

@function{SelectPad(vt)
    File *vt;}
Cause the virtual terminal associated with @t[vt]@index(SelectPad)
to be selected for input.  The (principal) view of the virtual terminal
is brought to the top of the stack of views.  Only works if the calling
program also ``owns'' the virtual terminal currently selected for input.

@function{SystemCode SetVgtBanner(vt, name)
    File *vt;
    char *name;
}
Set@Index[SetVgtBanner]
@t[name] to be the banner at the top of each view of the virtual terminal
corresponding to @t[vt]. 

@section(Example Program)
@index(Example)

The following program can be compiled to run either remotely
under Unix or under the
V system.
The @t[#ifdef VAX] directives allow the programmer to 
conditionally compile code for one environment or the other.
It first creates an SDF and SGVT,
then displays 100 random objects of various kinds.

@begin(bigprogramExample)
/*
 * test.c - a test of the remote VGTS implementation
 * Bill Nowicki September 1982
 */

#include <Vgts.h>
#include <Vio.h>


#define Objects 100	/* number of objects */

short sdf, sgvt;

Quit()
  {
     DeleteVGT(sgvt,1);
     DeleteSDF(sdf);
     ResetTTY();
     exit();
  }
@hinge
main()
  {
    int i;
    short item;
    long start, end;
@hinge
#ifdef VAX  
     printf("Remote VGTS test program\n");
#else VAX
     printf("VGTS test program\n");
#endif VAX
     fflush(stdout);
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, "test" );
     AddItem( sdf, 2, 4, 40, 4, 60, NM, SDF@uf()FILLED@uf()RECTANGLE, NULL );
     EndSymbol( sdf, 1, 0 );
     sgvt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "random objects" );
     DefaultView(sgvt, 500, 320, 0, 0, 0, 0, 0, 0);
@hinge
     time(&start);
     for (i=12; i<Objects; i++ )
       {
         short x = Random( -2, 155);
	 short y = Random( -10, 169);
	 short top = y + Random( 6, 100 );
	 short right = x + Random( 4, 120 );
	 short layer = Random( NM, NG );
@hinge
         EditSymbol(sdf, 1);
	 DeleteItem( sdf, i-10);
	 switch (Random(1, 6) )
	   {
	     case 1:
               AddItem( sdf, i, x, right, y, top, layer, 
	 		SDF@uf()FILLED@uf()RECTANGLE, NULL );
	       break;
@hinge
	     case 2:
	       AddItem( sdf, i, x, x+1000, y, y+16, 0, SDF@uf()SIMPLE@uf()TEXT, 
	       	"Here is some simple text" );
	       break;
@hinge
	     case 3:
	       	AddItem( sdf, i, x, right, y, y+1, 0, 
			SDF@uf()HORIZONTAL@uf()LINE, NULL );
		break;
@hinge
	    case 4:
	       	AddItem( sdf, i, x, x+1, y, top, 0, 
			SDF@uf()VERTICAL@uf()LINE, NULL );
		break;

@hinge
	    case 5:
	       	AddItem( sdf, i, x, right, y, top, 0, 
			SDF@uf()GENERAL@uf()LINE, NULL );
		break;
@hinge
	    case 6:
	       	AddItem( sdf, i, x, right, top, y, 0, 
			SDF@uf()GENERAL@uf()LINE, NULL );
		break;
  	    }
	 EndSymbol( sdf, 1, sgvt );
       }
@hinge
     time(&end);
     if (end==start) end = start+1;
     printf("%d objects in %d seconds, or %d objects/second\r\n",
     	Objects, end-start, Objects/(end-start));
     printf("Done!\r\n");
     Quit();
  }
@hinge
Random( first, last )
  {
  	/*
	 * generates a random number 
	 * between "first" and "last" inclusive.
	 */
    int value = rand()/2;
    value %= (last - first + 1);
    value += first;
    return(value);
  }
@end(bigProgramExample)
@Tag(demo)

@section(Some Logistics)

The constants for mouse search types, virtual terminal usage types, etc. are
found in the include files @t[Vgts.h] and 
@t[Vtermagent.h].@index(Vgts.h)@index(Vtermagent.h)

@subsection(Applications Running Under V)

The stub routines are available in the default V library, so just including
the option @t[-V] on your @t[cc68] command line for linking should work.
 @p(Do not) include the @t(-lVGTS) option on your command line.

@subsection(Applications Running Under Other Operating Systems)
@label(OtherHosts)

To transparently run programs on a U@c[nix] system, use @t[-lVGTS] on your
@t[cc] command line.  Use @t[-I/usr/sun/include] to get the file
 @t[Vgts.h].

This package employs escape sequences that can be used through PUP Telnet,
IP Telnet, or with the remote command execution facility of the executive.
The details of this protocol are explained in Chapter @ref(VGTS).

@begin(note)
The following functions are @p[not] currently available to
applications in this class:
@Begin(example, leftmargin +1in)
EditLine()
GetEvent()
GetGraphicsEvent()
GetGraphicsStatus()
ModifyPad()
OpenPad()
QueryPad()
QueryPadSize()
RedrawPad()
SelectPad()
SetVgtBanner()
@End(example)
@end(note)

@section(Rolling Your Own)
@label(Rolling Your Own)

The primitives discussed here have proven suitable to a wide range of
applications.  Naturally, a few users have found them unsuitable, especially
for applications that manipulate large bitmaps, such as image processing
applications.  Although a raster item type is supported, raster operations
are not.  Hence, applications must perform the operations themselves and
then pass the new bitmaps to the VGTS.  Subsequent versions of the VGTS will
address these and similar problems.

In the meantime, desperate programmers may, in fact, manipulate the frame
buffer directly by using the low-level device-dependent graphics libraries
employed by both the VGTS and the STS.  There is a separate library for each
real device.  The libraries and their documentation may be found in the
 @t(libc/graphics) directory.  
@begin(note)
As noted above, these libraries
also contain a variety of device-independent routines, including some
general-purpose ``RasterOp'' routines, that may be of use to some
applications.
@end(note)

@begin(warning)
Directly manipulation of the graphics hardware
may be very hazardous to your health.  On workstations with the Sun model
100 frame buffer, for example, your manipulation of the frame buffer may
conflict with that of the workstation agent, leading to rather odd screen
images.  That is, both your application and the workstation agent are
manipulating the frame buffer registers.  Fortunately, in this case, you
should be able to avoid most problems by rendering all virtual terminals
that are generating output @i[and] all AVTs that have been selected for
input invisible  by burying them under inactive virtual terminals, for
example.  The latter step is needed in order to disable the blinking cursor.

Finally, if you still are not dissuaded, consider that access to the
frame buffer will be prevented in future versions of the system, hopefully
coincident with the addition of suitable raster support to the VGTS.
@end(warning)

