@string(LastEditDate="Tue Jun 17 17:06:06 1986")
@comment(Current maintainer: Keith Lantz)

@Part(PEOverview, root "manual" )
@Chapter(Program Environment Overview)
@label(Program Environment Overview)

This chapter
describes the execution environment
provided for C programs written to run in the V-System.
The program environment is designed to minimize the difficulty of
porting C programs (and C programmers) from other C program environments,
such as that provided by @c[Unix],
and to provide access to the distributed programming facilities
provided by the V-System.

The program environment consists of three major components:
@begin(itemize)
The base C language implemented by the compiler.

Routines that are part of the C program library in most C implementations.

Functions that access V facilities.
@end(itemize)
The basic C language is not described here.
The reader is referred to @i[The C Programming Language]
by B. W. Kernighan and D. M. Ritchie, Prentice-Hall 1978
for a tutorial on the language and standard C library routines.

Standard C library routines are only described here to the degree they
differ in the V program environment from other implementations,
particularly the @c[Unix] C library.
The reader is referred to the above-cited book or
@i[The Unix Programmer's Manual] for details on these standard functions.

The V-specific functions are described in detail in the following chapters.

While C as a programming language does not define I/O facilities,
memory management, etc.,
an ill-defined de facto standard has arisen from the extensive use of C with
the @c[UNIX] operating system.  There has been a strong attempt to provide a
superset of this environment for the V-System.
Attempts to port C programs have resulted in a slightly more portable
program environment than originally used with @c[Unix].
The functions included in the V program environment for C,
excluding V and workstation-specific routines,
constitute our proposal for a ``standard portable C program environment''.

The differences between the V C program environment and
the @c[Unix] C program environment
fall into four major categories
@itemize[
Functions that are @c[Unix] system calls which may be provided as V
library routines, e.g., stime()@index(Unix).

Functions that are slightly changed in their
implementation, but provide (essentially) the same functionality,
e.g., malloc().

Functions that are workstation-specific,
because they are not
necessary in standard @c[Unix] on, say,
a Vax.
For example, the long division routines are in this category.

Functions that are particular to the V-System,
like Create() and Ready().
@end[itemize]

@section(Groups of Functions)

The description of functions is structured by subdividing them
according to functional groups as follows.
@begin[description]
exec@\Functions related to the V executive.

fields@\Functions that enable an AVT to be used as a menu, similar to a data 
entry terminal.

io@\Input/output related routines.

locking@\Routines providing locking for processes in a single team.

math@\Numeric and mathematical functions.

mem@\Memory management and allocation routines.

naming@\Name management functions.

process@\Process service functions and V kernel traps.

program@\Program execution functions.

user interface@\User interface routines

others@\Miscellaneous other functions, such as string manipulation and
time services.
@end[description]
Subsequent chapters discuss each group of functions in greater detail.

@Section(Header Files)

The following header files define manifest constants, type definitions
and structs used as part of the V C program environment.
They are included as usual by a ``#include <headername>''
directive in C programs.
@begin(description)
Vauthenticate.h@\Message formats and definitions for the authentication server.

Vdirectory.h@\Defines standard context directory entry formats and message 
types.

Venviron.h@\Standard header file for V kernel types and request/reply codes.

Vethernet.h@\Ethernet-specific header information.
This is very low-level information; most users will want to
use the Internet server instead.

Vexec.h@\Definitions for communication with the exec server.

Vexceptions.h@\Exception types and exception request format.

Vfont.h@\Standard internal bitmap and font format.

Vgroupids.h@\V well-known or static group identifiers.

Vgtp.h@\Virtual graphics terminal protocol definitions and message formats.
Must be known by the VGTS and stub routines that talk to it, 
but is not needed by ordinary VGTS applications.

Vgts.h@\Virtual graphics terminal server interface.
This should be included in any programs that do graphics.

Vikc.h@\Manifests and constants relating to the V Interkernel Protocol.

Vinfo.h@\Definitions and structs for InfoBase access.

Vinfobuild.h@\Structs for building InfoBase.
 
Vinfoparse.h@\Definitions and structs for InfoBase scanner/parsers.

Vio.h@\I/O Protocol header file.@index(IO Protocol)
Types and mode constants for file manipulation functions
described in chapter @ref(IOchapter) of this manual.

Vioprotocol.h@\I/O Protocol message formats.

Vmachine.h@\Machine-specific definitions.

Vmigrate.h@\Migration-specific definitions.

Vmouse.h@\Mouse device-specific header information.
Most programs will use the VGTS to handle graphics input.

Vnaming.h@\V-System naming manifests, types, and structures.

Vnet.h@\Network server definitions.
This is included in any programs that use the network.

Vpipe.h@\Definitions and structures for V pipes.

Vprocess.h@\Processor state structure and other process-specific header
information.

Vquerykernel.h@\QueryKernel operation manifests and types.

Vserial.h@\Manifests for the serial lines.

Vsession.h@\Manifests and message structs for the V/@c[Unix] server.

Vspinlock.h@\Definitions for spin locks, a cheap 
mechanism for locking within a team.

Vstorage.h@\Definitions and message formats for the V storage server.

Vteams.h@\Team header file.
Structures used to communicate with the team server
and to pass information to teams when they are
created.

Vtermagent.h@\Information shared by terminal agents and their clients.

Vtime.h@\Structures used in time services,@index(time)
primarily for getting time from a session server.
@end(description)


