@Part( numeric, root "manual" )
@Chapter(Numeric and Mathematical Functions)@Label(numeric)
@index(numeric)@index(math)

@section(Numeric Functions)
Most of the functions in the numeric section of the library are
not called directly in user programs; they are accessed by
the C compiler as needed.  The following functions are useful
in user programs:

@function{unsigned abs(value)
    int value}@index(abs)
Integer absolute value.

@function{int rand()}@index(rand)
Random number generator.  Generates pseudo-random numbers
in the range from 0 to 2@+[31]-1.
This is a very poor generator, identical to
the one provided in Berkeley Unix 4.1.

@function{srand(seed)
    unsigned seed;}@index(srand)
Reseed the @t[rand()] random number generator.

@section(Mathematical Functions)

The math-related functions in the V library are listed below.
They are similar to the ``section 3M'' functions of the Unix library.
See the Unix manual for documentation.

@begin(verbatim)
sin()		cos()		tan()		asin()
acos()		atan()		atan2()		sinh()
cosh()		tanh()		j0()		j1()
jn()		y0()		y1()		yn()
hypot()		cabs()		gamma()		fabs()
foot()		ceil()		exp()		log()
log10()		pow()		sqrt()
@end(verbatim)


