@string(LastEditDate="Tue Jun 17 15:47:44 1986")
@comment(Current maintainer: Keith Lantz)

@Part( mechanics, root "manual" )
@Chapter(Program Construction and Execution)@Label(mechanics)

A V-System C program is constructed and executed similar to a C program
on @c[Unix].  Only the differences are discussed here.

@Section(Writing the C Program)

An application program on the V-System starts to execute as a single 
process@Index[initial process]@index(root process)
on a new team.
By default,
the process is allocated an initial stack area of about 4000 bytes,@Index[initial stack]
just above its uninitialized data segment.
If this is not large enough (or is larger than necessary),
the declaration
@begin(programexample)
int RootStackSize = @i[newsize];
@end(programexample)
can be used to set the initial stack size to @i[newsize] bytes.@index(stack
size)

@Index[malloc]
Note that large dynamically allocated areas of memory should be
allocated using @t[malloc()], @t[calloc()], or a similar memory allocator,
and not be allocated on the process stack.
@begin(warning)
There is no run-time checking for overflowing the
process stack allocation.
The program behavior from stack overflow can be sufficiently
bizarre @Index[stack overflow]
as to cause good programmers to seek refuge in monasteries.@Index[monasteries]
If the stack overflow caused the process in question to get an
exception, the standard exception handling routine
will usually detect the overflow and print a message.  However,
not all stack overflows
cause an exception in the process that generated them,
and sometimes the stack is back in bounds by the time the exception
occurs.
@end(warning)

The file @t[Venviron.h] is a header file defining@Index[Venviron.h]
the types and constants that arise as part of the interface to
the kernel.
It is included by the line
@ProgramExample(#include <Venviron.h>)
Programs that use the V input/output library usually need the
file @t[Vio.h], which corresponds to
the UNIX header file @t[stdio.h].@foot(In
fact, a V program may include @t[stdio.h] in place of @t[Vio.h],
since there is a V version of @t[stdio.h] that simply includes
@t[Vio.h].)
Other V header files, listed in the previous chapter,
are included similarly.

@section(Compiling and Linking)
@index(compiling)@index(linking)

When an application program is compiled and linked,
references to kernel operations and other standard routines
must be resolved by searching
the library file @t[libV.a].@Index[libV.a]
Its entry point must be the @t[@uf()start] routine
found in the library, and it must be relocated correctly
for the target machine it is to run on.
These defaults are automatically selected with the -vV option of
the cc68 or ccvax command.
The compile command:@Index[compile command]
@ProgramExample(cc68 -vV programfile.c -o outputfile.m68k)
or for the Vax,
@ProgramExample(ccvax -vV programfile.c -o outputfile.vax)
produces an executable file for running with the kernel.
The program environment provided
by the @t[libV.a] library is described in the remaining chapters
of this part of the manual.

@Section(Program Execution)
@index(execution)

There are three models for executing V C programs, namely:
@begin(enumerate)
running them in ``bare kernel mode'', that is, directly on top of the kernel

running them from an executive

running them as a subprogram of another program
@end(enumerate)

@subsection(Bare Kernel Mode)
@index(kernel mode)

When a program runs in bare kernel mode, none of the standard servers are
available, unless the program includes one or more of them itself (as
described in Chapter @ref(Servers Overview)).  A
program written to run in bare kernel mode begins execution at a procedure
called @t[main()].  No arguments may be passed to the program.

A program to be executed in bare kernel mode is loaded by a special
loader program called @t[Vload].  For example, on an SMI workstation:
@Index[loader]
@ProgramExample(b Vload)@Index[Vload]
typed to the @c[PROM]
monitor causes it to load and execute the loader, which immediately 
prompts for the name of the file containing the program.
The use of this loader is described more fully in Chapter @ref(Standalone).


@subsection(Execution With the Executive)
Use of the V executive is described in Chapter @ref(UsingExec).
Basically, one types the name of the file containing the program
to the command interpreter followed by zero or more command arguments.
The program is then loaded and executed.

When the V executive is used, program execution again begins at a 
procedure called @t[main()].  This time, however,
a count of the number of arguments to the program
and an array of pointers to the program string arguments,
as given on the command line, are passed to the procedure.  Moreover,
the program is passed standard input, output, and error files, and a variety
of other information through the @t[TeamRoot] message (described below
in Section @ref(Program Initialization)).@index(TeamRoot)

The following example shows how a program can read its command line
arguments.
The variable @t(argc) contains the number of arguments including
the command name.
The arguments are kept in @t(argv[0]) through 
@t(argv[argc-1]); the command name is @t(argv[0]),
@t(argv[1]) is the first argument, @t(argv[argc-1]) 
is the last argument, and @t(argv[argc]) is @c[NULL].
This matches the Unix convention.

@begin(bigProgramExample)
main( argc, argv )
    int argc;
    char *argv[];
    /* Echo arguments */
  {
    int i;

    for( i = 0; i < argc; ++i )
	printf( "%s ", argv[i] );
    putchar("\n");
  }
@end(bigProgramExample)

@subsection(Subprograms)
@index(subprograms)

A program may run another program as a subprogram by invoking the same
library functions employed by the executive.  These functions are described
in Chapter @ref(Exec).

@section(Program Initialization)
@label(Program Initialization)
@index(initialization)

Along with its compiler-generated code and data segments, a newly created
program requires some additional run-time data about its environment before
it can start execution.  This data includes:
@begin(itemize)
File instances for standard input, output, and error output, and
associated flags.

Command-line arguments (argv and argc).

Initial values of environment variables.

Initial contents of the name cache.

Initial naming context (working directory).
@end(itemize)

A program's creator passes this information to the new program in the
 @i(team root message)@index(team root message) used to start its execution,
extended by a @i[team environment block]@index[team environment block] of
machine-independent format placed in the new team space by the creator.  
This information is subsequently unpacked by an initialization routine
(described below) automatically linked in with the new team.

The format of the team root message and team environment block are given
below, using a C-like notation with the following extensions:
@begin(itemize)
The notation @t{char s[]}
(an array of characters of unspecified size) means a null-terminated string.

The keyword @t[repeat] means that the following bracketed structure
may be repeated zero or more times.

The notation @t[align @i[n]] means to insert null bytes to align the
next field to an address evenly divisible by @t[@i[n]].
@end(itemize)
and the following common definitions:
@begin(programexample)
typedef Bit32 unsigned long;	/* unsigned 32-bit quantity */
typedef Bit16 unsigned short;	/* unsigned 16-bit quantity */
@end(programexample)

@subsection(The Team Root Message)
@index(team root message)@index(TeamRoot)

The team root message is sent to the new program just prior to its beginning
execution (details below).  It is formatted as follows:
@Begin(bigprogramexample)
typedef struct
  {
#ifdef LITTLE@uf()ENDIAN
    SystemCode	replycode;
    Bit16	rootflags;		/* Flags; see below */
    InstanceId	stdinfile;		/* Standard I/O instance ids */
    InstanceId  stdoutfile;
    InstanceId	stderrfile;
    Bit16	reserved1;
#else LITTLE@uf()ENDIAN
    Bit16	rootflags;
    SystemCode	replycode;
    InstanceId  stdoutfile;
    InstanceId	stdinfile;
    Bit16	reserved1;
    InstanceId	stderrfile;
#endif LITTLE@uf()ENDIAN
    ProcessId	stdinserver;		/* Standard I/O servers */
    ProcessId	stdoutserver;
    ProcessId	stderrserver;
    Bit32	reserved2;		/* Reserved for expansion of
    					 *  InstanceId to 32 bits */
    TeamEnvironmentBlock *teb;
  }
RootMessage;
@hinge
/* Root flags - bit assignments */
#define RELEASE@uf()INPUT	0x0010	  /* Release stdin on close */
#define RELEASE@uf()OUTPUT	0x0020    /* Release stdout on close */
#define RELEASE@uf()ERR		0x0040	  /* Release stderr on close */
#define STDOUT@uf()APPEND	0x0001 	  /* Open stdout for append */
#define STDERR@uf()APPEND	0x0080	  /* Open stderr for append */
@End(bigprogramexample)

@subsection(The Team Environment Block)
@index(team environment block)

The team environment block is formatted as follows:
@begin(bigprogramexample)
typedef struct
  {
    align 4;
    Bit32 blocksize;	/* Total size of block in bytes */
    Bit32 argc;		/* Number of arguments */
    repeat
      {
	char arg[];
      }
    args;
@hinge
    align 4;
    Bit32 envc;		/* Number of environment variables */
    repeat
      {
	char name[];
	char value[];
      }
    env;
@hinge
    align 4;
    Bit32 cachec;	/* Number of cache entries */
    repeat
      {
        align 4;
	ContextPair from;
	ContextPair to;
	Bit16 flags;
	char name[];
	char truename[];
      }
    cache;

    align 4;
    ContextPair ctx;	/* Initial naming context: identifier */
    char ctxname[];	/* Initial naming context: absolute name */
    align 4;
  } 
TeamEnvironmentBlock;
@end(bigprogramexample)
Note that the team environment block,
despite containing variable-length fields,
can be unambiguously parsed left-to-right.

The following library routine is available for creating team environment
blocks:

@function{SystemCode SetUpEnvironment(pid, args, env, cache, where)
    ProcessId pid;
    char *args[];
    EnvironmentVariable *env;
    NameCache *cache;
    char *where;}@index(SetUpEnvironment)
Constructs a team environment block for the specified team, using
the given argument vector, environment variable chain, and name cache,
and the caller's current working context.  The team environment block
is deposited in the new team space at address "where" (rounded up as
necessary for alignment).

@subsection(The Per-Process Area)
@index(per-process area)@label(PerProcess)

In addition to sharing the team environment variables (extracted from the
team root message and team environment block), each process on a team has a
region of team memory reserved for its own use, called its @i[stack space].
A portion of the stack space, called the @i[per-process area], is used to
store a few process-global variables.  (On the Sun and VaxStation, a
process's stack grows downward from the highest address in its stack space,
and the per-process area begins at its lowest address.) A team-global
variable called @t[PerProcess] points to the per-process area.  It is reset
by the kernel to point to the correct area on every process switch.

The standard per-process area is described by the @t[PerProcessArea]
structure in the header file @t<Vio.h>.
It contains the following values:
@begin(description)
@t[stdio]@\An array of three File pointers describing the process's
standard input, output, and error files.  <Vio.h> defines the
macros @t[stdin], @t[stdout], and @t[stderr] to be @t{PerProcess->@|stdio[0]},
@t{PerProcess->@|stdio[1]}, and @t{PerProcess->@|stdio[2]} respectively.
Note that only pointers, not the File structures themselves, are kept
in the per-process areas.

@t[ctx]@\A ContextPair structure giving the context identifier of the
process's current naming context (working directory).

@t[stackSize]@\The size of the process's stack space, in bytes.

@t[ctxname]@\A character string giving the absolute name of the process's
current naming context.  These strings are allocated on the heap
(i.e., by @t[malloc()]) and are freed by the @t[ChangeDirectory()]
library routine.

@t[env]@\A pointer to the list head for this process's environment variable list.

@t[namecache]@\A pointer to the list head for this process's name cache.
@end(description)

A newly created process on the same team as its parent (if
created with the standard @t[Create()] library routine)
inherits a copy of its parent's per-process area,
with the exception of
the @t[stackSize] field, which is specified as a parameter
to @t[Create()], and the @t[ctxname] pointer, which
is modified to point to a fresh copy of the string to avoid the
need for reference counting such strings.
Thus, each child process inherits its
creator's standard I/O, current naming context, name cache,
and environment variables.

@subsection(Initialization Procedure)

A new program is created in the @i(awaiting reply) state, waiting for a
(reply) message from its creator.  In effect, the kernel simulates a
@t[Send] from the initial process of the program to its creator, in response
to which the creator must @t[Reply] before the program can begin execution.
Prior to replying, the creator has access to the new team's entire address
space and uses @t[CopyTo()] to deposit the team environment block of the new
program.
@Begin(note)
The creator is responsible for passing the 16- and 32-bit fields in
the team environment block in the correct byte order for the new team's host
machine.  This is in accord with the general convention that senders of
messages use their native byte order, with receivers being responsible for
byte-swapping if necessary.  In this case, the new team is logically the
sender in its initial transaction.
@End(note)
Finally, the creator invokes @t[Reply()] to set the new program running; the
reply message constitutes the team root message.  (See Chapter @ref(Process)
for details of the interprocess communication primitives used.)

Meanwhile, the new program is blocked in the middle of its initialization
code.  This code is structured as a small assembly-language routine
containing the team's initial entry point (@t[@uf()start]), plus a
machine-independent routine @t[TeamRoot()], called from @t[@uf()start].
@t[@uf()start] initializes the stack, receives the team root message, zeros
the initial data segment (bss) and then calls @t[TeamRoot()] to do the rest
of the initialization.  @t[TeamRoot()] ``unpacks'' the team root message and
team environment block, placing pieces of data in global variables or 
on the stack or heap as required by the host machine and
programming language.  The team environment block is discarded after having
been unpacked; generally, the memory it occupied is reused as stack space.
When @t[TeamRoot()] returns, @t[@uf()start] calls
 @t[main()], the main function of the C program being executed.  Finally, if
 @t[main()] ever returns, @t[@uf()start] calls @t[exit()] with the value
returned by @t[main()].

